/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util.visual;

import android.app.Activity;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class ViewTreeStatusObservable {
    private static final String TAG = "SA.ViewTreeStatusObservable";
    public static volatile ViewTreeStatusObservable viewTreeStatusObservable;
    private SparseArray<ViewNode> mViewNodesWithHashCode = new SparseArray();
    private HashMap<String, ViewNode> mViewNodesHashMap = new HashMap();
    private HashMap<String, ViewNode> mWebViewHashMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ViewTreeStatusObservable getInstance() {
        if (viewTreeStatusObservable != null) return viewTreeStatusObservable;
        Class<ViewTreeStatusObservable> clazz = ViewTreeStatusObservable.class;
        synchronized (ViewTreeStatusObservable.class) {
            if (viewTreeStatusObservable != null) return viewTreeStatusObservable;
            viewTreeStatusObservable = new ViewTreeStatusObservable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return viewTreeStatusObservable;
        }
    }

    public ViewNode getViewNode(View view) {
        ViewNode viewNode = null;
        try {
            viewNode = this.getViewPathAndPosition(view);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return viewNode;
    }

    public void clearViewNodeCache() {
        this.mViewNodesWithHashCode.clear();
        this.mViewNodesHashMap.clear();
    }

    public ViewNode getViewNode(WeakReference<View> reference, String elementPath, String elementPosition, String screenName) {
        ViewNode viewNode = null;
        try {
            viewNode = this.mViewNodesHashMap.get(this.generateKey(elementPath, elementPosition, screenName));
            if (viewNode == null) {
                Activity activity;
                View rootView = null;
                if (reference != null && reference.get() != null) {
                    rootView = ((View)reference.get()).getRootView();
                }
                if (rootView == null && (activity = AppStateTools.getInstance().getForegroundActivity()) != null && activity.getWindow() != null && activity.getWindow().isActive()) {
                    rootView = activity.getWindow().getDecorView();
                }
                if (rootView != null) {
                    this.traverseNode(rootView);
                }
                viewNode = this.mViewNodesHashMap.get(this.generateKey(elementPath, elementPosition, screenName));
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return viewNode;
    }

    public ViewNode getViewNode(String elementPath) {
        ViewNode viewNode = null;
        try {
            viewNode = this.mWebViewHashMap.get(elementPath);
            if (viewNode == null || viewNode.getView() == null || viewNode.getView().get() == null) {
                View rootView = null;
                Activity activity = AppStateTools.getInstance().getForegroundActivity();
                if (activity != null && activity.getWindow() != null && activity.getWindow().isActive()) {
                    rootView = activity.getWindow().getDecorView();
                }
                if (rootView != null) {
                    this.traverseNode(rootView);
                }
                viewNode = this.mWebViewHashMap.get(elementPath);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return viewNode;
    }

    public void clearWebViewCache() {
        try {
            if (this.mWebViewHashMap != null) {
                this.mWebViewHashMap.clear();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private void traverseNode() {
        this.traverseNode(null);
    }

    private void traverseNode(View rootView) {
        try {
            this.mViewNodesHashMap.clear();
            this.mViewNodesWithHashCode.clear();
            this.mWebViewHashMap.clear();
            SparseArray tempSparseArray = new SparseArray();
            HashMap<String, ViewNode> tempHashMap = new HashMap<String, ViewNode>();
            HashMap<String, ViewNode> tempWebViewHashMap = new HashMap<String, ViewNode>();
            if (rootView != null) {
                this.traverseNode(rootView, (SparseArray<ViewNode>)tempSparseArray, tempHashMap, tempWebViewHashMap);
            } else {
                View[] views;
                for (View view : views = WindowHelper.getSortedWindowViews()) {
                    this.traverseNode(view, (SparseArray<ViewNode>)tempSparseArray, tempHashMap, tempWebViewHashMap);
                }
            }
            this.mViewNodesHashMap = tempHashMap;
            this.mViewNodesWithHashCode = tempSparseArray;
            this.mWebViewHashMap = tempWebViewHashMap;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public List<View> getCurrentWebView() {
        try {
            if (this.mWebViewHashMap.size() == 0) {
                this.traverseNode();
            }
            if (this.mWebViewHashMap.size() > 0) {
                ArrayList<View> list = new ArrayList<View>();
                for (ViewNode viewNode : this.mWebViewHashMap.values()) {
                    WeakReference<View> reference = viewNode.getView();
                    if (reference == null || reference.get() == null) continue;
                    list.add((View)reference.get());
                }
                return list;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    private String generateKey(String elementPath, String elementPosition, String screenName) {
        StringBuilder key = new StringBuilder();
        key.append(elementPath);
        if (!TextUtils.isEmpty((CharSequence)elementPosition)) {
            key.append(elementPosition);
        }
        if (!TextUtils.isEmpty((CharSequence)screenName)) {
            key.append(screenName);
        }
        return key.toString();
    }

    private void traverseNode(View view, SparseArray<ViewNode> sparseArray, HashMap<String, ViewNode> hashMap, HashMap<String, ViewNode> webViewHashMap) {
        try {
            if (view == null) {
                return;
            }
            ViewNode viewNode = this.getCacheViewPathAndPosition(view, true);
            if (viewNode != null) {
                String screenName;
                JSONObject jsonObject;
                sparseArray.put(view.hashCode(), (Object)viewNode);
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPath()) && (jsonObject = SAViewUtils.getScreenNameAndTitle(view)) != null && !TextUtils.isEmpty((CharSequence)(screenName = jsonObject.optString("$screen_name")))) {
                    if (!TextUtils.isEmpty((CharSequence)viewNode.getViewContent())) {
                        hashMap.put(this.generateKey(viewNode.getViewPath(), viewNode.getViewPosition(), screenName), viewNode);
                    }
                    if (ViewUtil.instanceOfWebView(view)) {
                        webViewHashMap.put(viewNode.getViewPath() + screenName, viewNode);
                    }
                }
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int childCount = group.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    View child = group.getChildAt(i);
                    if (child == null) continue;
                    this.traverseNode(child, sparseArray, hashMap, webViewHashMap);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public ViewNode getViewPathAndPosition(View clickView) {
        return this.getSingleViewPathAndPosition(clickView, false);
    }

    private ViewNode getCacheViewPathAndPosition(View clickView, boolean fromVisual) {
        ViewNode currentNode = (ViewNode)this.mViewNodesWithHashCode.get(clickView.hashCode());
        if (currentNode != null) {
            return currentNode;
        }
        View parent_view = null;
        ViewParent viewParent = clickView.getParent();
        if (viewParent instanceof ViewGroup) {
            parent_view = (View)viewParent;
        }
        if (parent_view == null) {
            currentNode = ViewUtil.getViewPathAndPosition(clickView, fromVisual);
        } else {
            int replacePosition;
            int viewPosition;
            StringBuilder opx = new StringBuilder();
            StringBuilder px = new StringBuilder();
            ViewNode parentNode = (ViewNode)this.mViewNodesWithHashCode.get(parent_view.hashCode());
            if (parentNode == null) {
                parentNode = ViewUtil.getViewPathAndPosition(parent_view, fromVisual);
                this.mViewNodesWithHashCode.put(parent_view.hashCode(), (Object)parentNode);
            }
            String listPosition = "";
            if (parentNode != null) {
                opx.append(parentNode.getViewOriginalPath());
                px.append(parentNode.getViewPath());
                listPosition = parentNode.getViewPosition();
            }
            if ((currentNode = ViewUtil.getViewNode(clickView, viewPosition = ((ViewGroup)parent_view).indexOfChild(clickView), fromVisual)) != null && !TextUtils.isEmpty((CharSequence)currentNode.getViewPath()) && currentNode.getViewPath().contains("-") && !TextUtils.isEmpty((CharSequence)listPosition) && (replacePosition = px.lastIndexOf("-")) != -1) {
                px.replace(replacePosition, replacePosition + 1, String.valueOf(listPosition));
            }
            if (currentNode != null) {
                opx.append(currentNode.getViewOriginalPath());
                px.append(currentNode.getViewPath());
                currentNode = new ViewNode(clickView, currentNode.getViewPosition(), opx.toString(), px.toString(), currentNode.getViewContent());
            }
        }
        this.mViewNodesWithHashCode.put(clickView.hashCode(), (Object)currentNode);
        return currentNode;
    }

    private ViewNode getSingleViewPathAndPosition(View clickView, boolean fromVisual) {
        ViewNode currentNode;
        View parent_view = null;
        ViewParent viewParent = clickView.getParent();
        if (viewParent instanceof ViewGroup) {
            parent_view = (View)viewParent;
        }
        if (parent_view == null) {
            currentNode = ViewUtil.getViewPathAndPosition(clickView, fromVisual);
        } else {
            int viewPosition;
            StringBuilder opx = new StringBuilder();
            StringBuilder px = new StringBuilder();
            ViewNode parentNode = ViewUtil.getViewPathAndPosition(parent_view, fromVisual);
            String listPosition = "";
            if (parentNode != null) {
                opx.append(parentNode.getViewOriginalPath());
                px.append(parentNode.getViewPath());
                listPosition = parentNode.getViewPosition();
            }
            if ((currentNode = ViewUtil.getViewNode(clickView, viewPosition = ((ViewGroup)parent_view).indexOfChild(clickView), fromVisual)) != null) {
                int replacePosition;
                if (!TextUtils.isEmpty((CharSequence)currentNode.getViewPath()) && currentNode.getViewPath().contains("-") && !TextUtils.isEmpty((CharSequence)listPosition) && (replacePosition = px.lastIndexOf("-")) != -1) {
                    px.replace(replacePosition, replacePosition + 1, String.valueOf(listPosition));
                }
                opx.append(currentNode.getViewOriginalPath());
                px.append(currentNode.getViewPath());
                currentNode = new ViewNode(clickView, currentNode.getViewPosition(), opx.toString(), px.toString(), currentNode.getViewContent());
            }
        }
        return currentNode;
    }
}

