/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakSet<T>
implements Set<T> {
    private static final Object PRESENT = new Object();
    private transient WeakHashMap<T, Object> map;

    @Override
    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (this.isEmpty() || o == null) {
            return false;
        }
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.isEmpty()) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("method toArray() not supported");
    }

    @Override
    public <T1> T1[] toArray(T1[] t1Arr) {
        throw new UnsupportedOperationException("method toArray(T[] a) not supported");
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new IllegalArgumentException("The argument t can't be null");
        }
        if (this.map == null) {
            this.map = new WeakHashMap();
        }
        return this.map.put(t, PRESENT) != null;
    }

    @Override
    public boolean remove(Object o) {
        return !this.isEmpty() && o != null && this.map.remove(o) == PRESENT;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("method containsAll not supported");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("method addAll not supported now");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("method retainAll not supported now");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("method removeAll not supported now");
    }

    @Override
    public void clear() {
        if (this.map != null) {
            this.map.clear();
        }
    }

    private static class NonEmptyIterator<E>
    implements Iterator<E> {
        private final Iterator<WeakReference<E>> iterator;

        private NonEmptyIterator(Iterator<WeakReference<E>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return (E)this.iterator.next().get();
        }
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        private static EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new UnsupportedOperationException("EmptyIterator should not call this method directly");
        }
    }
}

