/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.SAPropertyManager;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.internal.beans.LimitKey;
import com.sensorsdata.analytics.android.sdk.jsbridge.AppWebViewInterface;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SASchemeHelper;
import com.sensorsdata.analytics.android.sdk.util.SnapCache;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public final class SensorsDataUtils {
    private static final String SHARED_PREF_APP_VERSION = "sensorsdata.app.version";
    public static final String COMMAND_HARMONYOS_VERSION = "getprop hw_sc.build.platform.version";
    private static boolean isUniApp = false;
    private static String androidID = "";
    private static boolean isAndroidIDEnabled = true;
    private static boolean isOAIDEnabled = true;
    private static final List<String> mInvalidAndroidId = new ArrayList<String>(){
        {
            this.add("9774d56d682e549c");
            this.add("0123456789abcdef");
            this.add("0000000000000000");
        }
    };
    private static final String TAG = "SA.SensorsDataUtils";

    public static String getActivityTitle(Activity activity) {
        try {
            if (activity != null) {
                try {
                    ActivityInfo activityInfo;
                    PackageManager packageManager;
                    String toolbarTitle;
                    String activityTitle = null;
                    if (Build.VERSION.SDK_INT >= 11 && !TextUtils.isEmpty((CharSequence)(toolbarTitle = SensorsDataUtils.getToolbarTitle(activity)))) {
                        activityTitle = toolbarTitle;
                    }
                    if (TextUtils.isEmpty(activityTitle)) {
                        activityTitle = activity.getTitle().toString();
                    }
                    if (TextUtils.isEmpty(activityTitle) && (packageManager = activity.getPackageManager()) != null && !TextUtils.isEmpty((CharSequence)(activityInfo = packageManager.getActivityInfo(activity.getComponentName(), 0)).loadLabel(packageManager))) {
                        activityTitle = activityInfo.loadLabel(packageManager).toString();
                    }
                    return activityTitle;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    public static String getToolbarTitle(Activity activity) {
        block10: {
            try {
                String canonicalName = SnapCache.getInstance().getCanonicalName(activity.getClass());
                if ("com.tencent.connect.common.AssistActivity".equals(canonicalName)) {
                    if (!TextUtils.isEmpty((CharSequence)activity.getTitle())) {
                        return activity.getTitle().toString();
                    }
                    return null;
                }
                ActionBar actionBar = null;
                if (Build.VERSION.SDK_INT >= 11) {
                    actionBar = activity.getActionBar();
                }
                if (actionBar != null) {
                    if (Build.VERSION.SDK_INT >= 11 && !TextUtils.isEmpty((CharSequence)actionBar.getTitle())) {
                        return actionBar.getTitle().toString();
                    }
                    break block10;
                }
                try {
                    CharSequence charSequence;
                    Method method;
                    Object supportActionBar;
                    Class<?> appCompatActivityClass = SensorsDataUtils.compatActivity();
                    if (appCompatActivityClass != null && appCompatActivityClass.isInstance(activity) && (supportActionBar = (method = activity.getClass().getMethod("getSupportActionBar", new Class[0])).invoke((Object)activity, new Object[0])) != null && (charSequence = (CharSequence)(method = supportActionBar.getClass().getMethod("getTitle", new Class[0])).invoke(supportActionBar, new Object[0])) != null) {
                        return charSequence.toString();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
        return null;
    }

    private static Class<?> compatActivity() {
        Class<?> appCompatActivityClass = null;
        try {
            appCompatActivityClass = ReflectUtil.getClassByName("android.support.v7.app.AppCompatActivity");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (appCompatActivityClass == null) {
            try {
                appCompatActivityClass = ReflectUtil.getClassByName("androidx.appcompat.app.AppCompatActivity");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return appCompatActivityClass;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getIdentifier(Context context) {
        try {
            if (!isAndroidIDEnabled) {
                SALog.i(TAG, "SensorsData getAndroidID is disabled");
                return "";
            }
            if (SAPropertyManager.getInstance().isLimitKey(LimitKey.ANDROID_ID)) {
                return SAPropertyManager.getInstance().getLimitValue(LimitKey.ANDROID_ID);
            }
            if (TextUtils.isEmpty((CharSequence)androidID)) {
                SALog.i(TAG, "SensorsData getIdentifier");
                androidID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                if (!SensorsDataUtils.isValidAndroidId(androidID)) {
                    androidID = "";
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return androidID;
    }

    public static boolean isValidAndroidId(String androidId) {
        if (TextUtils.isEmpty((CharSequence)androidId)) {
            return false;
        }
        return !mInvalidAndroidId.contains(androidId.toLowerCase(Locale.getDefault()));
    }

    public static boolean checkVersionIsNew(Context context, String currVersion) {
        try {
            String localVersion = SAStoreManager.getInstance().getString(SHARED_PREF_APP_VERSION, "");
            if (!TextUtils.isEmpty((CharSequence)currVersion) && !currVersion.equals(localVersion)) {
                SAStoreManager.getInstance().setString(SHARED_PREF_APP_VERSION, currVersion);
                return true;
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return true;
        }
        return false;
    }

    public static void handleSchemeUrl(Activity activity, Intent intent) {
        SASchemeHelper.handleSchemeUrl(activity, intent);
    }

    @Deprecated
    public static void mergeJSONObject(JSONObject source, JSONObject dest) {
        try {
            JSONUtils.mergeJSONObject(source, dest);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public static void initUniAppStatus() {
        try {
            Class.forName("io.dcloud.application.DCloudApplication");
            isUniApp = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isUniApp() {
        return isUniApp;
    }

    public static void showUpWebView(Context context, Object x5WebView, JSONObject properties, boolean isSupportJellyBean, boolean enableVerify) {
        try {
            SALog.i(TAG, "SensorsDataUtils.showUpWebView called.x5WebView = " + x5WebView + ", isSupportJellyBean = " + isSupportJellyBean + ", enableVerify = " + enableVerify);
            if (Build.VERSION.SDK_INT < 17 && !isSupportJellyBean) {
                SALog.d(TAG, "For applications targeted to API level JELLY_BEAN or below, this feature NOT SUPPORTED");
                return;
            }
            if (x5WebView == null) {
                return;
            }
            try {
                Class<?> clazz = x5WebView.getClass();
                try {
                    Method getSettingsMethod = clazz.getMethod("getSettings", new Class[0]);
                    Object settings = getSettingsMethod.invoke(x5WebView, new Object[0]);
                    if (settings != null) {
                        Method setJavaScriptEnabledMethod = settings.getClass().getMethod("setJavaScriptEnabled", Boolean.TYPE);
                        setJavaScriptEnabledMethod.invoke(settings, true);
                    }
                }
                catch (Exception getSettingsMethod) {
                    // empty catch block
                }
                Method addJavascriptInterface = clazz.getMethod("addJavascriptInterface", Object.class, String.class);
                addJavascriptInterface.invoke(x5WebView, new AppWebViewInterface(context, properties, enableVerify), "SensorsData_APP_JS_Bridge");
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "addVisualJavascriptInterface", x5WebView);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void enableAndroidId(boolean enabled) {
        isAndroidIDEnabled = enabled;
    }

    public static void enableOAID(boolean enabled) {
        isOAIDEnabled = enabled;
    }

    public static boolean isOAIDEnabled() {
        return isOAIDEnabled;
    }
}

