/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPIEmptyImplementation;
import com.sensorsdata.analytics.android.sdk.core.business.visual.SAVisualTools;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.remote.BaseSensorsDataSDKRemoteManager;
import com.sensorsdata.analytics.android.sdk.remote.SensorsDataRemoteManagerDebug;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.util.ToastUtil;

public class SASchemeHelper {
    private static final String TAG = "SA.SASchemeUtil";

    public static void handleSchemeUrl(Activity activity, Intent intent) {
        block22: {
            if (SensorsDataAPI.isSDKDisabled()) {
                SALog.i(TAG, "SDK is disabled,scan code function has been turned off");
                return;
            }
            if (SensorsDataAPI.sharedInstance() instanceof SensorsDataAPIEmptyImplementation) {
                SALog.i(TAG, "SDK is not init");
                return;
            }
            try {
                Uri uri = null;
                if (activity != null && intent != null) {
                    uri = intent.getData();
                }
                SALog.i(TAG, "handleSchemeUrl uri = " + uri + ", intent = " + intent);
                if (uri == null) break block22;
                SensorsDataAPI sensorsDataAPI = SensorsDataAPI.sharedInstance();
                String host = uri.getHost();
                if ("channeldebug".equals(host) || "adsScanDeviceInfo".equals(host)) {
                    SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "handlerScanUri", activity, uri);
                    intent.setData(null);
                    break block22;
                }
                if ("heatmap".equals(host)) {
                    String featureCode = uri.getQueryParameter("feature_code");
                    String postUrl = uri.getQueryParameter("url");
                    SAVisualTools.showOpenHeatMapDialog(activity, featureCode, postUrl);
                    intent.setData(null);
                    break block22;
                }
                if ("debugmode".equals(host)) {
                    String infoId = uri.getQueryParameter("info_id");
                    String locationHref = uri.getQueryParameter("sf_push_distinct_id");
                    String project = uri.getQueryParameter("project");
                    SensorsDataDialogUtils.showDebugModeSelectDialog(activity, infoId, locationHref, project);
                    intent.setData(null);
                    break block22;
                }
                if ("visualized".equals(host)) {
                    String featureCode = uri.getQueryParameter("feature_code");
                    String postUrl = uri.getQueryParameter("url");
                    SAVisualTools.showOpenVisualizedAutoTrackDialog(activity, featureCode, postUrl);
                    intent.setData(null);
                    break block22;
                }
                if ("popupwindow".equals(host)) {
                    SensorsDataDialogUtils.showPopupWindowDialog(activity, uri);
                    intent.setData(null);
                    break block22;
                }
                if ("encrypt".equals(host)) {
                    String tip = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "verifySecretKey", uri);
                    if (TextUtils.isEmpty((CharSequence)tip)) {
                        tip = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_encrypt_sdk_fail);
                    }
                    ToastUtil.showLong((Context)activity, tip);
                    SensorsDataDialogUtils.startLaunchActivity((Context)activity);
                    intent.setData(null);
                    break block22;
                }
                if ("abtest".equals(host)) {
                    try {
                        ReflectUtil.callStaticMethod(Class.forName("com.sensorsdata.abtest.core.SensorsABTestSchemeHandler"), "handleSchemeUrl", uri.toString());
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                    SensorsDataDialogUtils.startLaunchActivity((Context)activity);
                    intent.setData(null);
                    break block22;
                }
                if ("sensorsdataremoteconfig".equals(host)) {
                    SensorsDataAPI.sharedInstance().enableLog(true);
                    BaseSensorsDataSDKRemoteManager sensorsDataSDKRemoteManager = sensorsDataAPI.getSAContextManager().getRemoteManager();
                    if (sensorsDataSDKRemoteManager != null) {
                        sensorsDataSDKRemoteManager.resetPullSDKConfigTimer();
                    }
                    SensorsDataRemoteManagerDebug sensorsDataRemoteManagerDebug = new SensorsDataRemoteManagerDebug(sensorsDataAPI, activity.getBaseContext());
                    sensorsDataAPI.getSAContextManager().setRemoteManager(sensorsDataRemoteManagerDebug);
                    SALog.i(TAG, "Start debugging remote config");
                    sensorsDataRemoteManagerDebug.checkRemoteConfig(uri, activity);
                    intent.setData(null);
                } else if ("assistant".equals(host)) {
                    SAConfigOptions configOptions = SensorsDataAPI.getConfigOptions();
                    if (configOptions != null && configOptions.isDisableDebugAssistant()) {
                        return;
                    }
                    String service = uri.getQueryParameter("service");
                    if ("pairingCode".equals(service)) {
                        SAVisualTools.showPairingCodeInputDialog((Context)activity);
                    }
                } else {
                    SensorsDataDialogUtils.startLaunchActivity((Context)activity);
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
    }
}

