/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.exceptions.InvalidDataException;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SADataHelper {
    private static final String TAG = "SA.SADataHelper";
    private static final Pattern KEY_PATTERN = Pattern.compile("^((?!^distinct_id$|^original_id$|^time$|^properties$|^id$|^first_id$|^second_id$|^users$|^events$|^event$|^user_id$|^date$|^datetime$|^user_tag.*|^user_group.*)[a-zA-Z_$][a-zA-Z\\d_$]*)$", 2);
    public static final int MAX_LENGTH_1024 = 1024;
    private static final int MAX_LENGTH_100 = 100;

    public static void assertPropertyTypes(JSONObject properties) throws InvalidDataException {
        if (properties == null) {
            return;
        }
        Iterator iterator = properties.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                if (!SADataHelper.assertPropertyKey(key)) {
                    iterator.remove();
                    continue;
                }
                Object value = properties.get(key);
                if (value == JSONObject.NULL) {
                    SALog.i(TAG, "Property value is empty or null");
                    iterator.remove();
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    int size = list.size();
                    JSONArray array = new JSONArray();
                    for (int i = 0; i < size; ++i) {
                        array.put((Object)SADataHelper.formatString(list.get(i)));
                    }
                    properties.put(key, (Object)array);
                    continue;
                }
                if (!(value instanceof CharSequence || value instanceof Number || value instanceof JSONArray || value instanceof Boolean || value instanceof Date)) {
                    SALog.i(TAG, "The property value must be an instance of CharSequence/Number/Boolean/JSONArray/Date/List<String>. [key='" + key + "', value='" + value.toString() + "', class='" + value.getClass().getCanonicalName() + "']");
                    iterator.remove();
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    for (int i = 0; i < array.length(); ++i) {
                        array.put(i, (Object)SADataHelper.formatString(array.opt(i)));
                    }
                    continue;
                }
                if ("app_crashed_reason".equals(key) && value instanceof String && ((String)value).length() > 16382) {
                    SALog.d(TAG, "The property value is too long. [key='" + key + "', value='" + value + "']");
                    value = ((String)value).substring(0, 16382) + "$";
                    properties.put(key, value);
                    continue;
                }
                if (!(value instanceof String) || ((String)value).length() <= 8191) continue;
                properties.put(key, (Object)(((String)value).substring(0, 8191) + "$"));
                SALog.d(TAG, "The property value is too long. [key='" + key + "', value='" + value + "']");
            }
            catch (JSONException e) {
                throw new InvalidDataException("Unexpected property key. [key='" + key + "']");
            }
            catch (Error e) {
                SALog.i(TAG, e);
            }
        }
    }

    public static void assertEventName(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            SALog.i(TAG, "EventName is empty or null");
            return;
        }
        int length = key.length();
        if (length > 100) {
            SALog.i(TAG, key + "'s length is longer than " + 100);
            return;
        }
        if (!KEY_PATTERN.matcher(key).matches()) {
            SALog.i(TAG, key + " is invalid");
        }
    }

    public static boolean assertPropertyKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            SALog.i(TAG, "Property key is empty or null");
            return false;
        }
        if (!KEY_PATTERN.matcher(key).matches()) {
            SALog.i(TAG, key + " is invalid");
            return false;
        }
        int length = key.length();
        if (length > 100) {
            SALog.i(TAG, key + "'s length is longer than " + 100);
        }
        return true;
    }

    public static void assertItemId(String key) {
        if (null == key) {
            SALog.i(TAG, "ItemId is empty or null");
            return;
        }
        int length = key.length();
        if (length > 1024) {
            SALog.i(TAG, key + "'s length is longer than " + 1024);
        }
    }

    public static void assertDistinctId(String value) throws InvalidDataException {
        if (TextUtils.isEmpty((CharSequence)value)) {
            throw new InvalidDataException("Id is empty or null");
        }
        if (value.length() > 1024) {
            SALog.i(TAG, value + "'s length is longer than " + 1024);
        }
    }

    public static String assertPropertyValue(String property) {
        if (property == null) {
            SALog.i(TAG, "Property value is empty or null");
            return property;
        }
        if (property.length() > 1024) {
            SALog.i(TAG, property + "'s length is longer than " + 1024);
        }
        return property;
    }

    public static JSONObject appendLibMethodAutoTrack(JSONObject jsonObject) {
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        try {
            jsonObject.put("$lib_method", (Object)"autoTrack");
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        return jsonObject;
    }

    public static void addTimeProperty(JSONObject jsonObject) {
        if (!jsonObject.has("$time")) {
            try {
                jsonObject.put("$time", (Object)new Date(System.currentTimeMillis()));
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }
    }

    public static String formatString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            return TimeUtils.formatDate((Date)value);
        }
        return value.toString();
    }

    public static String gzipData(String rawMessage) throws InvalidDataException {
        DeflaterOutputStream gos = null;
        try {
            byte[] bytes = rawMessage.getBytes("UTF-8");
            ByteArrayOutputStream os = new ByteArrayOutputStream(bytes.length);
            gos = new GZIPOutputStream(os);
            gos.write(bytes);
            gos.close();
            byte[] compressed = os.toByteArray();
            os.close();
            String string2 = new String(Base64Coder.encode(compressed));
            return string2;
        }
        catch (IOException exception) {
            throw new InvalidDataException(exception);
        }
        finally {
            if (gos != null) {
                try {
                    gos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static void closeStream(BufferedOutputStream bout, OutputStream out, InputStream in, HttpURLConnection connection) {
        if (null != bout) {
            try {
                bout.close();
            }
            catch (Exception e) {
                SALog.i(TAG, e.getMessage());
            }
        }
        if (null != out) {
            try {
                out.close();
            }
            catch (Exception e) {
                SALog.i(TAG, e.getMessage());
            }
        }
        if (null != in) {
            try {
                in.close();
            }
            catch (Exception e) {
                SALog.i(TAG, e.getMessage());
            }
        }
        if (null != connection) {
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                SALog.i(TAG, e.getMessage());
            }
        }
    }
}

