/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.PermissionUtils;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class NetworkUtils {
    private static final int HTTP_307 = 307;
    private static String networkType;
    private static final String TAG = "SA.NetworkUtils";
    private static SABroadcastReceiver mReceiver;
    private static SANetworkCallbackImpl networkCallback;

    public static String networkType(Context context) {
        try {
            if (!TextUtils.isEmpty((CharSequence)networkType) && !"NULL".equals(networkType)) {
                return networkType;
            }
            if (!PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                networkType = "NULL";
                return networkType;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null) {
                if (!NetworkUtils.isNetworkAvailable(connectivityManager)) {
                    networkType = "NULL";
                    return networkType;
                }
                if (NetworkUtils.isWiFiNetwork(connectivityManager)) {
                    networkType = "WIFI";
                    return networkType;
                }
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            networkType = NetworkUtils.mobileNetworkType(context, telephonyManager, connectivityManager);
            return networkType;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            networkType = "NULL";
            return networkType;
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public static boolean isNetworkAvailable(Context context) {
        if (!PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            return NetworkUtils.isNetworkAvailable(cm);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    public static boolean isShouldFlush(String networkType, int flushNetworkPolicy) {
        return (NetworkUtils.toNetworkType(networkType) & flushNetworkPolicy) != 0;
    }

    private static int toNetworkType(String networkType) {
        if ("NULL".equals(networkType)) {
            return 255;
        }
        if ("WIFI".equals(networkType)) {
            return 8;
        }
        if ("2G".equals(networkType)) {
            return 1;
        }
        if ("3G".equals(networkType)) {
            return 2;
        }
        if ("4G".equals(networkType)) {
            return 4;
        }
        if ("5G".equals(networkType)) {
            return 16;
        }
        return 255;
    }

    @SuppressLint(value={"WrongConstant"})
    public static boolean isNetworkValid(NetworkCapabilities capabilities) {
        if (capabilities != null && Build.VERSION.SDK_INT >= 21) {
            return capabilities.hasTransport(1) || capabilities.hasTransport(0) || capabilities.hasTransport(3) || capabilities.hasTransport(7) || capabilities.hasTransport(4) || capabilities.hasCapability(16);
        }
        return false;
    }

    public static boolean needRedirects(int responseCode) {
        return responseCode == 301 || responseCode == 302 || responseCode == 307;
    }

    public static String getLocation(HttpURLConnection connection, String path) throws MalformedURLException {
        if (connection == null || TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        String location = connection.getHeaderField("Location");
        if (TextUtils.isEmpty((CharSequence)location)) {
            location = connection.getHeaderField("location");
        }
        if (TextUtils.isEmpty((CharSequence)location)) {
            return null;
        }
        if (!location.startsWith("http://") && !location.startsWith("https://")) {
            URL originUrl = new URL(path);
            location = originUrl.getProtocol() + "://" + originUrl.getHost() + location;
        }
        return location;
    }

    public static void registerNetworkListener(Context context) {
        try {
            if (Build.VERSION.SDK_INT < 21) {
                if (mReceiver == null) {
                    mReceiver = new SABroadcastReceiver();
                }
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                context.registerReceiver((BroadcastReceiver)mReceiver, intentFilter);
                SALog.i(TAG, "Register BroadcastReceiver");
            } else {
                if (Build.VERSION.SDK_INT >= 23 && !PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                    return;
                }
                if (networkCallback == null) {
                    networkCallback = new SANetworkCallbackImpl();
                }
                NetworkRequest request = new NetworkRequest.Builder().build();
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager != null) {
                    connectivityManager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)networkCallback);
                    SALog.i(TAG, "Register ConnectivityManager");
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void unregisterNetworkListener(Context context) {
        try {
            if (Build.VERSION.SDK_INT < 21) {
                if (mReceiver == null) {
                    return;
                }
                context.unregisterReceiver((BroadcastReceiver)mReceiver);
                SALog.i(TAG, "unregisterReceiver BroadcastReceiver");
            } else {
                if (networkCallback == null) {
                    return;
                }
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager != null) {
                    connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)networkCallback);
                    SALog.i(TAG, "unregister ConnectivityManager");
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void cleanNetworkTypeCache() {
        networkType = null;
    }

    private static boolean isNetworkAvailable(ConnectivityManager connectivityManager) {
        if (connectivityManager != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                NetworkCapabilities capabilities;
                Network network = connectivityManager.getActiveNetwork();
                if (network != null && (capabilities = connectivityManager.getNetworkCapabilities(network)) != null) {
                    return NetworkUtils.isNetworkValid(capabilities);
                }
            } else {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                return networkInfo != null && networkInfo.isConnected();
            }
        }
        return false;
    }

    private static boolean isWiFiNetwork(ConnectivityManager connectivityManager) {
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities capabilities;
            Network network = connectivityManager.getActiveNetwork();
            if (network != null && (capabilities = connectivityManager.getNetworkCapabilities(network)) != null) {
                return capabilities.hasTransport(1);
            }
        } else {
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            return networkInfo != null && networkInfo.isConnectedOrConnecting();
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private static String mobileNetworkType(Context context, TelephonyManager telephonyManager, ConnectivityManager connectivityManager) {
        int networkType = 0;
        if (telephonyManager != null) {
            if (Build.VERSION.SDK_INT < 30) {
                networkType = telephonyManager.getNetworkType();
            } else if (PermissionUtils.checkSelfPermission(context, "android.permission.READ_PHONE_STATE") || telephonyManager.hasCarrierPrivileges()) {
                networkType = telephonyManager.getDataNetworkType();
            }
        }
        if (networkType == 0) {
            NetworkInfo networkInfo;
            if (Build.VERSION.SDK_INT >= 30) {
                return "NULL";
            }
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                networkType = networkInfo.getSubtype();
            }
        }
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 13: 
            case 18: 
            case 19: {
                return "4G";
            }
            case 20: {
                return "5G";
            }
        }
        return "NULL";
    }

    public static String getRequestUrl(String serverUrl, String path) {
        if (!TextUtils.isEmpty((CharSequence)serverUrl) && (serverUrl.startsWith("http://") || serverUrl.startsWith("https://"))) {
            Uri uri = Uri.parse((String)serverUrl);
            try {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), null, null, null) + "/" + path;
            }
            catch (URISyntaxException e) {
                SALog.printStackTrace(e);
            }
        }
        return "";
    }

    public static String getHost(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && (url.startsWith("http://") || url.startsWith("https://"))) {
            return Uri.parse((String)url).getHost();
        }
        return "";
    }

    public static boolean compareMainDomain(String adChannelhost, String slinkHost) {
        if (!TextUtils.isEmpty((CharSequence)adChannelhost) && !TextUtils.isEmpty((CharSequence)slinkHost) && slinkHost.contains(".")) {
            return adChannelhost.substring(adChannelhost.indexOf(".") + 1).equals(slinkHost.substring(slinkHost.indexOf(".") + 1));
        }
        return false;
    }

    @TargetApi(value=21)
    private static class SANetworkCallbackImpl
    extends ConnectivityManager.NetworkCallback {
        private SANetworkCallbackImpl() {
        }

        public void onAvailable(Network network) {
            super.onAvailable(network);
            NetworkUtils.cleanNetworkTypeCache();
            SensorsDataAPI.sharedInstance().flush();
            SALog.i(NetworkUtils.TAG, "onAvailable is calling");
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            super.onCapabilitiesChanged(network, networkCapabilities);
            NetworkUtils.cleanNetworkTypeCache();
            SALog.i(NetworkUtils.TAG, "onCapabilitiesChanged is calling");
        }

        public void onLost(Network network) {
            super.onLost(network);
            NetworkUtils.cleanNetworkTypeCache();
            SALog.i(NetworkUtils.TAG, "onLost is calling");
        }
    }

    private static class SABroadcastReceiver
    extends BroadcastReceiver {
        private SABroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                NetworkUtils.cleanNetworkTypeCache();
                SensorsDataAPI.sharedInstance().flush();
                SALog.i(NetworkUtils.TAG, "SABroadcastReceiver is receiving ConnectivityManager.CONNECTIVITY_ACTION broadcast");
            }
        }
    }
}

