/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.useridentity;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;

public class LoginIDAndKey {
    private static final String TAG = "SA.LoginIDAndKey";
    public static final String LOGIN_ID_KEY_DEFAULT = "$identity_login_id";

    public void init(String loginIDKey) {
        if (LoginIDAndKey.isInValidLoginIDKey(loginIDKey)) {
            this.restoreDefaultLoginIDKey();
        }
    }

    public String getLoginIDKey() {
        return DbAdapter.getInstance().getLoginIdKey();
    }

    public String getLoginId() {
        return DbAdapter.getInstance().getLoginId();
    }

    public String getJointLoginID() {
        String loginIDKey = this.getLoginIDKey();
        String loginID = this.getLoginId();
        return LoginIDAndKey.jointLoginID(loginIDKey, loginID);
    }

    public static String jointLoginID(String loginIDKey, String loginID) {
        if (!TextUtils.isEmpty((CharSequence)loginIDKey)) {
            if (loginIDKey.equals(LOGIN_ID_KEY_DEFAULT)) {
                return loginID;
            }
            return loginIDKey + "+" + loginID;
        }
        return loginID;
    }

    public boolean setLoginKeyAndID(String loginIDKey, String loginID, String anonymousId) {
        if (LoginIDAndKey.isInValidLogin(loginIDKey, loginID, this.getLoginIDKey(), this.getLoginId(), anonymousId)) {
            return false;
        }
        this.setLoginIDKey(loginIDKey);
        this.setLoginId(loginID);
        String loginId = this.getLoginId();
        String loginIdKey = this.getLoginIDKey();
        if (!loginID.equals(loginId) || !loginIDKey.equals(loginIdKey)) {
            this.setLoginId(loginID);
            this.setLoginIDKey(loginIDKey);
        }
        return true;
    }

    public void removeLoginKeyAndID() {
        this.setLoginIDKey("");
        this.setLoginId("");
    }

    private void restoreDefaultLoginIDKey() {
        this.setLoginIDKey(LOGIN_ID_KEY_DEFAULT);
    }

    public void setLoginId(String loginID) {
        DbAdapter.getInstance().commitLoginId(loginID);
    }

    public void setLoginIDKey(String loginIDKey) {
        DbAdapter.getInstance().commitLoginIdKey(loginIDKey);
    }

    private static boolean isInValidLoginIDKey(String loginIDKey) {
        if (!SADataHelper.assertPropertyKey(loginIDKey)) {
            return true;
        }
        if ("$identity_anonymous_id".equals(loginIDKey) || "$identity_android_uuid".equals(loginIDKey) || "$identity_android_id".equals(loginIDKey)) {
            SALog.i(TAG, "login key cannot be an anonymous id or android_uuid or android_id!");
            return true;
        }
        return false;
    }

    private static boolean isInValidLoginID(String loginID, String anonymousId) {
        try {
            SADataHelper.assertDistinctId(loginID);
        }
        catch (Exception e) {
            SALog.i(TAG, e);
            return true;
        }
        if (loginID.equals(anonymousId)) {
            SALog.i(TAG, "login value cannot be an anonymous id!");
            return true;
        }
        return false;
    }

    public static boolean isInValidLogin(String loginIDKey, String loginID, String currentLoginIDKey, String currentLoginID, String anonymousId) {
        if (LoginIDAndKey.isInValidLoginIDKey(loginIDKey)) {
            return true;
        }
        if (LoginIDAndKey.isInValidLoginID(loginID, anonymousId)) {
            return true;
        }
        if (loginIDKey.equals(currentLoginIDKey) && loginID.equals(currentLoginID)) {
            SALog.i(TAG, "login key and value already exist!");
            return true;
        }
        return false;
    }
}

