/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.useridentity;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.rpc.SensorsDataContentObserver;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.data.persistent.LoginIdKeyPersistent;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentDistinctId;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoginId;
import com.sensorsdata.analytics.android.sdk.data.persistent.UserIdentityPersistent;
import com.sensorsdata.analytics.android.sdk.useridentity.LoginIDAndKey;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Identities {
    private static final String TAG = "SA.Identities";
    private JSONObject mIdentities;
    private JSONObject mLoginIdentities;
    private JSONObject mUnbindIdentities;
    private final LoginIDAndKey mLoginIDAndKey = new LoginIDAndKey();
    public static final String ANONYMOUS_ID = "$identity_anonymous_id";
    public static final String ANDROID_ID = "$identity_android_id";
    public static final String ANDROID_UUID = "$identity_android_uuid";
    public static final String COOKIE_ID = "$identity_cookie_id";
    public static final String IDENTITIES_KEY = "identities";
    private String mAndroidId;
    private PersistentDistinctId mAnonymousId;

    public void init(String androidId, String anonymousId) throws JSONException {
        String oldLoginIDKey = Local.getLoginIdKeyFromLocal();
        String oldLoginID = Local.getLoginIdFromLocal();
        this.mLoginIDAndKey.init(oldLoginIDKey);
        this.mAndroidId = androidId;
        this.mAnonymousId = PersistentLoader.getInstance().getAnonymousIdPst();
        JSONObject identities = this.getInitIdentities();
        identities = this.createIdentities(identities, anonymousId);
        this.initLoginIDAndKeyIdentities(oldLoginIDKey, oldLoginID, identities);
        this.mIdentities = identities;
        this.saveIdentities();
    }

    private void initLoginIDAndKeyIdentities(String oldLoginIDKey, String oldLoginID, JSONObject identities) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)oldLoginID)) {
            if (identities.has(oldLoginIDKey)) {
                this.clearIdentities(Arrays.asList(ANDROID_ID, ANDROID_UUID, ANONYMOUS_ID), identities);
                this.mLoginIDAndKey.setLoginIDKey("");
            }
        } else if (identities.has(oldLoginIDKey)) {
            String identitiesLoginID = identities.optString(this.mLoginIDAndKey.getLoginIDKey());
            if (!identitiesLoginID.equals(oldLoginID)) {
                identities.put(Local.getLoginIdKeyFromLocal(), (Object)Local.getLoginIdFromLocal());
                this.clearIdentities(Arrays.asList(ANDROID_ID, ANDROID_UUID, this.mLoginIDAndKey.getLoginIDKey()), identities);
            }
        } else {
            identities.put(Local.getLoginIdKeyFromLocal(), (Object)Local.getLoginIdFromLocal());
            this.clearIdentities(Arrays.asList(ANDROID_ID, ANDROID_UUID, this.mLoginIDAndKey.getLoginIDKey()), identities);
        }
    }

    private JSONObject createIdentities(JSONObject identities, String anonymousId) throws JSONException {
        JSONObject tmp_identities = identities;
        if (tmp_identities == null || tmp_identities.length() == 0) {
            tmp_identities = new JSONObject();
            if (anonymousId != null) {
                tmp_identities.put(ANONYMOUS_ID, (Object)anonymousId);
            }
            if (SensorsDataUtils.isValidAndroidId(this.mAndroidId)) {
                tmp_identities.put(ANDROID_ID, (Object)this.mAndroidId);
            } else {
                tmp_identities.put(ANDROID_UUID, (Object)anonymousId);
            }
        } else if (tmp_identities.has(ANONYMOUS_ID)) {
            tmp_identities.put(ANONYMOUS_ID, (Object)anonymousId);
        }
        return tmp_identities;
    }

    private JSONObject resetIdentities(JSONObject identities) throws JSONException {
        if (identities == null) {
            identities = new JSONObject();
        }
        if (identities.has(ANDROID_UUID) || identities.has(ANDROID_ID)) {
            return identities;
        }
        if (SensorsDataUtils.isValidAndroidId(this.mAndroidId)) {
            identities.put(ANDROID_ID, (Object)this.mAndroidId);
        } else {
            identities.put(ANDROID_UUID, this.mAnonymousId.get());
        }
        return identities;
    }

    private void clearIdentities(List<String> whiteListKey, JSONObject identities) {
        if (identities != null) {
            Iterator iterator = identities.keys();
            while (iterator.hasNext()) {
                if (whiteListKey.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
    }

    public boolean updateLoginKeyAndID(String loginIDKey, String loginID, String anonymousId) throws Exception {
        boolean flag = this.isInValid(loginIDKey, loginID, anonymousId);
        if (flag) {
            return false;
        }
        this.mIdentities.put(loginIDKey, (Object)loginID);
        this.mLoginIdentities = new JSONObject(this.mIdentities.toString());
        this.clearIdentities(Arrays.asList(ANDROID_ID, ANDROID_UUID, loginIDKey), this.mIdentities);
        this.saveIdentities();
        return true;
    }

    public void removeLoginKeyAndID() {
        this.mLoginIdentities = new JSONObject();
        this.clearIdentities(Arrays.asList(ANDROID_ID, ANDROID_UUID), this.mIdentities);
        if (!SensorsDataContentObserver.State.LOGOUT.isObserverCalled) {
            this.mLoginIDAndKey.removeLoginKeyAndID();
        }
        this.saveIdentities();
        SensorsDataContentObserver.State.LOGOUT.isObserverCalled = false;
    }

    public boolean update(String key, String value) throws JSONException {
        boolean flag = this.isInvalidBusinessID(key, value, false);
        if (flag) {
            return false;
        }
        this.mIdentities.put(key, (Object)value);
        this.saveIdentities();
        return true;
    }

    public boolean remove(String key, String value) throws JSONException {
        String tmp_loginID;
        boolean isNotRemove;
        if (this.isInvalidBusinessID(key, value, true)) {
            return false;
        }
        this.mUnbindIdentities = new JSONObject();
        this.mUnbindIdentities.put(key, (Object)value);
        boolean bl = isNotRemove = ANDROID_ID.equals(key) || ANDROID_UUID.equals(key);
        if (!isNotRemove && this.mIdentities.has(key) && this.mIdentities.optString(key).equals(value)) {
            this.mIdentities.remove(key);
        }
        if ((tmp_loginID = key + "+" + value).equals(this.getJointLoginID())) {
            this.mIdentities.remove(key);
            this.mLoginIDAndKey.removeLoginKeyAndID();
        }
        this.saveIdentities();
        return true;
    }

    public void updateSpecialIDKeyAndValue(SpecialID specialID, String value) throws JSONException {
        switch (specialID) {
            case ANONYMOUS_ID: {
                this.mIdentities.put(ANONYMOUS_ID, (Object)value);
                break;
            }
            case ANDROID_ID: {
                this.mIdentities.put(ANDROID_ID, (Object)value);
                break;
            }
            case ANDROID_UUID: {
                this.mIdentities.put(ANDROID_UUID, (Object)value);
                break;
            }
        }
        this.saveIdentities();
    }

    public void updateIDKeyAndValue(String value) throws JSONException {
        if (this.mIdentities.has(ANDROID_ID)) {
            this.mIdentities.put(ANDROID_ID, (Object)value);
        } else if (this.mIdentities.has(ANDROID_UUID)) {
            this.mIdentities.put(ANDROID_UUID, (Object)value);
        }
        this.saveIdentities();
    }

    private void saveIdentities() {
        if (!this.isValidIdentities(this.mIdentities)) {
            try {
                this.mIdentities = this.resetIdentities(this.mIdentities);
            }
            catch (JSONException e) {
                SALog.i(TAG, "reset identities failed!");
            }
        }
        DbAdapter.getInstance().commitIdentities(this.mIdentities.toString());
    }

    private boolean isInvalidBusinessID(String key, String value, boolean isRemove) {
        boolean flag = false;
        if (isRemove) {
            if (!this.isRemoveKeyValid(key) || !SADataHelper.assertPropertyKey(key)) {
                flag = true;
                SALog.i(TAG, "unbind key is invalid, key = " + key);
            }
        } else if (!this.isKeyValid(key) || !SADataHelper.assertPropertyKey(key)) {
            flag = true;
            SALog.i(TAG, "bind key is invalid, key = " + key);
        }
        try {
            SADataHelper.assertDistinctId(value);
        }
        catch (Exception e) {
            flag = true;
            SALog.i(TAG, e);
        }
        return flag;
    }

    private boolean isKeyValid(String key) {
        return !ANONYMOUS_ID.equals(key) && !ANDROID_UUID.equals(key) && !ANDROID_ID.equals(key) && !this.mLoginIDAndKey.getLoginIDKey().equals(key) && !"$identity_login_id".equals(key);
    }

    private boolean isRemoveKeyValid(String key) {
        return !ANONYMOUS_ID.equals(key) && !"$identity_login_id".equals(key);
    }

    private boolean isInValid(String loginIDKey, String loginID, String anonymousId) {
        return !this.mLoginIDAndKey.setLoginKeyAndID(loginIDKey, loginID, anonymousId);
    }

    public JSONObject getIdentities(State state) {
        JSONObject jsonObject = null;
        switch (state) {
            case LOGIN_KEY: {
                jsonObject = this.mLoginIdentities;
                break;
            }
            case REMOVE_KEYID: {
                if (this.mUnbindIdentities == null) break;
                jsonObject = this.mUnbindIdentities;
                break;
            }
            case DEFAULT: {
                jsonObject = this.mIdentities == null || this.mIdentities.length() == 0 ? this.getDefaultIdentities() : this.mIdentities;
            }
        }
        return jsonObject;
    }

    private boolean isValidIdentities(JSONObject jsonObject) {
        return jsonObject != null && (jsonObject.has(ANDROID_ID) || jsonObject.has(ANDROID_UUID));
    }

    private JSONObject getDefaultIdentities() {
        JSONObject jsonObject = null;
        try {
            jsonObject = this.getCacheIdentities();
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        return jsonObject;
    }

    public void updateIdentities() {
        try {
            this.mIdentities = this.getCacheIdentities();
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public void mergeIdentities(JSONObject source) throws JSONException {
        Iterator iteratorKeys = source.keys();
        while (iteratorKeys.hasNext()) {
            String key = (String)iteratorKeys.next();
            if (this.mIdentities.has(key)) continue;
            this.mIdentities.put(key, (Object)source.optString(key));
        }
        this.saveIdentities();
    }

    private JSONObject getInitIdentities() throws JSONException {
        String cacheIdentities = Local.getIdentitiesFromLocal();
        if (!TextUtils.isEmpty((CharSequence)cacheIdentities)) {
            return new JSONObject(cacheIdentities);
        }
        return null;
    }

    private JSONObject getCacheIdentities() throws JSONException {
        String cacheIdentities = DbAdapter.getInstance().getIdentities();
        if (!TextUtils.isEmpty((CharSequence)cacheIdentities)) {
            return new JSONObject(cacheIdentities);
        }
        return null;
    }

    public String getJointLoginID() {
        return this.mLoginIDAndKey.getJointLoginID();
    }

    public String getLoginId() {
        return this.mLoginIDAndKey.getLoginId();
    }

    public String getLoginIDKey() {
        return this.mLoginIDAndKey.getLoginIDKey();
    }

    public static class Local {
        public static String getLoginIdFromLocal() {
            try {
                PersistentLoginId persistentLoginId = PersistentLoader.getInstance().getLoginIdPst();
                return persistentLoginId == null ? "" : (String)persistentLoginId.get();
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
                return "";
            }
        }

        public static String getLoginIdKeyFromLocal() {
            try {
                LoginIdKeyPersistent loginIdKeyPersistent = PersistentLoader.getInstance().getLoginIdKeyPst();
                return loginIdKeyPersistent == null ? "" : (String)loginIdKeyPersistent.get();
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
                return "";
            }
        }

        public static String getIdentitiesFromLocal() {
            try {
                UserIdentityPersistent userPersistent = PersistentLoader.getInstance().getUserIdsPst();
                if (userPersistent != null) {
                    return DbAdapter.decodeIdentities((String)userPersistent.get());
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
            return null;
        }
    }

    public static enum SpecialID {
        ANONYMOUS_ID,
        ANDROID_ID,
        ANDROID_UUID;

    }

    public static enum State {
        LOGIN_KEY,
        REMOVE_KEYID,
        DEFAULT;

    }
}

