/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.remote;

import android.os.CountDownTimer;
import android.os.SystemClock;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.remote.BaseSensorsDataSDKRemoteManager;
import com.sensorsdata.analytics.android.sdk.remote.SensorsDataSDKRemoteConfig;
import com.sensorsdata.analytics.android.sdk.util.Dispatcher;
import java.security.SecureRandom;
import org.json.JSONObject;

public class SensorsDataRemoteManager
extends BaseSensorsDataSDKRemoteManager {
    private static final String SHARED_PREF_REQUEST_TIME = "sensorsdata.request.time";
    private static final String SHARED_PREF_REQUEST_TIME_RANDOM = "sensorsdata.request.time.random";
    private static final String TAG = "SA.SensorsDataRemoteManager";
    private volatile CountDownTimer mPullSDKConfigCountDownTimer;
    private final SAStoreManager mStorageManager = SAStoreManager.getInstance();
    private volatile boolean mIsInit = true;

    public SensorsDataRemoteManager(SensorsDataAPI sensorsDataAPI, SAContextManager contextManager) {
        super(sensorsDataAPI, contextManager);
        SALog.i(TAG, "Construct a SensorsDataRemoteManager");
    }

    private boolean isRequestValid() {
        boolean isRequestValid = true;
        try {
            float requestInterval;
            long lastRequestTime = this.mStorageManager.getLong(SHARED_PREF_REQUEST_TIME, 0L);
            int randomTime = this.mStorageManager.getInteger(SHARED_PREF_REQUEST_TIME_RANDOM, 0);
            if (lastRequestTime != 0L && randomTime != 0 && (requestInterval = (float)(SystemClock.elapsedRealtime() - lastRequestTime)) > 0.0f && requestInterval / 1000.0f < (float)(randomTime * 3600)) {
                isRequestValid = false;
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return isRequestValid;
    }

    private void writeRemoteRequestRandomTime() {
        SAConfigOptions configOptions = this.mContextManager.getInternalConfigs().saConfigOptions;
        if (configOptions == null || !this.mContextManager.getInternalConfigs().isRemoteConfigEnabled) {
            return;
        }
        int randomTime = configOptions.getMinRequestInterval();
        long currentTime = SystemClock.elapsedRealtime();
        if (configOptions.getMaxRequestInterval() > configOptions.getMinRequestInterval()) {
            randomTime += new SecureRandom().nextInt(configOptions.getMaxRequestInterval() - configOptions.getMinRequestInterval() + 1);
        }
        this.mStorageManager.setLong(SHARED_PREF_REQUEST_TIME, currentTime);
        this.mStorageManager.setInteger(SHARED_PREF_REQUEST_TIME_RANDOM, randomTime);
    }

    private void cleanRemoteRequestRandomTime() {
        this.mStorageManager.remove(SHARED_PREF_REQUEST_TIME);
        this.mStorageManager.remove(SHARED_PREF_REQUEST_TIME_RANDOM);
    }

    @Override
    public void pullSDKConfigFromServer() {
        SAConfigOptions configOptions = this.mContextManager.getInternalConfigs().saConfigOptions;
        if (configOptions == null || configOptions.isDisableSDK() || !this.mContextManager.getInternalConfigs().isRemoteConfigEnabled && !this.mContextManager.getInternalConfigs().saConfigOptions.isEnableEncrypt()) {
            return;
        }
        if (configOptions.isDisableRandomTimeRequestRemoteConfig() || configOptions.getMinRequestInterval() > configOptions.getMaxRequestInterval()) {
            this.requestRemoteConfig(BaseSensorsDataSDKRemoteManager.RandomTimeType.RandomTimeTypeClean, true);
            SALog.i(TAG, "remote config: Request remote config because disableRandomTimeRequestRemoteConfig or minHourInterval greater than maxHourInterval");
            return;
        }
        if (!this.isSecretKeyValid()) {
            this.requestRemoteConfig(BaseSensorsDataSDKRemoteManager.RandomTimeType.RandomTimeTypeWrite, false);
            SALog.i(TAG, "remote config: Request remote config because encrypt key is null");
            return;
        }
        if (this.isRequestValid()) {
            this.requestRemoteConfig(BaseSensorsDataSDKRemoteManager.RandomTimeType.RandomTimeTypeWrite, true);
            SALog.i(TAG, "remote config: Request remote config because satisfy the random request condition");
        }
    }

    @Override
    public void requestRemoteConfig(BaseSensorsDataSDKRemoteManager.RandomTimeType randomTimeType, final boolean enableConfigV) {
        if (this.mDisableDefaultRemoteConfig) {
            SALog.i(TAG, "disableDefaultRemoteConfig is true");
            return;
        }
        switch (randomTimeType) {
            case RandomTimeTypeWrite: {
                this.writeRemoteRequestRandomTime();
                break;
            }
            case RandomTimeTypeClean: {
                this.cleanRemoteRequestRandomTime();
                break;
            }
        }
        Dispatcher.getInstance().post(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataRemoteManager.this.pullSDKConfigCount(enableConfigV);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    private void pullSDKConfigCount(final boolean enableConfigV) {
        if (this.mPullSDKConfigCountDownTimer != null) {
            this.mPullSDKConfigCountDownTimer.cancel();
            this.mPullSDKConfigCountDownTimer = null;
        }
        this.mPullSDKConfigCountDownTimer = new CountDownTimer(90000L, 30000L){

            public void onTick(long l) {
                if (SensorsDataRemoteManager.this.mSensorsDataAPI != null && !SensorsDataRemoteManager.this.mSensorsDataAPI.isNetworkRequestEnable() || SensorsDataRemoteManager.this.mContextManager.getInternalConfigs().saConfigOptions.isDisableSDK() || !SensorsDataRemoteManager.this.mContextManager.getInternalConfigs().isRemoteConfigEnabled && !SensorsDataRemoteManager.this.mContextManager.getInternalConfigs().saConfigOptions.isEnableEncrypt()) {
                    SALog.i(SensorsDataRemoteManager.TAG, "Close network request or sdk is disable");
                    return;
                }
                SensorsDataRemoteManager.this.requestRemoteConfig(enableConfigV, new HttpCallback.StringCallback(){

                    @Override
                    public void onFailure(int code, String errorMessage) {
                        if (code == 304 || code == 404) {
                            SensorsDataRemoteManager.this.resetPullSDKConfigTimer();
                        }
                        SALog.i(SensorsDataRemoteManager.TAG, "Remote request failed,responseCode is " + code + ",errorMessage is " + errorMessage);
                    }

                    @Override
                    public void onResponse(String response) {
                        SensorsDataRemoteManager.this.resetPullSDKConfigTimer();
                        if (!TextUtils.isEmpty((CharSequence)response)) {
                            SensorsDataSDKRemoteConfig sdkRemoteConfig = SensorsDataRemoteManager.this.toSDKRemoteConfig(response);
                            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "storeSecretKey", response);
                            if (SensorsDataRemoteManager.this.mContextManager.getInternalConfigs().isRemoteConfigEnabled) {
                                SensorsDataRemoteManager.this.setSDKRemoteConfig(sdkRemoteConfig);
                            }
                        }
                        SALog.i(SensorsDataRemoteManager.TAG, "Remote request was successful,response data is " + response);
                    }

                    @Override
                    public void onAfter() {
                    }
                });
            }

            public void onFinish() {
            }
        };
        this.mPullSDKConfigCountDownTimer.start();
    }

    @Override
    public void resetPullSDKConfigTimer() {
        try {
            if (this.mPullSDKConfigCountDownTimer != null) {
                this.mPullSDKConfigCountDownTimer.cancel();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        finally {
            this.mPullSDKConfigCountDownTimer = null;
        }
    }

    @Override
    protected void setSDKRemoteConfig(SensorsDataSDKRemoteConfig sdkRemoteConfig) {
        try {
            final JSONObject eventProperties = new JSONObject();
            String remoteConfigString = sdkRemoteConfig.toJson().toString();
            eventProperties.put("$app_remote_config", (Object)remoteConfigString);
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    SensorsDataRemoteManager.this.mContextManager.trackEvent(new InputData().setEventName("$AppRemoteConfigChanged").setProperties(eventProperties).setEventType(EventType.TRACK));
                }
            });
            this.mContextManager.getAnalyticsMessages().flush();
            DbAdapter.getInstance().commitRemoteConfig(remoteConfigString);
            SALog.i(TAG, "Save remote data");
            if (1 == sdkRemoteConfig.getEffectMode()) {
                mSDKRemoteConfig = sdkRemoteConfig;
                SALog.i(TAG, "The remote configuration takes effect immediately");
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void applySDKConfigFromCache() {
        try {
            String remoteConfig;
            if (this.mIsInit) {
                remoteConfig = DbAdapter.getInstance().getRemoteConfigFromLocal();
                this.mIsInit = false;
            } else {
                remoteConfig = DbAdapter.getInstance().getRemoteConfig();
            }
            SensorsDataSDKRemoteConfig sdkRemoteConfig = this.toSDKRemoteConfig(remoteConfig);
            if (SALog.isLogEnabled()) {
                SALog.i(TAG, "Cache remote config is " + sdkRemoteConfig.toString());
            }
            if (this.mSensorsDataAPI != null) {
                if (sdkRemoteConfig.isDisableDebugMode()) {
                    this.mSensorsDataAPI.setDebugMode(SensorsDataAPI.DebugMode.DEBUG_OFF);
                    SALog.i(TAG, "Set DebugOff Mode");
                }
                if (sdkRemoteConfig.isDisableSDK()) {
                    try {
                        this.mContextManager.getAnalyticsMessages().flush();
                        SALog.i(TAG, "DisableSDK is true");
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            }
            mSDKRemoteConfig = sdkRemoteConfig;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }
}

