/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.plugin.property.impl;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertiesFetcher;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertyFilter;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import com.sensorsdata.analytics.android.sdk.util.DeviceUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import org.json.JSONException;
import org.json.JSONObject;

public final class SAPresetPropertyPlugin
extends SAPropertyPlugin {
    private final Context mContext;
    private final boolean mDisableTrackDeviceId;
    private final boolean mDisableAndroidId;
    private JSONObject presetProperty;

    public SAPresetPropertyPlugin(SAContextManager contextManager) {
        this.mContext = contextManager.getContext();
        this.mDisableTrackDeviceId = contextManager.getInternalConfigs().isTrackDeviceId;
        this.mDisableAndroidId = contextManager.getInternalConfigs().saConfigOptions.isDisableDeviceId();
    }

    @Override
    public boolean isMatchedWithFilter(SAPropertyFilter filter) {
        EventType type = filter.getType();
        return type.isTrack();
    }

    @Override
    public void properties(SAPropertiesFetcher saPropertiesFetcher) {
        try {
            JSONObject jsonObject = this.getPresetProperties();
            if (saPropertiesFetcher.getProperties().has("$lib_version")) {
                jsonObject.remove("$lib_version");
            }
            if (saPropertiesFetcher.getProperties().has("$lib")) {
                jsonObject.remove("$lib");
            }
            if (saPropertiesFetcher.getProperties().has("$app_version")) {
                jsonObject.remove("$app_version");
            }
            JSONUtils.mergeJSONObject(jsonObject, saPropertiesFetcher.getProperties());
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private JSONObject getPreset() {
        JSONObject properties = new JSONObject();
        try {
            String osVersion = DeviceUtils.getHarmonyOSVersion();
            if (!TextUtils.isEmpty((CharSequence)osVersion)) {
                properties.put("$os", (Object)"HarmonyOS");
                properties.put("$os_version", (Object)osVersion);
            } else {
                properties.put("$os", (Object)"Android");
                properties.put("$os_version", (Object)DeviceUtils.getOS());
            }
            properties.put("$lib", (Object)"Android");
            properties.put("$lib_version", (Object)SensorsDataAPI.sharedInstance().getSDKVersion());
            properties.put("$manufacturer", (Object)DeviceUtils.getManufacturer());
            properties.put("$model", (Object)DeviceUtils.getModel());
            properties.put("$brand", (Object)DeviceUtils.getBrand());
            properties.put("$app_version", (Object)AppInfoUtils.getAppVersionName(this.mContext));
            int[] size = DeviceUtils.getDeviceSize(this.mContext);
            properties.put("$screen_width", size[0]);
            properties.put("$screen_height", size[1]);
            Integer zone_offset = TimeUtils.getZoneOffset();
            if (zone_offset != null) {
                properties.put("$timezone_offset", (Object)zone_offset);
            }
            properties.put("$app_id", (Object)AppInfoUtils.getProcessName(this.mContext));
            properties.put("$app_name", (Object)AppInfoUtils.getAppName(this.mContext));
            String mAndroidId = SensorsDataUtils.getIdentifier(this.mContext);
            if (!this.mDisableTrackDeviceId && !TextUtils.isEmpty((CharSequence)mAndroidId)) {
                if (this.mDisableAndroidId) {
                    properties.put("$anonymization_id", (Object)Base64Coder.encodeString(mAndroidId));
                } else {
                    properties.put("$device_id", (Object)mAndroidId);
                }
            }
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        return properties;
    }

    public JSONObject getPresetProperties() {
        try {
            if (this.presetProperty == null) {
                JSONObject jsonObject = this.getPreset();
                this.presetProperty = new JSONObject(jsonObject.toString());
            }
            String networkType = NetworkUtils.networkType(this.mContext);
            this.presetProperty.put("$wifi", "WIFI".equals(networkType));
            this.presetProperty.put("$network_type", (Object)networkType);
            return new JSONObject(this.presetProperty.toString());
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
            return new JSONObject();
        }
    }
}

