/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.network;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.network.HttpConfig;
import com.sensorsdata.analytics.android.sdk.network.HttpUtils;
import com.sensorsdata.analytics.android.sdk.network.RealResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

class RealRequest {
    private static final String TAG = "SA.HttpRequest";
    private static String sRequestURL;
    private HttpConfig httpConfig = new HttpConfig();

    RealRequest() {
    }

    RealResponse getData(String requestURL, Map<String, String> headerMap) {
        try {
            SALog.i(TAG, String.format("url:%s,\nmethod:GET", requestURL));
            sRequestURL = requestURL;
            HttpURLConnection conn = this.getHttpURLConnection(requestURL, "GET");
            if (headerMap != null) {
                this.setHeader(conn, headerMap);
            }
            conn.connect();
            return this.getRealResponse(conn);
        }
        catch (Exception e) {
            return this.getExceptionResponse(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RealResponse postData(String requestURL, String body, String bodyType, Map<String, String> headerMap) {
        BufferedWriter writer = null;
        try {
            sRequestURL = requestURL;
            SALog.i(TAG, String.format("url:%s\nparams:%s\nmethod:POST", requestURL, body));
            HttpURLConnection conn = this.getHttpURLConnection(requestURL, "POST");
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            if (!TextUtils.isEmpty((CharSequence)bodyType)) {
                conn.setRequestProperty("Content-Type", bodyType);
            }
            if (headerMap != null) {
                this.setHeader(conn, headerMap);
            }
            conn.connect();
            if (!TextUtils.isEmpty((CharSequence)body)) {
                writer = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), "UTF-8"));
                writer.write(body);
                writer.flush();
            }
            RealResponse realResponse = this.getRealResponse(conn);
            return realResponse;
        }
        catch (Exception e) {
            RealResponse realResponse = this.getExceptionResponse(e);
            return realResponse;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (IOException e) {
                    SALog.printStackTrace(e);
                }
            }
        }
    }

    private HttpURLConnection getHttpURLConnection(String requestURL, String requestMethod) throws IOException {
        SAConfigOptions configOptions;
        URL url = new URL(requestURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(requestMethod);
        conn.setUseCaches(false);
        conn.setConnectTimeout(this.httpConfig.getConnectionTimeout());
        conn.setReadTimeout(this.httpConfig.getReadTimeout());
        if (requestMethod.equals("POST")) {
            conn.setDoOutput(true);
        }
        if ((configOptions = SensorsDataAPI.getConfigOptions()) != null && configOptions.getSSLSocketFactory() != null && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(configOptions.getSSLSocketFactory());
        }
        return conn;
    }

    private void setHeader(HttpURLConnection conn, Map<String, String> headerMap) {
        if (headerMap != null) {
            for (String key : headerMap.keySet()) {
                conn.setRequestProperty(key, headerMap.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealResponse getRealResponse(HttpURLConnection conn) {
        RealResponse response = new RealResponse();
        try {
            response.code = conn.getResponseCode();
            if (HttpUtils.needRedirects(response.code)) {
                response.location = HttpUtils.getLocation(conn, sRequestURL);
            }
            response.contentLength = conn.getContentLength();
            if (response.code < 400) {
                response.result = HttpUtils.getRetString(conn.getInputStream());
            } else {
                response.errorMsg = HttpUtils.getRetString(conn.getErrorStream());
            }
        }
        catch (IOException e) {
            RealResponse realResponse = this.getExceptionResponse(e);
            return realResponse;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        SALog.i(TAG, response.toString());
        return response;
    }

    private RealResponse getExceptionResponse(Exception e) {
        RealResponse response = new RealResponse();
        response.exception = e;
        response.errorMsg = e.getMessage();
        SALog.i(TAG, response.toString());
        return response;
    }

    public RealRequest setHttpConfig(HttpConfig httpConfig) {
        if (httpConfig == null) {
            return this;
        }
        this.httpConfig = httpConfig;
        return this;
    }
}

