/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.network;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

class HttpUtils {
    private static final int HTTP_307 = 307;

    HttpUtils() {
    }

    static boolean needRedirects(int responseCode) {
        return responseCode == 301 || responseCode == 302 || responseCode == 307;
    }

    static String getLocation(HttpURLConnection connection, String path) throws MalformedURLException {
        if (connection == null || TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        String location = connection.getHeaderField("Location");
        if (TextUtils.isEmpty((CharSequence)location)) {
            location = connection.getHeaderField("location");
        }
        if (TextUtils.isEmpty((CharSequence)location)) {
            return null;
        }
        if (!location.startsWith("http://") && !location.startsWith("https://")) {
            URL originUrl = new URL(path);
            location = originUrl.getProtocol() + "://" + originUrl.getHost() + location;
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getRetString(InputStream is) {
        BufferedReader reader = null;
        try {
            String buf;
            String line;
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            is.close();
            String string2 = buf = sb.toString();
            return string2;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException e) {
                    SALog.printStackTrace(e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException e) {
                    SALog.printStackTrace(e);
                }
            }
        }
        return "";
    }
}

