/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.network;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.network.RealResponse;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class HttpCallback<T> {
    static Handler sMainHandler = new Handler(Looper.getMainLooper());

    void onError(final RealResponse response) {
        final String errorMessage = !TextUtils.isEmpty((CharSequence)response.result) ? response.result : (!TextUtils.isEmpty((CharSequence)response.errorMsg) ? response.errorMsg : (response.exception != null ? response.exception.toString() : "unknown error"));
        sMainHandler.post(new Runnable(){

            @Override
            public void run() {
                HttpCallback.this.onFailure(response.code, errorMessage);
                HttpCallback.this.onAfter();
            }
        });
    }

    void onSuccess(RealResponse response) {
        final T obj = this.onParseResponse(response.result);
        sMainHandler.post(new Runnable(){

            @Override
            public void run() {
                HttpCallback.this.onResponse(obj);
                HttpCallback.this.onAfter();
            }
        });
    }

    public abstract T onParseResponse(String var1);

    public abstract void onFailure(int var1, String var2);

    public abstract void onResponse(T var1);

    public abstract void onAfter();

    public static abstract class JsonCallback
    extends HttpCallback<JSONObject> {
        @Override
        public JSONObject onParseResponse(String result) {
            try {
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    return new JSONObject(result);
                }
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
            return null;
        }

        @Override
        public void onAfter() {
        }
    }

    public static abstract class StringCallback
    extends HttpCallback<String> {
        @Override
        public String onParseResponse(String result) {
            return result;
        }
    }
}

