/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.instantevent.InstantEventUtils;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DataOperation;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

class EncryptDataOperation
extends DataOperation {
    protected boolean mDbEncrypt = true;

    EncryptDataOperation(Context context) {
        super(context);
    }

    @Override
    int insertData(Uri uri, JSONObject jsonObject) {
        try {
            if (this.deleteDataLowMemory(uri) != 0) {
                return -2;
            }
            int instant_event = InstantEventUtils.isInstantEvent(jsonObject);
            JSONObject jsonEncrypt = (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptEventData", jsonObject);
            if (jsonEncrypt != null) {
                jsonObject = jsonEncrypt;
            }
            ContentValues cv = new ContentValues();
            cv.put("data", jsonObject.toString() + "\t" + jsonObject.toString().hashCode());
            cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
            cv.put("is_instant_event", Integer.valueOf(instant_event));
            this.contentResolver.insert(uri, cv);
        }
        catch (Throwable e) {
            SALog.i(this.TAG, e.getMessage());
        }
        return 0;
    }

    @Override
    int insertData(Uri uri, ContentValues contentValues) {
        try {
            if (this.deleteDataLowMemory(uri) != 0) {
                return -2;
            }
            this.contentResolver.insert(uri, contentValues);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return 0;
    }

    @Override
    String[] queryData(Uri uri, int limit) {
        return this.queryData(uri, false, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String[] queryData(Uri uri, boolean is_instant_event, int limit) {
        Cursor cursor = null;
        String data = null;
        String eventIds = null;
        JSONArray idEncryptArray = new JSONArray();
        JSONArray idArray = new JSONArray();
        String gzipType = "9";
        try {
            HashMap<String, JSONArray> dataEncryptMap = new HashMap<String, JSONArray>();
            JSONArray dataJsonArray = new JSONArray();
            String instant_event = "0";
            if (is_instant_event) {
                instant_event = "1";
            }
            if ((cursor = this.contentResolver.query(uri, null, "is_instant_event=?", new String[]{instant_event}, "created_at ASC LIMIT " + limit)) != null) {
                JSONObject jsonObject;
                String EKEY = "ekey";
                String KEY_VER = "pkv";
                String PAYLOADS = "payloads";
                while (cursor.moveToNext()) {
                    try {
                        JSONObject jsonEncrypt;
                        String eventId = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                        String keyData = cursor.getString(cursor.getColumnIndexOrThrow("data"));
                        if (TextUtils.isEmpty((CharSequence)(keyData = this.parseData(keyData)))) continue;
                        if (!JSONUtils.isJson(keyData)) {
                            SALog.i(this.TAG, "Error is not json data, v = " + keyData);
                            continue;
                        }
                        jsonObject = new JSONObject(keyData);
                        boolean isHasEkey = jsonObject.has("ekey");
                        if (jsonObject.has("payloads") && !isHasEkey) {
                            jsonObject = new JSONObject(this.decryptValue(jsonObject.optString("payloads")));
                        }
                        if (!isHasEkey && this.mDbEncrypt && (jsonEncrypt = (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptEventData", jsonObject)) != null) {
                            jsonObject = jsonEncrypt;
                        }
                        if (jsonObject.has("ekey")) {
                            String key = jsonObject.getString("ekey") + "$" + jsonObject.getInt("pkv");
                            if (dataEncryptMap.containsKey(key)) {
                                ((JSONArray)dataEncryptMap.get(key)).put((Object)jsonObject.optString("payloads"));
                            } else {
                                JSONArray jsonArray = new JSONArray();
                                jsonArray.put((Object)jsonObject.optString("payloads"));
                                dataEncryptMap.put(key, jsonArray);
                            }
                            idEncryptArray.put((Object)eventId);
                            continue;
                        }
                        jsonObject.put("_flush_time", System.currentTimeMillis());
                        dataJsonArray.put((Object)jsonObject);
                        idArray.put((Object)eventId);
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
                if (dataEncryptMap.size() > 0) {
                    JSONArray dataEncryptJsonArray = new JSONArray();
                    for (String key : dataEncryptMap.keySet()) {
                        jsonObject = new JSONObject();
                        jsonObject.put("ekey", (Object)key.substring(0, key.indexOf("$")));
                        jsonObject.put("pkv", (Object)Integer.valueOf(key.substring(key.indexOf("$") + 1)));
                        jsonObject.put("payloads", dataEncryptMap.get(key));
                        jsonObject.put("flush_time", System.currentTimeMillis());
                        dataEncryptJsonArray.put((Object)jsonObject);
                    }
                    data = dataEncryptJsonArray.toString();
                    eventIds = idEncryptArray.toString();
                } else if (dataJsonArray.length() > 0) {
                    data = dataJsonArray.toString();
                    eventIds = idArray.toString();
                    gzipType = "1";
                }
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (eventIds != null) {
            return new String[]{eventIds, data, gzipType};
        }
        return null;
    }

    @Override
    void deleteData(Uri uri, String id2) {
        super.deleteData(uri, id2);
    }

    private String decryptValue(String value) {
        String decryptValue = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "loadEvent", value);
        return TextUtils.isEmpty((CharSequence)decryptValue) ? value : decryptValue;
    }
}

