/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.mediator;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.mediator.protocol.SAModuleProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAModuleManager {
    private static final String TAG = "SA.ModuleManager";
    private final Map<String, SAModuleProtocol> mServiceMap = new HashMap<String, SAModuleProtocol>();
    private static volatile SAModuleManager mSingleton = null;

    private SAModuleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SAModuleManager getInstance() {
        if (mSingleton != null) return mSingleton;
        Class<SAModuleManager> clazz = SAModuleManager.class;
        synchronized (SAModuleManager.class) {
            if (mSingleton != null) return mSingleton;
            mSingleton = new SAModuleManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mSingleton;
        }
    }

    public void installService(SAContextManager contextManager) {
        try {
            ArrayList<String> moduleNames = new ArrayList<String>(){
                {
                    this.add("com.sensorsdata.analytics.android.autotrack.core.SensorsAutoTrackAPI");
                    this.add("com.sensorsdata.analytics.android.webview.impl.SensorsWebViewAPI");
                    this.add("com.sensorsdata.analytics.android.sdk.encrypt.impl.SAEncryptProtocolImpl");
                    this.add("com.sensorsdata.analytics.android.sdk.push.core.PushProtocolImp");
                    this.add("com.sensorsdata.analytics.android.sdk.visual.impl.SAVisualProtocolAPI");
                    this.add("com.sensorsdata.analytics.android.sdk.exposure.SAExposureProtocolImpl");
                    this.add("com.sensorsdata.analytics.android.sdk.advert.impl.SensorsAdvertProtocolAPI");
                }
            };
            List<SAModuleProtocol> protocolList = this.loadModule((List<String>)moduleNames);
            Collections.sort(protocolList, new Comparator<SAModuleProtocol>(){

                @Override
                public int compare(SAModuleProtocol o1, SAModuleProtocol o2) {
                    return o2.getPriority() - o1.getPriority();
                }
            });
            for (SAModuleProtocol saModuleProtocol : protocolList) {
                try {
                    saModuleProtocol.install(contextManager);
                    this.mServiceMap.put(saModuleProtocol.getModuleName(), saModuleProtocol);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private List<SAModuleProtocol> loadModule(List<String> moduleNames) {
        ArrayList<SAModuleProtocol> protocolList = new ArrayList<SAModuleProtocol>();
        for (String moduleName : moduleNames) {
            try {
                Class<?> cls = Class.forName(moduleName);
                protocolList.add((SAModuleProtocol)cls.newInstance());
                SALog.i(TAG, "loadModule name: " + moduleName);
            }
            catch (Throwable e) {
                SALog.i(TAG, "loadModule name: " + moduleName + " error \n" + e);
            }
        }
        return protocolList;
    }

    public void setModuleStateByName(String moduleName, boolean enable) {
        SAModuleProtocol protocol;
        if (this.mServiceMap.containsKey(moduleName) && (protocol = this.mServiceMap.get(moduleName)) != null && enable != protocol.isEnable()) {
            protocol.setModuleState(enable);
        }
    }

    public boolean hasModuleByName(String moduleName) {
        SAModuleProtocol saModuleProtocol;
        if (TextUtils.isEmpty((CharSequence)moduleName)) {
            return false;
        }
        if (this.mServiceMap.containsKey(moduleName) && (saModuleProtocol = this.mServiceMap.get(moduleName)) != null) {
            return saModuleProtocol.isEnable();
        }
        return false;
    }

    public void setModuleState(boolean enable) {
        for (SAModuleProtocol moduleProtocol : this.mServiceMap.values()) {
            moduleProtocol.setModuleState(enable);
        }
    }

    public <T> T invokeModuleFunction(String moduleName, String methodName, Object ... argv) {
        try {
            SAModuleProtocol saModuleProtocol = this.getService(moduleName);
            if (saModuleProtocol != null) {
                return saModuleProtocol.invokeModuleFunction(methodName, argv);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    private SAModuleProtocol getService(String moduleName) {
        try {
            if (!SAModuleManager.getInstance().hasModuleByName(moduleName)) {
                return null;
            }
            return this.mServiceMap.get(moduleName);
        }
        catch (Exception exception) {
            SALog.printStackTrace(exception);
            return null;
        }
    }
}

