/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.event.imp;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.business.timer.EventTimer;
import com.sensorsdata.analytics.android.sdk.core.business.timer.EventTimerManager;
import com.sensorsdata.analytics.android.sdk.core.event.Event;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.event.TrackEvent;
import com.sensorsdata.analytics.android.sdk.core.event.imp.BaseEventAssemble;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertiesFetcher;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertyFilter;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.InternalCustomPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import java.security.SecureRandom;
import org.json.JSONException;
import org.json.JSONObject;

class TrackEventAssemble
extends BaseEventAssemble {
    private static final String TAG = "SA.TrackEventAssemble";
    private final SAContextManager mContextManager;

    public TrackEventAssemble(SAContextManager saContextManager) {
        super(saContextManager);
        this.mContextManager = saContextManager;
    }

    @Override
    public Event assembleData(InputData input) {
        try {
            EventType eventType = input.getEventType();
            JSONObject properties = JSONUtils.cloneJsonObject(input.getProperties());
            if (properties == null) {
                properties = new JSONObject();
            }
            if (this.isEventIgnore(input.getEventName(), eventType, this.mContextManager)) {
                return null;
            }
            TrackEvent trackEvent = new TrackEvent();
            trackEvent.setProperties(properties);
            this.appendDefaultProperty(input, trackEvent);
            this.appendEventDuration(trackEvent);
            this.appendLibProperty(eventType, trackEvent);
            this.appendUserIDs(input, trackEvent);
            this.appendSessionId(eventType, trackEvent);
            this.appendPluginProperties(eventType, input.getProperties(), trackEvent);
            this.handlePropertyProtocols(trackEvent);
            if (!this.handleEventCallback(eventType, trackEvent)) {
                return null;
            }
            this.appendPluginVersion(eventType, trackEvent);
            this.overrideDeviceId(eventType, trackEvent, this.mContextManager);
            SADataHelper.assertPropertyTypes(trackEvent.getProperties());
            this.handleEventListener(eventType, trackEvent, this.mContextManager);
            if (SALog.isLogEnabled()) {
                SALog.i(TAG, "track event:\n" + JSONUtils.formatJson(trackEvent.toJSONObject().toString()));
            }
            return trackEvent;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    private boolean isEventIgnore(String eventName, EventType eventType, SAContextManager contextManager) {
        if (eventType.isTrack()) {
            SADataHelper.assertEventName(eventName);
            return !TextUtils.isEmpty((CharSequence)eventName) && contextManager.getRemoteManager() != null && contextManager.getRemoteManager().ignoreEvent(eventName);
        }
        return false;
    }

    private void appendDefaultProperty(InputData inputData, TrackEvent trackEvent) {
        try {
            trackEvent.setTime(inputData.getTime());
            trackEvent.setEventName(inputData.getEventName());
            trackEvent.setType(inputData.getEventType().getEventType());
            SecureRandom secureRandom = new SecureRandom();
            trackEvent.setTrackId(secureRandom.nextInt());
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private void appendEventDuration(TrackEvent trackEvent) {
        try {
            String eventName = trackEvent.getEventName();
            if (!TextUtils.isEmpty((CharSequence)eventName)) {
                float duration;
                EventTimer eventTimer = EventTimerManager.getInstance().getEventTimer(eventName);
                if (eventTimer != null && (duration = eventTimer.duration()) > 0.0f) {
                    trackEvent.getProperties().put("event_duration", (Object)Float.valueOf(duration));
                }
                if (eventName.endsWith("_SATimer") && eventName.length() > 45) {
                    eventName = eventName.substring(0, eventName.length() - 45);
                    trackEvent.setEventName(eventName);
                    SALog.i(TAG, "trigger event name = " + eventName);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private void appendLibProperty(EventType eventType, TrackEvent trackEvent) throws JSONException {
        StackTraceElement[] trace;
        String[] screenNameArray;
        String screenName;
        SensorsDataAPI.AutoTrackEventType trackEventType;
        JSONObject libProperties = new JSONObject();
        JSONObject propertyJson = trackEvent.getProperties();
        String libDetail = null;
        if (propertyJson != null) {
            if (eventType.isTrack()) {
                String libMethod = trackEvent.getProperties().optString("$lib_method", "code");
                libProperties.put("$lib_method", (Object)libMethod);
                propertyJson.put("$lib_method", (Object)libMethod);
            } else {
                libProperties.put("$lib_method", (Object)"code");
            }
            if (propertyJson.has("$lib_detail")) {
                libDetail = propertyJson.optString("$lib_detail");
                propertyJson.remove("$lib_detail");
            }
        } else {
            libProperties.put("$lib_method", (Object)"code");
            if (eventType.isTrack()) {
                propertyJson = new JSONObject();
                propertyJson.put("$lib_method", (Object)"code");
            }
        }
        libProperties.put("$lib", (Object)"Android");
        libProperties.put("$lib_version", (Object)this.mContextManager.getSensorsDataAPI().getSDKVersion());
        libProperties.put("$app_version", (Object)AppInfoUtils.getAppVersionName(this.mContextManager.getContext()));
        JSONObject superProperties = (JSONObject)PersistentLoader.getInstance().getSuperPropertiesPst().get();
        if (superProperties != null && superProperties.has("$app_version")) {
            libProperties.put("$app_version", superProperties.get("$app_version"));
        }
        if (this.mContextManager.getSensorsDataAPI().isAutoTrackEnabled() && propertyJson != null && TrackEventAssemble.isAutoTrackType(trackEvent.getEventName()) && (trackEventType = TrackEventAssemble.autoTrackEventTypeFromEventName(trackEvent.getEventName())) != null && !this.mContextManager.getSensorsDataAPI().isAutoTrackEventTypeIgnored(trackEventType) && trackEvent.getProperties().has("$screen_name") && !TextUtils.isEmpty((CharSequence)(screenName = propertyJson.getString("$screen_name"))) && (screenNameArray = screenName.split("\\|")).length > 0) {
            libDetail = String.format("%s##%s##%s##%s", screenNameArray[0], "", "", "");
        }
        if (TextUtils.isEmpty((CharSequence)libDetail) && (trace = new Exception().getStackTrace()).length > 1) {
            StackTraceElement traceElement = trace[0];
            libDetail = String.format("%s##%s##%s##%s", traceElement.getClassName(), traceElement.getMethodName(), traceElement.getFileName(), traceElement.getLineNumber());
        }
        libProperties.put("$lib_detail", (Object)libDetail);
        trackEvent.setLib(libProperties);
        trackEvent.setProperties(propertyJson);
    }

    private void appendPluginProperties(EventType eventType, JSONObject properties, TrackEvent trackEvent) throws JSONException {
        SAPropertiesFetcher propertiesFetcher;
        SAPropertyFilter filter = new SAPropertyFilter();
        filter.setEvent(trackEvent.getEventName());
        filter.setTime(trackEvent.getTime());
        filter.setEventJson("lib", trackEvent.getLib());
        if (trackEvent.getIdentities() != null) {
            filter.setEventJson("identities", new JSONObject(trackEvent.getIdentities().toString()));
        }
        filter.setProperties(trackEvent.getProperties());
        filter.setType(eventType);
        SAPropertyPlugin customPlugin = this.mContextManager.getPluginManager().getPropertyPlugin(InternalCustomPropertyPlugin.class.getName());
        if (customPlugin instanceof InternalCustomPropertyPlugin) {
            ((InternalCustomPropertyPlugin)customPlugin).saveCustom(properties);
        }
        if ((propertiesFetcher = this.mContextManager.getPluginManager().propertiesHandler(filter)) != null) {
            trackEvent.setProperties(propertiesFetcher.getProperties());
            trackEvent.setLib(propertiesFetcher.getEventJson("lib"));
        }
    }

    private void appendUserIDs(InputData inputData, TrackEvent trackEvent) throws JSONException {
        String distinctId = this.mContextManager.getUserIdentityAPI().getDistinctId();
        String loginId = this.mContextManager.getUserIdentityAPI().getLoginId();
        String anonymousId = this.mContextManager.getUserIdentityAPI().getAnonymousId();
        try {
            if ("$PlanPopupDisplay".equals(trackEvent.getEventName())) {
                if (trackEvent.getProperties().has("$sf_internal_anonymous_id")) {
                    anonymousId = trackEvent.getProperties().optString("$sf_internal_anonymous_id");
                    trackEvent.getProperties().remove("$sf_internal_anonymous_id");
                    inputData.getProperties().remove("$sf_internal_anonymous_id");
                }
                if (trackEvent.getProperties().has("$sf_internal_login_id")) {
                    loginId = trackEvent.getProperties().optString("$sf_internal_login_id");
                    trackEvent.getProperties().remove("$sf_internal_login_id");
                    inputData.getProperties().remove("$sf_internal_login_id");
                }
                distinctId = !TextUtils.isEmpty((CharSequence)loginId) ? loginId : anonymousId;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        EventType eventType = inputData.getEventType();
        JSONObject identitiesJson = this.mContextManager.getUserIdentityAPI().getIdentities(eventType);
        if (!EventType.TRACK_ID_UNBIND.getEventType().equals(trackEvent.getType())) {
            if (identitiesJson != null) {
                if (!TextUtils.isEmpty((CharSequence)anonymousId)) {
                    identitiesJson.put("$identity_anonymous_id", (Object)anonymousId);
                } else {
                    anonymousId = identitiesJson.optString("$identity_anonymous_id");
                }
                if (!TextUtils.isEmpty((CharSequence)loginId)) {
                    String loginKey = this.mContextManager.getUserIdentityAPI().getIdentitiesInstance().getLoginIDKey();
                    if ("$identity_login_id".equals(loginKey)) {
                        identitiesJson.put(loginKey, (Object)loginId);
                    }
                } else {
                    loginId = identitiesJson.optString(this.mContextManager.getUserIdentityAPI().getIdentitiesInstance().getLoginIDKey());
                }
            }
            if (!TextUtils.isEmpty((CharSequence)loginId)) {
                trackEvent.setLoginId(loginId);
            }
            trackEvent.setAnonymousId(anonymousId);
        }
        trackEvent.setDistinctId(distinctId);
        trackEvent.setIdentities(identitiesJson);
        if (eventType == EventType.TRACK || eventType == EventType.TRACK_ID_BIND || eventType == EventType.TRACK_ID_UNBIND) {
            trackEvent.getProperties().put("$is_first_day", this.mContextManager.isFirstDay(trackEvent.getTime()));
        } else if (eventType == EventType.TRACK_SIGNUP) {
            trackEvent.setOriginalId(trackEvent.getAnonymousId());
        }
    }

    static boolean isAutoTrackType(String eventName) {
        if (!TextUtils.isEmpty((CharSequence)eventName)) {
            switch (eventName) {
                case "$AppStart": 
                case "$AppEnd": 
                case "$AppClick": 
                case "$AppViewScreen": {
                    return true;
                }
            }
        }
        return false;
    }

    static SensorsDataAPI.AutoTrackEventType autoTrackEventTypeFromEventName(String eventName) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return null;
        }
        switch (eventName) {
            case "$AppStart": {
                return SensorsDataAPI.AutoTrackEventType.APP_START;
            }
            case "$AppEnd": {
                return SensorsDataAPI.AutoTrackEventType.APP_END;
            }
            case "$AppClick": {
                return SensorsDataAPI.AutoTrackEventType.APP_CLICK;
            }
            case "$AppViewScreen": {
                return SensorsDataAPI.AutoTrackEventType.APP_VIEW_SCREEN;
            }
        }
        return null;
    }
}

