/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.event;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.event.Event;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.event.imp.AssembleDataImpl;
import com.sensorsdata.analytics.android.sdk.core.event.imp.SendDataImpl;
import com.sensorsdata.analytics.android.sdk.core.event.imp.StoreDataImpl;

public abstract class EventProcessor {
    IAssembleData mAssembleData;
    IStoreData mStoreData;
    ISendData mSendData;

    public EventProcessor(SAContextManager saContextManager) {
        this.mAssembleData = new AssembleDataImpl(saContextManager);
        this.mSendData = new SendDataImpl(saContextManager);
        this.mStoreData = new StoreDataImpl();
    }

    public abstract void trackEvent(InputData var1);

    protected synchronized void process(InputData input) {
        try {
            Event event = this.assembleData(input);
            int errorCode = this.storeData(event);
            this.sendData(input, errorCode);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    Event assembleData(InputData input) {
        return this.mAssembleData.assembleData(input);
    }

    int storeData(Event event) {
        return this.mStoreData.storeData(event);
    }

    void sendData(InputData inputData, int code) {
        this.mSendData.sendData(inputData, code);
    }

    public static interface ISendData {
        public void sendData(InputData var1, int var2);
    }

    public static interface IStoreData {
        public int storeData(Event var1);
    }

    public static interface IAssembleData {
        public Event assembleData(InputData var1);
    }
}

