/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.exceptions.ConnectErrorException;
import com.sensorsdata.analytics.android.sdk.exceptions.ResponseErrorException;
import com.sensorsdata.analytics.android.sdk.internal.beans.InternalConfigOptions;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class AnalyticsMessages {
    private static final String TAG = "SA.AnalyticsMessages";
    private static final int FLUSH_QUEUE = 3;
    private static final int DELETE_ALL = 4;
    private static final int FLUSH_SCHEDULE = 5;
    private static final int FLUSH_INSTANT_EVENT = 7;
    private static final Map<Context, AnalyticsMessages> S_INSTANCES = new HashMap<Context, AnalyticsMessages>();
    private final Worker mWorker;
    private final Context mContext;
    private final DbAdapter mDbAdapter;
    private final SensorsDataAPI mSensorsDataAPI;
    private final InternalConfigOptions mInternalConfigs;

    private AnalyticsMessages(Context context, SensorsDataAPI sensorsDataAPI, InternalConfigOptions internalConfigOptions) {
        this.mContext = context;
        this.mDbAdapter = DbAdapter.getInstance();
        this.mWorker = new Worker();
        this.mSensorsDataAPI = sensorsDataAPI;
        this.mInternalConfigs = internalConfigOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsMessages getInstance(Context messageContext, SensorsDataAPI sensorsDataAPI, InternalConfigOptions internalConfigOptions) {
        Map<Context, AnalyticsMessages> map = S_INSTANCES;
        synchronized (map) {
            AnalyticsMessages ret;
            Context appContext = messageContext.getApplicationContext();
            if (!S_INSTANCES.containsKey(appContext)) {
                ret = new AnalyticsMessages(appContext, sensorsDataAPI, internalConfigOptions);
                S_INSTANCES.put(appContext, ret);
            } else {
                ret = S_INSTANCES.get(appContext);
            }
            return ret;
        }
    }

    public static AnalyticsMessages getInstance(Context context) {
        return S_INSTANCES.get(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushEventMessage(boolean isSendImmediately) {
        try {
            DbAdapter dbAdapter = this.mDbAdapter;
            synchronized (dbAdapter) {
                Message m = Message.obtain();
                m.what = 3;
                if (isSendImmediately) {
                    this.mWorker.runMessage(m);
                } else {
                    this.mWorker.runMessageOnce(m, this.mSensorsDataAPI.getFlushInterval());
                }
            }
        }
        catch (Exception e) {
            SALog.i(TAG, "enqueueEventMessage error:" + e);
        }
    }

    public void flushInstanceEvent() {
        try {
            Message m = Message.obtain();
            m.what = 7;
            this.mWorker.runMessage(m);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void flush() {
        try {
            Message m = Message.obtain();
            m.what = 3;
            this.mWorker.runMessage(m);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    void flushScheduled() {
        try {
            Message m = Message.obtain();
            m.what = 5;
            this.mWorker.runMessageOnce(m, this.mSensorsDataAPI.getFlushInterval());
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    void deleteAll() {
        try {
            Message m = Message.obtain();
            m.what = 4;
            this.mWorker.runMessage(m);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private boolean sendCheck() {
        try {
            if (!this.mSensorsDataAPI.isNetworkRequestEnable()) {
                SALog.i(TAG, "NetworkRequest is disabled");
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)this.mSensorsDataAPI.getServerUrl())) {
                SALog.i(TAG, "Server url is null or empty.");
                return false;
            }
            if (!NetworkUtils.isNetworkAvailable(this.mContext)) {
                return false;
            }
            String networkType = NetworkUtils.networkType(this.mContext);
            if (!NetworkUtils.isShouldFlush(networkType, this.mSensorsDataAPI.getSAContextManager().getInternalConfigs().saConfigOptions.mNetworkTypePolicy)) {
                SALog.i(TAG, String.format("Invalid NetworkType = %s", networkType));
                return false;
            }
            if (this.mInternalConfigs.saConfigOptions.isMultiProcessFlush()) {
                if (DbAdapter.getInstance().isSubProcessFlushing()) {
                    return false;
                }
                DbAdapter.getInstance().commitSubProcessFlushState(true);
            } else if (!this.mInternalConfigs.isMainProcess) {
                return false;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private void sendData(boolean is_instant_event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendHttpRequest(String path, String data, String gzip, String rawMessage, boolean isRedirects, boolean is_instant_event) throws ConnectErrorException, ResponseErrorException {
        int responseCode;
        BufferedOutputStream bout;
        OutputStream out;
        InputStream in;
        HttpURLConnection connection;
        block20: {
            String location;
            String query;
            block19: {
                String cookie;
                block18: {
                    connection = null;
                    in = null;
                    out = null;
                    bout = null;
                    URL url = new URL(path);
                    connection = (HttpURLConnection)url.openConnection();
                    if (connection != null) break block18;
                    SALog.i(TAG, String.format("can not connect %s, it shouldn't happen", url));
                    SADataHelper.closeStream(bout, out, in, connection);
                    return;
                }
                SAConfigOptions configOptions = SensorsDataAPI.getConfigOptions();
                if (configOptions != null && configOptions.mSSLSocketFactory != null && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(configOptions.mSSLSocketFactory);
                }
                connection.setInstanceFollowRedirects(false);
                if (this.mSensorsDataAPI.getDebugMode() == SensorsDataAPI.DebugMode.DEBUG_ONLY) {
                    connection.addRequestProperty("Dry-Run", "true");
                }
                if (!TextUtils.isEmpty((CharSequence)(cookie = this.mSensorsDataAPI.getCookie(false)))) {
                    connection.setRequestProperty("Cookie", cookie);
                }
                Uri.Builder builder = new Uri.Builder();
                if (!TextUtils.isEmpty((CharSequence)data)) {
                    builder.appendQueryParameter("crc", String.valueOf(data.hashCode()));
                }
                builder.appendQueryParameter("gzip", gzip);
                builder.appendQueryParameter("data_list", data);
                if (is_instant_event) {
                    builder.appendQueryParameter("instant_event", "true");
                }
                if (!TextUtils.isEmpty((CharSequence)(query = builder.build().getEncodedQuery()))) break block19;
                SADataHelper.closeStream(bout, out, in, connection);
                return;
            }
            connection.setFixedLengthStreamingMode(query.getBytes("UTF-8").length);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            out = connection.getOutputStream();
            bout = new BufferedOutputStream(out);
            bout.write(query.getBytes("UTF-8"));
            bout.flush();
            responseCode = connection.getResponseCode();
            SALog.i(TAG, "responseCode: " + responseCode);
            if (isRedirects || !NetworkUtils.needRedirects(responseCode) || TextUtils.isEmpty((CharSequence)(location = NetworkUtils.getLocation(connection, path)))) break block20;
            SADataHelper.closeStream(bout, out, null, connection);
            this.sendHttpRequest(location, data, gzip, rawMessage, true, is_instant_event);
            SADataHelper.closeStream(bout, out, in, connection);
            return;
        }
        try {
            try {
                in = connection.getInputStream();
            }
            catch (FileNotFoundException e) {
                in = connection.getErrorStream();
            }
            byte[] responseBody = SADataHelper.slurp(in);
            in.close();
            in = null;
            String response = new String(responseBody, "UTF-8");
            if (SALog.isLogEnabled()) {
                String jsonMessage = JSONUtils.formatJson(rawMessage);
                if (responseCode >= 200 && responseCode < 300) {
                    SALog.i(TAG, "valid message: \n" + jsonMessage);
                } else {
                    SALog.i(TAG, "invalid message: \n" + jsonMessage);
                    SALog.i(TAG, String.format(TimeUtils.SDK_LOCALE, "ret_code: %d", responseCode));
                    SALog.i(TAG, String.format(TimeUtils.SDK_LOCALE, "ret_content: %s", response));
                }
            }
            if (responseCode < 200 || responseCode >= 300) {
                throw new ResponseErrorException(String.format("flush failure with response '%s', the response code is '%d'", response, responseCode), responseCode);
            }
        }
        catch (IOException e) {
            try {
                throw new ConnectErrorException(e);
            }
            catch (Throwable throwable) {
                SADataHelper.closeStream(bout, out, in, connection);
                throw throwable;
            }
        }
        SADataHelper.closeStream(bout, out, in, connection);
    }

    private boolean isDeleteEventsByCode(int httpCode) {
        boolean shouldDelete = httpCode != 404 && httpCode != 403 && (httpCode < 500 || httpCode >= 600);
        return shouldDelete;
    }

    private class Worker {
        private final Object mHandlerLock = new Object();
        private final Handler mHandler;

        Worker() {
            HandlerThread thread = new HandlerThread("com.sensorsdata.analytics.android.sdk.AnalyticsMessages.Worker", 1);
            thread.start();
            this.mHandler = new AnalyticsMessageHandler(thread.getLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runMessage(Message msg) {
            Object object = this.mHandlerLock;
            synchronized (object) {
                if (this.mHandler == null) {
                    SALog.i(AnalyticsMessages.TAG, "Dead worker dropping a message: " + msg.what);
                } else {
                    this.mHandler.sendMessage(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runMessageOnce(Message msg, long delay) {
            Object object = this.mHandlerLock;
            synchronized (object) {
                if (this.mHandler == null) {
                    SALog.i(AnalyticsMessages.TAG, "Dead worker dropping a message: " + msg.what);
                } else if (!this.mHandler.hasMessages(msg.what)) {
                    this.mHandler.sendMessageDelayed(msg, delay);
                }
            }
        }

        private class AnalyticsMessageHandler
        extends Handler {
            AnalyticsMessageHandler(Looper looper) {
                super(looper);
            }

            public void handleMessage(Message msg) {
                try {
                    if (msg.what == 3) {
                        AnalyticsMessages.this.sendData(true);
                        AnalyticsMessages.this.sendData(false);
                    } else if (msg.what == 4) {
                        try {
                            AnalyticsMessages.this.mDbAdapter.deleteAllEvents();
                        }
                        catch (Exception e) {
                            SALog.printStackTrace(e);
                        }
                    } else if (msg.what == 5) {
                        AnalyticsMessages.this.flushScheduled();
                        AnalyticsMessages.this.sendData(false);
                    } else if (msg.what == 7) {
                        AnalyticsMessages.this.sendData(true);
                    } else {
                        SALog.i(AnalyticsMessages.TAG, "Unexpected message received by SensorsData worker: " + msg);
                    }
                }
                catch (RuntimeException e) {
                    SALog.i(AnalyticsMessages.TAG, "Worker threw an unhandled exception", e);
                }
            }
        }
    }
}

