/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.impl;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataIgnoreTrackAppViewScreen;
import com.sensorsdata.analytics.android.sdk.SensorsDataIgnoreTrackAppViewScreenAndAppClick;
import com.sensorsdata.analytics.android.sdk.core.mediator.autotrack.IFragmentAPI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class FragmentAPI
implements IFragmentAPI {
    private static final String TAG = "FragmentAPI";
    private boolean mTrackFragmentAppViewScreen;
    private Set<Integer> mAutoTrackFragments;
    private Set<Integer> mAutoTrackIgnoredFragments;

    public void trackFragmentAppViewScreen() {
        this.mTrackFragmentAppViewScreen = true;
    }

    public boolean isTrackFragmentAppViewScreenEnabled() {
        return this.mTrackFragmentAppViewScreen;
    }

    public void enableAutoTrackFragment(Class<?> fragment) {
        try {
            String canonicalName;
            if (fragment == null) {
                return;
            }
            if (this.mAutoTrackFragments == null) {
                this.mAutoTrackFragments = new CopyOnWriteArraySet<Integer>();
            }
            if (!TextUtils.isEmpty((CharSequence)(canonicalName = fragment.getCanonicalName()))) {
                this.mAutoTrackFragments.add(canonicalName.hashCode());
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    public void enableAutoTrackFragments(List<Class<?>> fragmentsList) {
        if (fragmentsList == null || fragmentsList.size() == 0) {
            return;
        }
        if (this.mAutoTrackFragments == null) {
            this.mAutoTrackFragments = new CopyOnWriteArraySet<Integer>();
        }
        try {
            for (Class<?> fragment : fragmentsList) {
                String canonicalName = fragment.getCanonicalName();
                if (TextUtils.isEmpty((CharSequence)canonicalName)) continue;
                this.mAutoTrackFragments.add(canonicalName.hashCode());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public boolean isFragmentAutoTrackAppViewScreen(Class<?> fragment) {
        if (fragment == null) {
            return false;
        }
        try {
            String canonicalName;
            if (SensorsDataAPI.sharedInstance().isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_VIEW_SCREEN) || !this.mTrackFragmentAppViewScreen) {
                return false;
            }
            if (this.mAutoTrackFragments != null && this.mAutoTrackFragments.size() > 0 && !TextUtils.isEmpty((CharSequence)(canonicalName = fragment.getCanonicalName()))) {
                return this.mAutoTrackFragments.contains(canonicalName.hashCode());
            }
            if (fragment.getAnnotation(SensorsDataIgnoreTrackAppViewScreen.class) != null) {
                return false;
            }
            if (fragment.getAnnotation(SensorsDataIgnoreTrackAppViewScreenAndAppClick.class) != null) {
                return false;
            }
            if (this.mAutoTrackIgnoredFragments != null && this.mAutoTrackIgnoredFragments.size() > 0 && !TextUtils.isEmpty((CharSequence)(canonicalName = fragment.getCanonicalName()))) {
                return !this.mAutoTrackIgnoredFragments.contains(canonicalName.hashCode());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return true;
    }

    public void ignoreAutoTrackFragments(List<Class<?>> fragmentList) {
        try {
            if (fragmentList == null || fragmentList.size() == 0) {
                return;
            }
            if (this.mAutoTrackIgnoredFragments == null) {
                this.mAutoTrackIgnoredFragments = new CopyOnWriteArraySet<Integer>();
            }
            for (Class<?> fragment : fragmentList) {
                String canonicalName;
                if (fragment == null || TextUtils.isEmpty((CharSequence)(canonicalName = fragment.getCanonicalName()))) continue;
                this.mAutoTrackIgnoredFragments.add(canonicalName.hashCode());
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    public void ignoreAutoTrackFragment(Class<?> fragment) {
        try {
            String canonicalName;
            if (fragment == null) {
                return;
            }
            if (this.mAutoTrackIgnoredFragments == null) {
                this.mAutoTrackIgnoredFragments = new CopyOnWriteArraySet<Integer>();
            }
            if (!TextUtils.isEmpty((CharSequence)(canonicalName = fragment.getCanonicalName()))) {
                this.mAutoTrackIgnoredFragments.add(canonicalName.hashCode());
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    public void resumeIgnoredAutoTrackFragments(List<Class<?>> fragmentList) {
        try {
            if (fragmentList == null || fragmentList.size() == 0 || this.mAutoTrackIgnoredFragments == null) {
                return;
            }
            for (Class<?> fragment : fragmentList) {
                String canonicalName;
                if (fragment == null || TextUtils.isEmpty((CharSequence)(canonicalName = fragment.getCanonicalName()))) continue;
                this.mAutoTrackIgnoredFragments.remove(canonicalName.hashCode());
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    public void resumeIgnoredAutoTrackFragment(Class<?> fragment) {
        try {
            if (fragment == null || this.mAutoTrackIgnoredFragments == null) {
                return;
            }
            String canonicalName = fragment.getCanonicalName();
            if (!TextUtils.isEmpty((CharSequence)canonicalName)) {
                this.mAutoTrackIgnoredFragments.remove(canonicalName.hashCode());
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }
}

