/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.plugins;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertiesFetcher;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertyFilter;
import java.util.Date;
import org.json.JSONObject;

public class AutoTrackEventPlugin
extends SAPropertyPlugin {
    private String mEventName;

    public boolean isMatchedWithFilter(SAPropertyFilter filter) {
        this.mEventName = filter.getEvent();
        return "$AppStart".equals(filter.getEvent()) || "$AppEnd".equals(filter.getEvent());
    }

    public void properties(SAPropertiesFetcher fetcher) {
        try {
            JSONObject properties = fetcher.getProperties();
            JSONObject libProperties = fetcher.getEventJson("lib");
            long eventTime = System.currentTimeMillis();
            if ("$AppEnd".equals(this.mEventName)) {
                String appEnd_lib_version;
                long appEndTime = properties.optLong("event_time");
                if (appEndTime > 2000L) {
                    eventTime = appEndTime;
                }
                if (!TextUtils.isEmpty((CharSequence)(appEnd_lib_version = properties.optString("$lib_version")))) {
                    libProperties.put("$lib_version", (Object)appEnd_lib_version);
                } else {
                    properties.remove("$lib_version");
                }
                String appEnd_app_version = properties.optString("$app_version");
                if (TextUtils.isEmpty((CharSequence)appEnd_app_version)) {
                    properties.remove("$app_version");
                } else {
                    libProperties.put("$app_version", (Object)appEnd_app_version);
                }
                properties.remove("event_time");
            } else if ("$AppStart".equals(this.mEventName)) {
                long appStartTime = properties.optLong("event_time");
                if (appStartTime > 0L) {
                    eventTime = appStartTime;
                }
                properties.remove("event_time");
            }
            properties.put("$time", (Object)new Date(eventTime));
            fetcher.setProperties(properties);
            fetcher.setEventJson("lib", libProperties);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

