/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.business;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.ScreenAutoTracker;
import com.sensorsdata.analytics.android.sdk.SensorsDataAutoTrackAppViewScreenUrl;
import org.json.JSONObject;

public class SAPageTools {
    private static String mLastScreenUrl;
    private static String sReferrer;
    private static long sReferrerUrlTime;
    private static String mCurrentScreenUrl;
    private static String mReferrerTitle;
    private static long sReferrerTitleTime;
    private static String mCurrentTitle;
    private static long sTrackPropertiesTime;
    private static JSONObject sCurrentScreenTrackProperties;
    private static JSONObject sLastTrackProperties;

    public static String getLastScreenUrl() {
        return mLastScreenUrl;
    }

    public static void setLastScreenUrl(String lastScreenUrl) {
        mLastScreenUrl = lastScreenUrl;
    }

    public static String getReferrer() {
        return sReferrer;
    }

    public static String getReferrerTitle() {
        return mReferrerTitle;
    }

    public static String getCurrentTitle() {
        return mCurrentTitle;
    }

    public static void setCurrentTitle(String currentScreenTitle) {
        if (System.currentTimeMillis() - sReferrerTitleTime >= 400L) {
            mReferrerTitle = mCurrentTitle;
            sReferrerTitleTime = System.currentTimeMillis();
        }
        mCurrentTitle = currentScreenTitle;
    }

    public static void setCurrentScreenTrackProperties(JSONObject currentScreenTrackProperties) {
        if (System.currentTimeMillis() - sTrackPropertiesTime >= 400L) {
            sLastTrackProperties = sCurrentScreenTrackProperties;
            sTrackPropertiesTime = System.currentTimeMillis();
        }
        sCurrentScreenTrackProperties = currentScreenTrackProperties;
    }

    public static String getCurrentScreenUrl() {
        return mCurrentScreenUrl;
    }

    public static void setCurrentScreenUrl(String currentScreenUrl) {
        if (System.currentTimeMillis() - sReferrerUrlTime >= 400L) {
            sReferrer = mCurrentScreenUrl;
            sReferrerUrlTime = System.currentTimeMillis();
        }
        mLastScreenUrl = mCurrentScreenUrl;
        mCurrentScreenUrl = currentScreenUrl;
    }

    public static JSONObject getLastTrackProperties() {
        return sLastTrackProperties;
    }

    public static String getScreenUrl(Object object) {
        if (object == null) {
            return null;
        }
        String screenUrl = null;
        try {
            if (object instanceof ScreenAutoTracker) {
                ScreenAutoTracker screenAutoTracker = (ScreenAutoTracker)object;
                screenUrl = screenAutoTracker.getScreenUrl();
            } else {
                SensorsDataAutoTrackAppViewScreenUrl autoTrackAppViewScreenUrl = object.getClass().getAnnotation(SensorsDataAutoTrackAppViewScreenUrl.class);
                if (autoTrackAppViewScreenUrl != null) {
                    screenUrl = autoTrackAppViewScreenUrl.url();
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        if (screenUrl == null) {
            screenUrl = object.getClass().getCanonicalName();
        }
        return screenUrl;
    }
}

