/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.autotrack.core.autotrack;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.RadioGroup;
import android.widget.Spinner;
import com.sensorsdata.analytics.android.autotrack.R;
import com.sensorsdata.analytics.android.autotrack.core.autotrack.SAFragmentLifecycleCallbacks;
import com.sensorsdata.analytics.android.autotrack.core.business.SAPageTools;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.ScreenAutoTracker;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.WeakSet;
import java.util.Set;
import org.json.JSONObject;

public class FragmentViewScreenCallbacks
implements SAFragmentLifecycleCallbacks {
    private static final String TAG = "SA.FragmentViewScreenCallbacks";
    private final Set<Object> mPageFragments = new WeakSet();

    @Override
    public void onCreate(Object object) {
    }

    @Override
    public void onViewCreated(Object object, View rootView, Bundle bundle) {
        try {
            Window window;
            Context context;
            Activity activity;
            String fragmentName = object.getClass().getName();
            rootView.setTag(R.id.sensors_analytics_tag_view_fragment_name, (Object)fragmentName);
            if (rootView instanceof ViewGroup) {
                FragmentViewScreenCallbacks.traverseView(fragmentName, (ViewGroup)rootView);
            }
            if ((activity = SAViewUtils.getActivityOfView((Context)(context = rootView.getContext()), (View)rootView)) != null && (window = activity.getWindow()) != null) {
                window.getDecorView().getRootView().setTag(R.id.sensors_analytics_tag_view_fragment_name, (Object)"");
            }
            SAFragmentUtils.setFragmentToCache((String)fragmentName, (Object)object);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public void onStart(Object object) {
    }

    @Override
    public void onResume(Object object) {
        try {
            if (this.isFragmentValid(object)) {
                this.trackFragmentAppViewScreen(object);
                this.mPageFragments.add(object);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public void onPause(Object object) {
        if (object != null) {
            this.mPageFragments.remove(object);
        }
    }

    @Override
    public void onStop(Object object) {
    }

    @Override
    public void onHiddenChanged(Object object, boolean hidden) {
        try {
            if (object == null) {
                SALog.i((String)TAG, (String)"fragment is null,return");
                return;
            }
            if (hidden) {
                this.mPageFragments.remove(object);
                SALog.i((String)TAG, (String)"fragment hidden is true,return");
                return;
            }
            if (this.isFragmentValid(object)) {
                this.trackFragmentAppViewScreen(object);
                this.mPageFragments.add(object);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public void setUserVisibleHint(Object object, boolean isVisibleToUser) {
        try {
            if (object == null) {
                SALog.i((String)TAG, (String)"object is null");
                return;
            }
            if (!isVisibleToUser) {
                this.mPageFragments.remove(object);
                SALog.i((String)TAG, (String)"fragment isVisibleToUser is false,return");
                return;
            }
            if (this.isFragmentValid(object)) {
                this.trackFragmentAppViewScreen(object);
                this.mPageFragments.add(object);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private void trackFragmentAppViewScreen(Object fragment) {
        try {
            JSONObject properties = SAPageInfoUtils.getFragmentPageInfo(null, (Object)fragment);
            AppStateTools.getInstance().setFragmentScreenName(fragment, properties.optString("$screen_name"));
            if (fragment instanceof ScreenAutoTracker) {
                ScreenAutoTracker screenAutoTracker = (ScreenAutoTracker)fragment;
                JSONUtils.mergeJSONObject((JSONObject)screenAutoTracker.getTrackProperties(), (JSONObject)properties);
            }
            JSONObject eventProperties = SADataHelper.appendLibMethodAutoTrack((JSONObject)properties);
            SensorsDataAPI.sharedInstance().trackViewScreen(SAPageTools.getScreenUrl(fragment), eventProperties);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private boolean isFragmentValid(Object fragment) {
        if (fragment == null) {
            SALog.i((String)TAG, (String)"fragment is null, return");
            return false;
        }
        if (SensorsDataAPI.sharedInstance().isAutoTrackEventTypeIgnored(SensorsDataAPI.AutoTrackEventType.APP_VIEW_SCREEN)) {
            SALog.i((String)TAG, (String)"AutoTrackEventTypeIgnored, return");
            return false;
        }
        if (!SensorsDataAPI.sharedInstance().isTrackFragmentAppViewScreenEnabled()) {
            SALog.i((String)TAG, (String)"TrackFragmentAppViewScreenEnabled is false, return");
            return false;
        }
        Activity activity = SAFragmentUtils.getActivityFromFragment((Object)fragment);
        if (activity != null && SensorsDataAPI.sharedInstance().isActivityAutoTrackAppViewScreenIgnored(activity.getClass())) {
            SALog.i((String)TAG, (String)"isActivityAutoTrackAppViewScreenIgnored is false, return");
            return false;
        }
        if ("com.bumptech.glide.manager.SupportRequestManagerFragment".equals(fragment.getClass().getCanonicalName())) {
            SALog.i((String)TAG, (String)"fragment is SupportRequestManagerFragment,return");
            return false;
        }
        boolean isAutoTrackFragment = SensorsDataAPI.sharedInstance().isFragmentAutoTrackAppViewScreen(fragment.getClass());
        if (!isAutoTrackFragment) {
            SALog.i((String)TAG, (String)"fragment class ignored,return");
            return false;
        }
        if (this.mPageFragments.contains(fragment)) {
            SALog.i((String)TAG, (String)"pageFragment contains,return");
            return false;
        }
        if (!SAFragmentUtils.isFragmentVisible((Object)fragment)) {
            SALog.i((String)TAG, (String)"fragment is not visible,return");
            return false;
        }
        return true;
    }

    private static void traverseView(String fragmentName, ViewGroup root) {
        try {
            if (TextUtils.isEmpty((CharSequence)fragmentName) || root == null) {
                return;
            }
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = root.getChildAt(i);
                child.setTag(R.id.sensors_analytics_tag_view_fragment_name, (Object)fragmentName);
                if (!(child instanceof ViewGroup) || child instanceof ListView || child instanceof GridView || child instanceof Spinner || child instanceof RadioGroup) continue;
                FragmentViewScreenCallbacks.traverseView(fragmentName, (ViewGroup)child);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

