/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.utils;

import com.sensorsdata.analytics.android.plugin.common.VersionConstant;
import com.sensorsdata.analytics.android.plugin.utils.Logger;
import com.sensorsdata.analytics.android.plugin.visitor.AppExitHookVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lcom/sensorsdata/analytics/android/plugin/utils/SAUtils;", "", "()V", "appendDescBeforeGiven", "", "givenDesc", "appendDesc", "compareVersion", "", "version1", "version2", "convertOpcodes", "code", "initConfigs", "", "project", "Lorg/gradle/api/Project;", "isProtected", "", "access", "isPublic", "isStatic", "sa-gradle-plugin"})
public final class SAUtils {
    @NotNull
    public static final SAUtils INSTANCE = new SAUtils();

    private SAUtils() {
    }

    public final boolean isPublic(int access) {
        return (access & 1) != 0;
    }

    public final boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    public final boolean isProtected(int access) {
        return (access & 4) != 0;
    }

    public final int compareVersion(@NotNull String version1, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version1, (String)"version1");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version2");
        String[] stringArray = new String[]{"."};
        List v1Array = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)version1, (String)"-pre", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"."};
        List v2Array = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)version2, (String)"-pre", (String)"", (boolean)false, (int)4, null), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int maxLength = Math.max(v1Array.size(), v2Array.size());
        String str1 = null;
        String str2 = null;
        for (int index = 0; index < maxLength; ++index) {
            if (v1Array.size() <= index) {
                return -1;
            }
            str1 = (String)v1Array.get(index);
            if (v2Array.size() <= index) {
                return 1;
            }
            str2 = (String)v2Array.get(index);
            try {
                Integer num1 = Integer.valueOf(str1);
                Integer num2 = Integer.valueOf(str2);
                if (Intrinsics.areEqual((Object)num1, (Object)num2)) continue;
                int n = num1;
                Intrinsics.checkNotNullExpressionValue((Object)num2, (String)"num2");
                return n - num2 > 0 ? 1 : -1;
            }
            catch (Exception ignored) {
                return str1.compareTo(str2);
            }
        }
        return 0;
    }

    public final int convertOpcodes(int code) {
        int result = code;
        switch (code) {
            case 21: {
                result = 54;
                break;
            }
            case 25: {
                result = 58;
                break;
            }
            case 22: {
                result = 55;
                break;
            }
            case 23: {
                result = 56;
                break;
            }
            case 24: {
                result = 57;
                break;
            }
            case 54: {
                result = 21;
                break;
            }
            case 58: {
                result = 25;
                break;
            }
            case 55: {
                result = 22;
                break;
            }
            case 56: {
                result = 23;
                break;
            }
            case 57: {
                result = 24;
            }
        }
        return result;
    }

    @NotNull
    public final String appendDescBeforeGiven(@NotNull String givenDesc, @NotNull String appendDesc) {
        Intrinsics.checkNotNullParameter((Object)givenDesc, (String)"givenDesc");
        Intrinsics.checkNotNullParameter((Object)appendDesc, (String)"appendDesc");
        return StringsKt.replaceFirst$default((String)givenDesc, (String)"(", (String)('(' + appendDesc), (boolean)false, (int)4, null);
    }

    public final void initConfigs(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AppExitHookVisitor.Companion.setInstrumentationInserted(false);
        project.afterEvaluate(arg_0 -> SAUtils.initConfigs$lambda$0((Function1)new Function1<Project, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Project it) {
                ConfigurationContainer configurationContainer = this.$project.getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Iterable $this$forEach$iv = (Iterable)configurationContainer;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Configuration configuration = (Configuration)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)"implementation", (Object)configuration.getName())) continue;
                    DependencySet dependencySet = configuration.getDependencies();
                    Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configuration.dependencies");
                    Iterable $this$forEach$iv2 = (Iterable)dependencySet;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Dependency dependency = (Dependency)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)"SensorsAnalyticsSDK", (Object)dependency.getName())) continue;
                        Logger.INSTANCE.printNoLimit("Dependency: " + dependency.getGroup() + ':' + dependency.getName() + ':' + dependency.getVersion());
                        String string = dependency.getVersion();
                        Intrinsics.checkNotNull((Object)string);
                        VersionConstant.INSTANCE.setAnalyticsSDKVersion(string);
                    }
                }
            }
        }, arg_0));
    }

    private static final void initConfigs$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

