/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.version;

import com.sensorsdata.analytics.android.plugin.ClassNameAnalytics;
import com.sensorsdata.analytics.android.plugin.utils.Logger;
import com.sensorsdata.analytics.android.plugin.utils.SAUtils;
import com.sensorsdata.analytics.android.plugin.utils.TextUtil;
import com.sensorsdata.analytics.android.plugin.version.SensorsDataSDKVersionHelper;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.FieldVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/sensorsdata/analytics/android/plugin/version/SensorsAnalyticsVersionFieldVisitor;", "Lorg/objectweb/asm/FieldVisitor;", "api", "", "fieldVisitor", "mName", "", "mValue", "", "mSdkVersionHelper", "Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionHelper;", "mClassNameAnalytics", "Lcom/sensorsdata/analytics/android/plugin/ClassNameAnalytics;", "(ILorg/objectweb/asm/FieldVisitor;Ljava/lang/String;Ljava/lang/Object;Lcom/sensorsdata/analytics/android/plugin/version/SensorsDataSDKVersionHelper;Lcom/sensorsdata/analytics/android/plugin/ClassNameAnalytics;)V", "visitEnd", "", "sa-gradle-plugin"})
public final class SensorsAnalyticsVersionFieldVisitor
extends FieldVisitor {
    @Nullable
    private final String mName;
    @Nullable
    private final Object mValue;
    @NotNull
    private final SensorsDataSDKVersionHelper mSdkVersionHelper;
    @NotNull
    private final ClassNameAnalytics mClassNameAnalytics;

    public SensorsAnalyticsVersionFieldVisitor(int api, @Nullable FieldVisitor fieldVisitor, @Nullable String mName, @Nullable Object mValue, @NotNull SensorsDataSDKVersionHelper mSdkVersionHelper, @NotNull ClassNameAnalytics mClassNameAnalytics) {
        Intrinsics.checkNotNullParameter((Object)mSdkVersionHelper, (String)"mSdkVersionHelper");
        Intrinsics.checkNotNullParameter((Object)mClassNameAnalytics, (String)"mClassNameAnalytics");
        super(api, fieldVisitor);
        this.mName = mName;
        this.mValue = mValue;
        this.mSdkVersionHelper = mSdkVersionHelper;
        this.mClassNameAnalytics = mClassNameAnalytics;
    }

    public void visitEnd() {
        if (this.mClassNameAnalytics.isSensorsDataAPI()) {
            if (Intrinsics.areEqual((Object)"VERSION", (Object)this.mName)) {
                Object object = this.mValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String version = (String)object;
                if (SAUtils.INSTANCE.compareVersion("6.6.9", version) > 0) {
                    String string = "\u4f60\u76ee\u524d\u96c6\u6210\u7684\u795e\u7b56\u57cb\u70b9 SDK \u7248\u672c\u53f7\u4e3a v%s\uff0c\u8bf7\u5347\u7ea7\u5230 v%s \u53ca\u4ee5\u4e0a\u7684\u7248\u672c\u3002\u8be6\u60c5\u8bf7\u53c2\u8003\uff1ahttps://github.com/sensorsdata/sa-sdk-android";
                    Object[] objectArray = new Object[]{version, "6.6.9"};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    String errMessage = string2;
                    Logger.INSTANCE.error(errMessage);
                    throw new Error(errMessage);
                }
                String message = this.mSdkVersionHelper.getMessageBySDKCurrentVersion(this.mClassNameAnalytics.getClassName(), version);
                if (!TextUtil.INSTANCE.isEmpty(message)) {
                    throw new Error(message);
                }
            } else if (Intrinsics.areEqual((Object)"MIN_PLUGIN_VERSION", (Object)this.mName)) {
                Object object = this.mValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String minPluginVersion = (String)object;
                if (!TextUtil.INSTANCE.isEmpty(minPluginVersion) && SAUtils.INSTANCE.compareVersion("4.0.3", minPluginVersion) < 0) {
                    String string = "\u4f60\u76ee\u524d\u96c6\u6210\u7684\u795e\u7b56\u63d2\u4ef6\u7248\u672c\u53f7\u4e3a v%s\uff0c\u8bf7\u5347\u7ea7\u5230 v%s \u53ca\u4ee5\u4e0a\u7684\u7248\u672c\u3002\u8be6\u60c5\u8bf7\u53c2\u8003\uff1ahttps://github.com/sensorsdata/sa-sdk-android-plugin2";
                    Object[] objectArray = new Object[]{"4.0.3", minPluginVersion};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                    String errMessage = string3;
                    Logger.INSTANCE.error(errMessage);
                    throw new Error(errMessage);
                }
            }
        } else if (this.mClassNameAnalytics.isSensorsDataVersion()) {
            if (Intrinsics.areEqual((Object)"SDK_VERSION", (Object)this.mName)) {
                Object object = this.mValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String version = (String)object;
                String message = this.mSdkVersionHelper.getMessageBySDKCurrentVersion(this.mClassNameAnalytics.getClassName(), version);
                if (!TextUtil.INSTANCE.isEmpty(message)) {
                    throw new Error(message);
                }
            } else if (Intrinsics.areEqual((Object)"DEPENDENT_SDK_VERSIONS", (Object)this.mName)) {
                Object object = this.mValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String relatedOtherSDK = (String)object;
                String message = this.mSdkVersionHelper.getMessageBySDKRelyVersion(this.mClassNameAnalytics.getClassName(), relatedOtherSDK);
                if (!TextUtil.INSTANCE.isEmpty(message)) {
                    throw new Error(message);
                }
            }
        }
        super.visitEnd();
    }
}

