/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.viewclick;

import com.sensorsdata.analytics.android.plugin.ClassNameAnalytics;
import com.sensorsdata.analytics.android.plugin.SensorsAnalyticsHookConfig;
import com.sensorsdata.analytics.android.plugin.SensorsAnalyticsTransformHelper;
import com.sensorsdata.analytics.android.plugin.SensorsAnalyticsUtil;
import com.sensorsdata.analytics.android.plugin.fragment.SensorsFragmentHookConfig;
import com.sensorsdata.analytics.android.plugin.utils.Logger;
import com.sensorsdata.analytics.android.plugin.utils.VersionUtils;
import com.sensorsdata.analytics.android.plugin.viewclick.AutoTrackMethodVisitor;
import com.sensorsdata.analytics.android.plugin.viewclick.SensorsAnalyticsMethodCell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class SensorsAutoTrackMethodVisitor
extends AutoTrackMethodVisitor {
    boolean isSensorsDataTrackViewOnClickAnnotation = false;
    boolean isSensorsDataIgnoreTrackOnClick = false;
    String eventName = null;
    String eventProperties = "";
    boolean isHasInstrumented = false;
    boolean isHasTracked = false;
    int variableID = 0;
    boolean isOnClickMethod = false;
    boolean isOnItemClickMethod = false;
    String nameDesc;
    String name;
    String desc;
    int access;
    boolean pubAndNoStaticAccess;
    boolean protectedAndNotStaticAccess;
    ArrayList<Integer> localIds;
    private final SensorsAnalyticsTransformHelper transformHelper;
    private final MethodVisitor mMethodVisitor;
    private final boolean isAndroidTv;
    private final String mClassName;
    private final String mSuperName;
    private final ClassNameAnalytics mClassNameAnalytics;
    private final List<String> mInterfaces;
    private final HashMap<String, SensorsAnalyticsMethodCell> mLambdaMethodCells;
    private final HashSet<String> mVisitedFragMethods;

    public SensorsAutoTrackMethodVisitor(MethodVisitor mv, int access, String name, String desc, ClassNameAnalytics classNameAnalytics, SensorsAnalyticsTransformHelper transformHelper, String superClassName, String className, List<String> interfaces, HashSet<String> visitedFragMethods, HashMap<String, SensorsAnalyticsMethodCell> lambdaMethodCells) {
        super(mv, access, name, desc);
        this.name = name;
        this.desc = desc;
        this.access = access;
        this.nameDesc = name + desc;
        this.mMethodVisitor = mv;
        this.mClassName = className;
        this.mSuperName = superClassName;
        this.transformHelper = transformHelper;
        this.mVisitedFragMethods = visitedFragMethods;
        this.mClassNameAnalytics = classNameAnalytics;
        this.mInterfaces = interfaces;
        this.mLambdaMethodCells = lambdaMethodCells;
        this.isAndroidTv = VersionUtils.isTvVersion();
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.isHasTracked) {
            if (this.transformHelper.getExtension().lambdaEnabled) {
                this.mLambdaMethodCells.remove(this.nameDesc);
            }
            this.visitAnnotation("Lcom/sensorsdata/analytics/android/sdk/SensorsDataInstrumented;", false);
            Logger.info("Hooked method: " + this.name + this.desc + "\n");
        }
    }

    public void visitInvokeDynamicInsn(String name1, String desc1, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name1, desc1, bsm, bsmArgs);
        if (!this.transformHelper.getExtension().lambdaEnabled) {
            return;
        }
        try {
            String owner = bsm.getOwner();
            if (!"java/lang/invoke/LambdaMetafactory".equals(owner)) {
                return;
            }
            String desc2 = ((Type)bsmArgs[0]).getDescriptor();
            SensorsAnalyticsMethodCell sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.LAMBDA_METHODS.get(Type.getReturnType((String)desc1).getDescriptor() + name1 + desc2);
            if (sensorsAnalyticsMethodCell != null) {
                Handle it = (Handle)bsmArgs[1];
                this.mLambdaMethodCells.put(it.getName() + it.getDesc(), sensorsAnalyticsMethodCell);
            }
        }
        catch (Exception e) {
            Logger.warn("Some exception happened when call visitInvokeDynamicInsn: className: " + this.mClassName + ", error message: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void onMethodEnter() {
        SensorsAnalyticsMethodCell lambdaMethodCell;
        int thirdLocalId;
        super.onMethodEnter();
        this.pubAndNoStaticAccess = SensorsAnalyticsUtil.isPublic(this.access) && !SensorsAnalyticsUtil.isStatic(this.access);
        boolean bl = this.protectedAndNotStaticAccess = SensorsAnalyticsUtil.isProtected(this.access) && !SensorsAnalyticsUtil.isStatic(this.access);
        if (this.pubAndNoStaticAccess) {
            if (this.nameDesc.equals("onClick(Landroid/view/View;)V")) {
                this.isOnClickMethod = true;
                this.variableID = this.newLocal(Type.getObjectType((String)"java/lang/Integer"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, this.variableID);
            } else if (this.nameDesc.equals("onItemClick(Landroid/widget/AdapterView;Landroid/view/View;IJ)V")) {
                this.localIds = new ArrayList();
                this.isOnItemClickMethod = true;
                int first = this.newLocal(Type.getObjectType((String)"android/widget/AdapterView"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, first);
                this.localIds.add(first);
                int second = this.newLocal(Type.getObjectType((String)"android/view/View"));
                this.mMethodVisitor.visitVarInsn(25, 2);
                this.mMethodVisitor.visitVarInsn(58, second);
                this.localIds.add(second);
                int third = this.newLocal(Type.INT_TYPE);
                this.mMethodVisitor.visitVarInsn(21, 3);
                this.mMethodVisitor.visitVarInsn(54, third);
                this.localIds.add(third);
            } else if (SensorsAnalyticsUtil.isInstanceOfFragment(this.mSuperName) && SensorsFragmentHookConfig.FRAGMENT_METHODS.get(this.nameDesc) != null) {
                SensorsAnalyticsMethodCell sensorsAnalyticsMethodCell = SensorsFragmentHookConfig.FRAGMENT_METHODS.get(this.nameDesc);
                this.localIds = new ArrayList();
                Type[] types = Type.getArgumentTypes((String)this.desc);
                for (int i = 1; i < sensorsAnalyticsMethodCell.getParamsCount(); ++i) {
                    int localId = this.newLocal(types[i - 1]);
                    this.mMethodVisitor.visitVarInsn(sensorsAnalyticsMethodCell.getOpcodes().get(i).intValue(), i);
                    this.mMethodVisitor.visitVarInsn(SensorsAnalyticsUtil.convertOpcodes(sensorsAnalyticsMethodCell.getOpcodes().get(i)), localId);
                    this.localIds.add(localId);
                }
            } else if (this.nameDesc.equals("onCheckedChanged(Landroid/widget/RadioGroup;I)V")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"android/widget/RadioGroup"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
                int secondLocalId = this.newLocal(Type.INT_TYPE);
                this.mMethodVisitor.visitVarInsn(21, 2);
                this.mMethodVisitor.visitVarInsn(54, secondLocalId);
                this.localIds.add(secondLocalId);
            } else if (this.nameDesc.equals("onCheckedChanged(Landroid/widget/CompoundButton;Z)V")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"android/widget/CompoundButton"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
            } else if (this.nameDesc.equals("onClick(Landroid/content/DialogInterface;I)V")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"android/content/DialogInterface"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
                int secondLocalId = this.newLocal(Type.INT_TYPE);
                this.mMethodVisitor.visitVarInsn(21, 2);
                this.mMethodVisitor.visitVarInsn(54, secondLocalId);
                this.localIds.add(secondLocalId);
            } else if (SensorsAnalyticsUtil.isTargetMenuMethodDesc(this.nameDesc)) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"java/lang/Object"));
                this.mMethodVisitor.visitVarInsn(25, 0);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
                int secondLocalId = this.newLocal(Type.getObjectType((String)"android/view/MenuItem"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, secondLocalId);
                this.localIds.add(secondLocalId);
            } else if (this.nameDesc.equals("onMenuItemClick(Landroid/view/MenuItem;)Z")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"android/view/MenuItem"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
            } else if (this.nameDesc.equals("onGroupClick(Landroid/widget/ExpandableListView;Landroid/view/View;IJ)Z")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"android/widget/ExpandableListView"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
                int secondLocalId = this.newLocal(Type.getObjectType((String)"android/view/View"));
                this.mMethodVisitor.visitVarInsn(25, 2);
                this.mMethodVisitor.visitVarInsn(58, secondLocalId);
                this.localIds.add(secondLocalId);
                thirdLocalId = this.newLocal(Type.INT_TYPE);
                this.mMethodVisitor.visitVarInsn(21, 3);
                this.mMethodVisitor.visitVarInsn(54, thirdLocalId);
                this.localIds.add(thirdLocalId);
            } else if (this.nameDesc.equals("onChildClick(Landroid/widget/ExpandableListView;Landroid/view/View;IIJ)Z")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"android/widget/ExpandableListView"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
                int secondLocalId = this.newLocal(Type.getObjectType((String)"android/view/View"));
                this.mMethodVisitor.visitVarInsn(25, 2);
                this.mMethodVisitor.visitVarInsn(58, secondLocalId);
                this.localIds.add(secondLocalId);
                thirdLocalId = this.newLocal(Type.INT_TYPE);
                this.mMethodVisitor.visitVarInsn(21, 3);
                this.mMethodVisitor.visitVarInsn(54, thirdLocalId);
                this.localIds.add(thirdLocalId);
                int fourthLocalId = this.newLocal(Type.INT_TYPE);
                this.mMethodVisitor.visitVarInsn(21, 4);
                this.mMethodVisitor.visitVarInsn(54, fourthLocalId);
                this.localIds.add(fourthLocalId);
            } else if (this.nameDesc.equals("onItemSelected(Landroid/widget/AdapterView;Landroid/view/View;IJ)V") || this.nameDesc.equals("onListItemClick(Landroid/widget/ListView;Landroid/view/View;IJ)V")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"java/lang/Object"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
                int secondLocalId = this.newLocal(Type.getObjectType((String)"android/view/View"));
                this.mMethodVisitor.visitVarInsn(25, 2);
                this.mMethodVisitor.visitVarInsn(58, secondLocalId);
                this.localIds.add(secondLocalId);
                thirdLocalId = this.newLocal(Type.INT_TYPE);
                this.mMethodVisitor.visitVarInsn(21, 3);
                this.mMethodVisitor.visitVarInsn(54, thirdLocalId);
                this.localIds.add(thirdLocalId);
            } else if (this.nameDesc.equals("onStopTrackingTouch(Landroid/widget/SeekBar;)V")) {
                this.localIds = new ArrayList();
                int firstLocalId = this.newLocal(Type.getObjectType((String)"android/widget/SeekBar"));
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(58, firstLocalId);
                this.localIds.add(firstLocalId);
            }
        } else if (this.protectedAndNotStaticAccess && this.nameDesc.equals("onListItemClick(Landroid/widget/ListView;Landroid/view/View;IJ)V")) {
            this.localIds = new ArrayList();
            int firstLocalId = this.newLocal(Type.getObjectType((String)"java/lang/Object"));
            this.mMethodVisitor.visitVarInsn(25, 1);
            this.mMethodVisitor.visitVarInsn(58, firstLocalId);
            this.localIds.add(firstLocalId);
            int secondLocalId = this.newLocal(Type.getObjectType((String)"android/view/View"));
            this.mMethodVisitor.visitVarInsn(25, 2);
            this.mMethodVisitor.visitVarInsn(58, secondLocalId);
            this.localIds.add(secondLocalId);
            thirdLocalId = this.newLocal(Type.INT_TYPE);
            this.mMethodVisitor.visitVarInsn(21, 3);
            this.mMethodVisitor.visitVarInsn(54, thirdLocalId);
            this.localIds.add(thirdLocalId);
        }
        if (this.transformHelper.getExtension().lambdaEnabled && (lambdaMethodCell = this.mLambdaMethodCells.get(this.nameDesc)) != null && (this.transformHelper.getExtension().lambdaParamOptimize || SensorsAnalyticsHookConfig.SAMPLING_LAMBDA_METHODS.contains(lambdaMethodCell))) {
            Type[] types = Type.getArgumentTypes((String)lambdaMethodCell.getDesc());
            int length = types.length;
            Type[] lambdaTypes = Type.getArgumentTypes((String)this.desc);
            int paramStart = lambdaTypes.length - length;
            if (paramStart < 0) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                if (lambdaTypes[paramStart + i].getDescriptor().equals(types[i].getDescriptor())) continue;
                return;
            }
            boolean isStaticMethod = SensorsAnalyticsUtil.isStatic(this.access);
            this.localIds = new ArrayList();
            for (int i = paramStart; i < paramStart + lambdaMethodCell.getParamsCount(); ++i) {
                int localId = this.newLocal(types[i - paramStart]);
                this.mMethodVisitor.visitVarInsn(lambdaMethodCell.getOpcodes().get(i - paramStart).intValue(), this.getVisitPosition(lambdaTypes, i, isStaticMethod));
                this.mMethodVisitor.visitVarInsn(SensorsAnalyticsUtil.convertOpcodes(lambdaMethodCell.getOpcodes().get(i - paramStart)), localId);
                this.localIds.add(localId);
            }
        }
        if (this.transformHelper.isHookOnMethodEnter) {
            this.handleCode();
        }
    }

    @Override
    public void onMethodExit(int opcode) {
        super.onMethodExit(opcode);
        if (!this.transformHelper.isHookOnMethodEnter) {
            this.handleCode();
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String fieldName, String fieldDesc) {
        if (this.mClassNameAnalytics.isKeyboardViewUtil && !this.transformHelper.getExtension().disableTrackKeyboard && "isSensorsCheckKeyboard".equals(fieldName) && opcode == 179) {
            this.mMethodVisitor.visitInsn(3);
        }
        super.visitFieldInsn(opcode, owner, fieldName, fieldDesc);
    }

    void handleCode() {
        SensorsAnalyticsMethodCell lambdaMethodCell;
        Object sensorsAnalyticsMethodCell;
        if (this.isHasInstrumented || this.mClassNameAnalytics.isSensorsDataAPI) {
            return;
        }
        if (SensorsAnalyticsUtil.isInstanceOfFragment(this.mSuperName) && (sensorsAnalyticsMethodCell = SensorsFragmentHookConfig.FRAGMENT_METHODS.get(this.nameDesc)) != null) {
            this.mVisitedFragMethods.add(this.nameDesc);
            this.mMethodVisitor.visitVarInsn(25, 0);
            for (int i = 1; i < ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getParamsCount(); ++i) {
                this.mMethodVisitor.visitVarInsn(((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getOpcodes().get(i).intValue(), this.localIds.get(i - 1).intValue());
            }
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/FragmentTrackHelper", ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentName(), ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentDesc(), false);
            this.isHasTracked = true;
            return;
        }
        if (this.isSensorsDataIgnoreTrackOnClick) {
            return;
        }
        if (this.transformHelper.getExtension().lambdaEnabled && (lambdaMethodCell = this.mLambdaMethodCells.get(this.nameDesc)) != null) {
            Type[] types = Type.getArgumentTypes((String)lambdaMethodCell.getDesc());
            int length = types.length;
            Type[] lambdaTypes = Type.getArgumentTypes((String)this.desc);
            int paramStart = lambdaTypes.length - length;
            if (paramStart < 0) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                if (lambdaTypes[paramStart + i].getDescriptor().equals(types[i].getDescriptor())) continue;
                return;
            }
            boolean isStaticMethod = SensorsAnalyticsUtil.isStatic(this.access);
            if (!isStaticMethod && lambdaMethodCell.getDesc().equals("(Landroid/view/MenuItem;)Z")) {
                this.mMethodVisitor.visitVarInsn(25, 0);
                this.mMethodVisitor.visitVarInsn(25, this.getVisitPosition(lambdaTypes, paramStart, isStaticMethod));
                this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", lambdaMethodCell.getAgentName(), "(Ljava/lang/Object;Landroid/view/MenuItem;)V", false);
                this.isHasTracked = true;
                return;
            }
            if (this.transformHelper.getExtension().lambdaParamOptimize || SensorsAnalyticsHookConfig.SAMPLING_LAMBDA_METHODS.contains(lambdaMethodCell)) {
                for (int i = paramStart; i < paramStart + lambdaMethodCell.getParamsCount(); ++i) {
                    this.mMethodVisitor.visitVarInsn(lambdaMethodCell.getOpcodes().get(i - paramStart).intValue(), this.localIds.get(i - paramStart).intValue());
                }
            } else {
                for (int i = paramStart; i < paramStart + lambdaMethodCell.getParamsCount(); ++i) {
                    this.mMethodVisitor.visitVarInsn(lambdaMethodCell.getOpcodes().get(i - paramStart).intValue(), this.getVisitPosition(lambdaTypes, i, isStaticMethod));
                }
            }
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", lambdaMethodCell.getAgentName(), lambdaMethodCell.getAgentDesc(), false);
            this.isHasTracked = true;
            return;
        }
        if (!this.pubAndNoStaticAccess) {
            if (this.protectedAndNotStaticAccess && this.nameDesc.equals("onListItemClick(Landroid/widget/ListView;Landroid/view/View;IJ)V")) {
                this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                this.mMethodVisitor.visitVarInsn(25, this.localIds.get(1).intValue());
                this.mMethodVisitor.visitVarInsn(21, this.localIds.get(2).intValue());
                this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackListView", "(Landroid/widget/AdapterView;Landroid/view/View;I)V", false);
                this.isHasTracked = true;
                return;
            }
            return;
        }
        if (this.isAndroidTv && SensorsAnalyticsUtil.isInstanceOfActivity(this.mSuperName) && this.nameDesc.equals("dispatchKeyEvent(Landroid/view/KeyEvent;)Z")) {
            this.mMethodVisitor.visitVarInsn(25, 0);
            this.mMethodVisitor.visitVarInsn(25, 1);
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackViewOnClick", "(Landroid/app/Activity;Landroid/view/KeyEvent;)V", false);
            this.isHasTracked = true;
            return;
        }
        if (this.handleRN()) {
            this.isHasTracked = true;
            return;
        }
        if (SensorsAnalyticsUtil.isTargetMenuMethodDesc(this.nameDesc)) {
            this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
            this.mMethodVisitor.visitVarInsn(25, this.localIds.get(1).intValue());
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackMenuItem", "(Ljava/lang/Object;Landroid/view/MenuItem;)V", false);
            this.isHasTracked = true;
            return;
        }
        if (this.nameDesc.equals("onDrawerOpened(Landroid/view/View;)V")) {
            this.mMethodVisitor.visitVarInsn(25, 1);
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackDrawerOpened", "(Landroid/view/View;)V", false);
            this.isHasTracked = true;
            return;
        }
        if (this.nameDesc.equals("onDrawerClosed(Landroid/view/View;)V")) {
            this.mMethodVisitor.visitVarInsn(25, 1);
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackDrawerClosed", "(Landroid/view/View;)V", false);
            this.isHasTracked = true;
            return;
        }
        if (this.isOnClickMethod && this.mClassName.equals("android/databinding/generated/callback/OnClickListener")) {
            this.trackViewOnClick(this.mMethodVisitor, 1);
            this.isHasTracked = true;
            return;
        }
        if (!(SensorsAnalyticsUtil.isTargetClassInSpecial(this.mClassName) || !this.mClassName.startsWith("android/") && !this.mClassName.startsWith("androidx/") || this.mClassName.startsWith("android/support/v17/leanback") || this.mClassName.startsWith("androidx/leanback"))) {
            return;
        }
        if (this.nameDesc.equals("onItemSelected(Landroid/widget/AdapterView;Landroid/view/View;IJ)V") || this.nameDesc.equals("onListItemClick(Landroid/widget/ListView;Landroid/view/View;IJ)V")) {
            this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
            this.mMethodVisitor.visitVarInsn(25, this.localIds.get(1).intValue());
            this.mMethodVisitor.visitVarInsn(21, this.localIds.get(2).intValue());
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackListView", "(Landroid/widget/AdapterView;Landroid/view/View;I)V", false);
            this.isHasTracked = true;
            return;
        }
        if (this.isSensorsDataTrackViewOnClickAnnotation && this.desc.equals("(Landroid/view/View;)V")) {
            this.trackViewOnClick(this.mMethodVisitor, 1);
            this.isHasTracked = true;
            return;
        }
        if (this.eventName != null && this.eventName.length() != 0) {
            this.mMethodVisitor.visitLdcInsn((Object)this.eventName);
            this.mMethodVisitor.visitLdcInsn((Object)this.eventProperties);
            this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "track", "(Ljava/lang/String;Ljava/lang/String;)V", false);
            this.isHasTracked = true;
            return;
        }
        if (this.mInterfaces != null && this.mInterfaces.size() > 0) {
            if (this.isOnItemClickMethod && this.mInterfaces.contains("android/widget/AdapterView$OnItemClickListener")) {
                this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                this.mMethodVisitor.visitVarInsn(25, this.localIds.get(1).intValue());
                this.mMethodVisitor.visitVarInsn(21, this.localIds.get(2).intValue());
                this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackListView", "(Landroid/widget/AdapterView;Landroid/view/View;I)V", false);
                this.isHasTracked = true;
                return;
            }
            if (this.mInterfaces.contains("android/widget/RadioGroup$OnCheckedChangeListener") && this.nameDesc.equals("onCheckedChanged(Landroid/widget/RadioGroup;I)V")) {
                sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get("android/widget/RadioGroup$OnCheckedChangeListeneronCheckedChanged(Landroid/widget/RadioGroup;I)V");
                if (sensorsAnalyticsMethodCell != null) {
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                    this.mMethodVisitor.visitVarInsn(21, this.localIds.get(1).intValue());
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentName(), ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentDesc(), false);
                    this.isHasTracked = true;
                    return;
                }
            } else if (this.mInterfaces.contains("android/widget/CompoundButton$OnCheckedChangeListener") && this.nameDesc.equals("onCheckedChanged(Landroid/widget/CompoundButton;Z)V")) {
                sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get("android/widget/CompoundButton$OnCheckedChangeListeneronCheckedChanged(Landroid/widget/CompoundButton;Z)V");
                if (sensorsAnalyticsMethodCell != null) {
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentName(), ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentDesc(), false);
                    this.isHasTracked = true;
                    return;
                }
            } else if (this.mInterfaces.contains("android/content/DialogInterface$OnClickListener") && this.nameDesc.equals("onClick(Landroid/content/DialogInterface;I)V")) {
                sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get("android/content/DialogInterface$OnClickListeneronClick(Landroid/content/DialogInterface;I)V");
                if (sensorsAnalyticsMethodCell != null) {
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                    this.mMethodVisitor.visitVarInsn(21, this.localIds.get(1).intValue());
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentName(), ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentDesc(), false);
                    this.isHasTracked = true;
                    return;
                }
            } else if (this.mInterfaces.contains("android/widget/ExpandableListView$OnGroupClickListener") && this.nameDesc.equals("onGroupClick(Landroid/widget/ExpandableListView;Landroid/view/View;IJ)Z")) {
                sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get("android/widget/ExpandableListView$OnGroupClickListeneronGroupClick(Landroid/widget/ExpandableListView;Landroid/view/View;IJ)Z");
                if (sensorsAnalyticsMethodCell != null) {
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(1).intValue());
                    this.mMethodVisitor.visitVarInsn(21, this.localIds.get(2).intValue());
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentName(), ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentDesc(), false);
                    this.isHasTracked = true;
                    return;
                }
            } else if (this.mInterfaces.contains("android/widget/ExpandableListView$OnChildClickListener") && this.nameDesc.equals("onChildClick(Landroid/widget/ExpandableListView;Landroid/view/View;IIJ)Z")) {
                sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get("android/widget/ExpandableListView$OnChildClickListeneronChildClick(Landroid/widget/ExpandableListView;Landroid/view/View;IIJ)Z");
                if (sensorsAnalyticsMethodCell != null) {
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(1).intValue());
                    this.mMethodVisitor.visitVarInsn(21, this.localIds.get(2).intValue());
                    this.mMethodVisitor.visitVarInsn(21, this.localIds.get(3).intValue());
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentName(), ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentDesc(), false);
                    this.isHasTracked = true;
                    return;
                }
            } else if (this.nameDesc.equals("onMenuItemClick(Landroid/view/MenuItem;)Z")) {
                for (String interfaceName : this.mInterfaces) {
                    SensorsAnalyticsMethodCell sensorsAnalyticsMethodCell2 = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get(interfaceName + this.nameDesc);
                    if (sensorsAnalyticsMethodCell2 == null) continue;
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", sensorsAnalyticsMethodCell2.getAgentName(), sensorsAnalyticsMethodCell2.getAgentDesc(), false);
                    this.isHasTracked = true;
                    return;
                }
            } else if (this.mInterfaces.contains("android/widget/SeekBar$OnSeekBarChangeListener") && this.nameDesc.equals("onStopTrackingTouch(Landroid/widget/SeekBar;)V")) {
                sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get("android/widget/SeekBar$OnSeekBarChangeListeneronStopTrackingTouch(Landroid/widget/SeekBar;)V");
                if (sensorsAnalyticsMethodCell != null) {
                    this.mMethodVisitor.visitVarInsn(25, this.localIds.get(0).intValue());
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentName(), ((SensorsAnalyticsMethodCell)sensorsAnalyticsMethodCell).getAgentDesc(), false);
                    this.isHasTracked = true;
                    return;
                }
            } else {
                for (String interfaceName : this.mInterfaces) {
                    SensorsAnalyticsMethodCell sensorsAnalyticsMethodCell3 = SensorsAnalyticsHookConfig.INTERFACE_METHODS.get(interfaceName + this.nameDesc);
                    if (sensorsAnalyticsMethodCell3 == null) continue;
                    sensorsAnalyticsMethodCell3.visitHookMethod(this.mMethodVisitor, 184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper");
                    this.isHasTracked = true;
                    return;
                }
            }
        }
        this.handleClassMethod(this.mClassName, this.nameDesc);
        if (this.isOnClickMethod) {
            this.trackViewOnClick(this.mMethodVisitor, this.variableID);
            this.isHasTracked = true;
        }
    }

    void handleClassMethod(String className, String nameDesc) {
        SensorsAnalyticsMethodCell sensorsAnalyticsMethodCell = SensorsAnalyticsHookConfig.CLASS_METHODS.get(className + nameDesc);
        if (sensorsAnalyticsMethodCell != null) {
            sensorsAnalyticsMethodCell.visitHookMethod(this.mMethodVisitor, 184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper");
            this.isHasTracked = true;
        }
    }

    boolean handleRN() {
        boolean result = false;
        switch (this.transformHelper.rnState) {
            case NOT_FOUND: {
                break;
            }
            case HAS_VERSION: {
                if (SensorsAnalyticsUtil.compareVersion(this.transformHelper.rnVersion, "2.0.0") > 0 && this.mSuperName.equals("com/facebook/react/uimanager/ViewGroupManager") && this.nameDesc.equals("addView(Landroid/view/ViewGroup;Landroid/view/View;I)V")) {
                    this.mMethodVisitor.visitVarInsn(25, 2);
                    this.mMethodVisitor.visitVarInsn(21, 3);
                    this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/RNAgent", "addView", "(Landroid/view/View;I)V", false);
                    result = true;
                }
                if (!this.nameDesc.equals("handleTouchEvent(Landroid/view/MotionEvent;Lcom/facebook/react/uimanager/events/EventDispatcher;)V' && mClassName == 'com/facebook/react/uimanager/JSTouchDispatcher")) break;
                this.mMethodVisitor.visitVarInsn(25, 0);
                this.mMethodVisitor.visitVarInsn(25, 1);
                this.mMethodVisitor.visitVarInsn(25, 2);
                this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/RNAgent", "handleTouchEvent", "(Lcom/facebook/react/uimanager/JSTouchDispatcher;Landroid/view/MotionEvent;Lcom/facebook/react/uimanager/events/EventDispatcher;)V", false);
                result = true;
                break;
            }
            case NO_VERSION: {
                if (!this.nameDesc.equals("setJSResponder(IIZ)V") || !this.mClassName.equals("com/facebook/react/uimanager/NativeViewHierarchyManager")) break;
                this.mMethodVisitor.visitVarInsn(25, 0);
                this.mMethodVisitor.visitVarInsn(21, 1);
                this.mMethodVisitor.visitVarInsn(21, 2);
                this.mMethodVisitor.visitVarInsn(21, 3);
                this.mMethodVisitor.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackRN", "(Ljava/lang/Object;IIZ)V", false);
                result = true;
            }
        }
        return result;
    }

    void trackViewOnClick(MethodVisitor mv, int index) {
        mv.visitVarInsn(25, index);
        mv.visitMethodInsn(184, "com/sensorsdata/analytics/android/autotrack/aop/SensorsDataAutoTrackHelper", "trackViewOnClick", "(Landroid/view/View;)V", false);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        if (s.equals("Lcom/sensorsdata/analytics/android/sdk/SensorsDataTrackViewOnClick;")) {
            this.isSensorsDataTrackViewOnClickAnnotation = true;
            Logger.info("\u53d1\u73b0 " + this.nameDesc + " \u6709\u6ce8\u89e3 @SensorsDataTrackViewOnClick");
        } else if (s.equals("Lcom/sensorsdata/analytics/android/sdk/SensorsDataIgnoreTrackOnClick;")) {
            this.isSensorsDataIgnoreTrackOnClick = true;
            Logger.info("\u53d1\u73b0 " + this.nameDesc + " \u6709\u6ce8\u89e3 @SensorsDataIgnoreTrackOnClick");
        } else if (s.equals("Lcom/sensorsdata/analytics/android/sdk/SensorsDataInstrumented;")) {
            this.isHasInstrumented = true;
        } else if (s.equals("Lcom/sensorsdata/analytics/android/sdk/SensorsDataTrackEvent;")) {
            return new AnnotationVisitor(SensorsAnalyticsUtil.ASM_VERSION){

                public void visit(String key, Object value) {
                    super.visit(key, value);
                    if ("eventName".equals(key)) {
                        SensorsAutoTrackMethodVisitor.this.eventName = (String)value;
                    } else if ("properties".equals(key)) {
                        SensorsAutoTrackMethodVisitor.this.eventProperties = value.toString();
                    }
                }
            };
        }
        return super.visitAnnotation(s, b);
    }

    int getVisitPosition(Type[] types, int index, boolean isStaticMethod) {
        if (types == null || index < 0 || index >= types.length) {
            throw new Error("getVisitPosition error");
        }
        if (index == 0) {
            return isStaticMethod ? 0 : 1;
        }
        return this.getVisitPosition(types, index - 1, isStaticMethod) + types[index - 1].getSize();
    }
}

