/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.version;

import com.sensorsdata.analytics.android.plugin.ClassNameAnalytics;
import com.sensorsdata.analytics.android.plugin.SensorsAnalyticsUtil;
import com.sensorsdata.analytics.android.plugin.utils.Logger;
import com.sensorsdata.analytics.android.plugin.utils.TextUtil;
import com.sensorsdata.analytics.android.plugin.version.SensorsDataSDKVersionHelper;
import org.objectweb.asm.FieldVisitor;

public class SensorsAnalyticsVersionFieldVisitor
extends FieldVisitor {
    private String mName;
    private String mClassName;
    private Object mValue;
    private SensorsDataSDKVersionHelper mSdkVersionHelper;
    private ClassNameAnalytics mClassNameAnalytics;

    public SensorsAnalyticsVersionFieldVisitor(int api, FieldVisitor fieldVisitor, String name, Object value, SensorsDataSDKVersionHelper sdkVersionHelper, String className, ClassNameAnalytics classNameAnalytics) {
        super(api, fieldVisitor);
        this.mName = name;
        this.mValue = value;
        this.mSdkVersionHelper = sdkVersionHelper;
        this.mClassName = className;
        this.mClassNameAnalytics = classNameAnalytics;
    }

    public void visitEnd() {
        if (this.mClassNameAnalytics.isSensorsDataAPI) {
            String minPluginVersion;
            if ("VERSION".equals(this.mName)) {
                String version = (String)this.mValue;
                if (SensorsAnalyticsUtil.compareVersion("6.5.3", version) > 0) {
                    String errMessage = String.format("\u4f60\u76ee\u524d\u96c6\u6210\u7684\u795e\u7b56\u57cb\u70b9 SDK \u7248\u672c\u53f7\u4e3a v%s\uff0c\u8bf7\u5347\u7ea7\u5230 v%s \u53ca\u4ee5\u4e0a\u7684\u7248\u672c\u3002\u8be6\u60c5\u8bf7\u53c2\u8003\uff1ahttps://github.com/sensorsdata/sa-sdk-android", version, "6.5.3");
                    Logger.error(errMessage);
                    throw new Error(errMessage);
                }
                String message = this.mSdkVersionHelper.getMessageBySDKCurrentVersion(this.mClassName, version);
                if (!TextUtil.isEmpty(message)) {
                    throw new Error(message);
                }
            } else if ("MIN_PLUGIN_VERSION".equals(this.mName) && !TextUtil.isEmpty(minPluginVersion = (String)this.mValue) && SensorsAnalyticsUtil.compareVersion("3.5.3", minPluginVersion) < 0) {
                String errMessage = String.format("\u4f60\u76ee\u524d\u96c6\u6210\u7684\u795e\u7b56\u63d2\u4ef6\u7248\u672c\u53f7\u4e3a v%s\uff0c\u8bf7\u5347\u7ea7\u5230 v%s \u53ca\u4ee5\u4e0a\u7684\u7248\u672c\u3002\u8be6\u60c5\u8bf7\u53c2\u8003\uff1ahttps://github.com/sensorsdata/sa-sdk-android-plugin2", "3.5.3", minPluginVersion);
                Logger.error(errMessage);
                throw new Error(errMessage);
            }
        } else if (this.mClassNameAnalytics.isSensorsDataVersion) {
            String relatedOtherSDK;
            String message;
            if ("SDK_VERSION".equals(this.mName)) {
                String version = (String)this.mValue;
                String message2 = this.mSdkVersionHelper.getMessageBySDKCurrentVersion(this.mClassName, version);
                if (!TextUtil.isEmpty(message2)) {
                    throw new Error(message2);
                }
            } else if ("DEPENDENT_SDK_VERSIONS".equals(this.mName) && !TextUtil.isEmpty(message = this.mSdkVersionHelper.getMessageBySDKRelyVersion(this.mClassName, relatedOtherSDK = (String)this.mValue))) {
                throw new Error(message);
            }
        }
        super.visitEnd();
    }
}

