/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.js;

import com.sensorsdata.analytics.android.plugin.SensorsAnalyticsTransformHelper;
import com.sensorsdata.analytics.android.plugin.SensorsAnalyticsUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class AddJSAnnotationVisitor
extends AdviceAdapter {
    private final SensorsAnalyticsTransformHelper mTransformHelper;
    boolean shouldAddUCJS = false;
    boolean shouldAddXWalkJS = false;

    public AddJSAnnotationVisitor(MethodVisitor mv, int access, String name, String desc, SensorsAnalyticsTransformHelper transformHelper) {
        super(SensorsAnalyticsUtil.ASM_VERSION, mv, access, name, desc);
        this.mTransformHelper = transformHelper;
    }

    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        if (s.equals("Landroid/webkit/JavascriptInterface;")) {
            this.shouldAddUCJS = this.mTransformHelper.getExtension().addUCJavaScriptInterface;
            this.shouldAddXWalkJS = this.mTransformHelper.getExtension().addXWalkJavaScriptInterface;
        }
        return super.visitAnnotation(s, b);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.shouldAddUCJS) {
            this.visitAnnotation("Lcom/uc/webview/export/JavascriptInterface;", true);
        }
        if (this.shouldAddXWalkJS) {
            this.visitAnnotation("Lorg/xwalk/core/JavascriptInterface;", true);
        }
    }
}

