/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.configs;

import com.sensorsdata.analytics.android.plugin.configs.SensorsAnalyticsSDKExtension;
import com.sensorsdata.analytics.android.plugin.configs.SensorsAnalyticsSDKHookConfig;
import com.sensorsdata.analytics.android.plugin.viewclick.SensorsAnalyticsMethodCell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassVisitor;

public class SAConfigHookHelper {
    public static HashMap<String, HashMap<String, List<SensorsAnalyticsMethodCell>>> mConfigCells = new HashMap();
    public static ArrayList<SensorsAnalyticsMethodCell> sClassInConfigCells = new ArrayList();
    private final ArrayList<SensorsAnalyticsMethodCell> mHookMethodCells = new ArrayList();

    public static void initSDKConfigCells(SensorsAnalyticsSDKExtension sdkExtension) {
        HashMap<String, List<SensorsAnalyticsMethodCell>> cells;
        mConfigCells.clear();
        if (sdkExtension.disableAndroidID) {
            cells = new HashMap<String, List<SensorsAnalyticsMethodCell>>();
            cells.put("com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils", SensorsAnalyticsSDKHookConfig.disableAndroidID());
            mConfigCells.put("disableAndroidID", cells);
        }
        if (sdkExtension.disableCarrier) {
            cells = new HashMap();
            cells.put("com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils", SensorsAnalyticsSDKHookConfig.disableCarrier());
            mConfigCells.put("disableCarrier", cells);
        }
        if (sdkExtension.disableIMEI) {
            cells = new HashMap();
            cells.put("com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils", SensorsAnalyticsSDKHookConfig.disableIMEI());
            mConfigCells.put("disableIMEI", cells);
        }
        if (sdkExtension.disableMacAddress) {
            cells = new HashMap();
            cells.put("com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils", SensorsAnalyticsSDKHookConfig.disableMacAddress());
            mConfigCells.put("disableMacAddress", cells);
        }
        if (sdkExtension.disableOAID) {
            cells = new HashMap();
            cells.put("com.sensorsdata.analytics.android.sdk.advert.oaid.SAOaidHelper", SensorsAnalyticsSDKHookConfig.disableOAID());
            mConfigCells.put("disableOAID", cells);
        }
        if (sdkExtension.disableJsInterface) {
            cells = new HashMap();
            cells.put("com.sensorsdata.analytics.android.sdk.SensorsDataAPI", SensorsAnalyticsSDKHookConfig.disableJsInterface());
            mConfigCells.put("disableJsInterface", cells);
        }
        if (sdkExtension.disableLog) {
            cells = new HashMap();
            cells.put("com.sensorsdata.analytics.android.sdk.SALog", SensorsAnalyticsSDKHookConfig.disableLog());
            mConfigCells.put("disableLog", cells);
        }
    }

    public static void initConfigCellInClass(String className) {
        sClassInConfigCells.clear();
        for (HashMap<String, List<SensorsAnalyticsMethodCell>> cell : mConfigCells.values()) {
            if (!cell.containsKey(className)) continue;
            sClassInConfigCells.addAll((Collection<SensorsAnalyticsMethodCell>)cell.get(className));
        }
    }

    public boolean isConfigsMethod(String name, String desc) {
        for (SensorsAnalyticsMethodCell methodCell : sClassInConfigCells) {
            if (!methodCell.getName().equals(name) || !methodCell.getDesc().equals(desc)) continue;
            this.mHookMethodCells.add(methodCell);
            return true;
        }
        return false;
    }

    public void disableIdentifierMethod(ClassVisitor classVisitor) {
        for (SensorsAnalyticsMethodCell cell : this.mHookMethodCells) {
            if ("createGetIMEI".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createGetIMEI(classVisitor, cell);
                continue;
            }
            if ("createGetDeviceID".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createGetDeviceID(classVisitor, cell);
                continue;
            }
            if ("createGetAndroidID".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createGetAndroidID(classVisitor, cell);
                continue;
            }
            if ("createGetMacAddress".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createGetMacAddress(classVisitor, cell);
                continue;
            }
            if ("createGetCarrier".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createGetCarrier(classVisitor, cell);
                continue;
            }
            if ("createGetOAID".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createGetOAID(classVisitor, cell);
                continue;
            }
            if ("createSALogInfo".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createSALogInfo(classVisitor, cell);
                continue;
            }
            if ("createPrintStackTrack".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createPrintStackTrack(classVisitor, cell);
                continue;
            }
            if ("createShowUpWebViewFour".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createShowUpWebViewFour(classVisitor, cell);
                continue;
            }
            if ("createShowUpX5WebViewFour".equals(cell.getAgentName())) {
                SensorsAnalyticsSDKHookConfig.createShowUpX5WebViewFour(classVisitor, cell);
                continue;
            }
            if (!"createShowUpX5WebViewTwo".equals(cell.getAgentName())) continue;
            SensorsAnalyticsSDKHookConfig.createShowUpX5WebViewTwo(classVisitor, cell);
        }
    }
}

