/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAAdvertisingConfig;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.DeepLinkManager;
import com.sensorsdata.analytics.android.sdk.advert.oaid.SAOaidHelper;
import com.sensorsdata.analytics.android.sdk.advert.utils.ChannelUtils;
import com.sensorsdata.analytics.android.sdk.advert.utils.SAAdvertUtils;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentDailyDate;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import org.json.JSONObject;

public class SAAdvertMarketHelper {
    private static boolean isInteracted = false;

    public static void handleAdMarket(final Activity activity, final SAAdvertisingConfig saAdvertisingConfig, final boolean isAppInstalled) {
        try {
            if (saAdvertisingConfig != null && saAdvertisingConfig.isEnableRemarketing() && SAAdvertMarketHelper.isDailyFirst()) {
                SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Intent uriIntent = null;
                            if (!TextUtils.isEmpty((CharSequence)saAdvertisingConfig.getWakeupUrl())) {
                                uriIntent = Intent.parseUri((String)saAdvertisingConfig.getWakeupUrl(), (int)1);
                            }
                            Context context = activity.getApplicationContext();
                            JSONObject propertyJson = new JSONObject();
                            propertyJson.put("$ios_install_source", (Object)ChannelUtils.getDeviceInfo(context, SensorsDataUtils.getIdentifier((Context)context), SAOaidHelper.getOpenAdIdentifier(context), SAOaidHelper.getOpenAdIdentifierByReflection(context)));
                            propertyJson.put("$sat_awake_from_deeplink", DeepLinkManager.isDeepLink(activity.getIntent()) || DeepLinkManager.isDeepLink(uriIntent));
                            propertyJson.put("$sat_has_installed_app", isInteracted ? SAAdvertUtils.isInstallationTracked() : isAppInstalled);
                            SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName("$AppInteract").setProperties(propertyJson));
                            isInteracted = true;
                        }
                        catch (Exception e) {
                            SALog.printStackTrace((Exception)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static boolean isDailyFirst() {
        PersistentDailyDate dailyDate = PersistentLoader.getInstance().getDayDatePst();
        String currentDate = TimeUtils.formatTime((long)System.currentTimeMillis(), (String)"yyyy-MM-dd");
        if (!currentDate.equals(dailyDate.get())) {
            dailyDate.commit((Object)currentDate);
            return true;
        }
        return false;
    }
}

