/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.content.ContentProviderClient;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;

class NubiaImpl
implements IRomOAID {
    private final Context mContext;
    private static final String TAG = "SA.NubiaImpl";

    public NubiaImpl(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean isSupported() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @Override
    public String getRomOAID() {
        if (!this.isSupported()) {
            SALog.i((String)TAG, (String)"Only supports Android 10.0 and above for Nubia");
            return null;
        }
        String oaid = null;
        try {
            Uri uri = Uri.parse((String)"content://cn.nubia.identity/identity");
            ContentProviderClient client = this.mContext.getContentResolver().acquireContentProviderClient(uri);
            if (client == null) {
                return null;
            }
            Bundle bundle = client.call("getOAID", null, null);
            if (Build.VERSION.SDK_INT >= 24) {
                client.close();
            } else {
                client.release();
            }
            if (bundle == null) {
                SALog.i((String)TAG, (String)"OAID query failed: bundle is null");
                return null;
            }
            if (bundle.getInt("code", -1) == 0) {
                oaid = bundle.getString("id");
            }
            SALog.i((String)TAG, (String)("OAID query success: " + oaid));
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
        }
        return oaid;
    }
}

