/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.deeplink;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.ChannelDeepLink;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.DeepLinkProcessor;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.DeferredDeepLinkHelper;
import com.sensorsdata.analytics.android.sdk.advert.deeplink.SensorsDataDeepLink;
import com.sensorsdata.analytics.android.sdk.advert.oaid.SAOaidHelper;
import com.sensorsdata.analytics.android.sdk.advert.utils.ChannelUtils;
import com.sensorsdata.analytics.android.sdk.advert.utils.SAAdvertUtils;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.eventbus.SAEventBus;
import com.sensorsdata.analytics.android.sdk.deeplink.SADeepLinkObject;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeferredDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class DeepLinkManager {
    public static final String IS_ANALYTICS_DEEPLINK = "is_analytics_deeplink";
    private static DeepLinkProcessor mDeepLinkProcessor;
    private static SensorsDataDeepLinkCallback mDeepLinkCallback;
    private static SensorsDataDeferredDeepLinkCallback mDeferredDeepLinkCallback;
    private static boolean mEnableDeepLinkInstallSource;
    private static JSONObject mCacheProperties;
    private static boolean mIsDeepLink;

    public static boolean isDeepLink(Intent intent) {
        return Build.VERSION.SDK_INT >= 11 && intent != null && "android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null;
    }

    private static boolean isUtmDeepLink(Intent intent) {
        if (!DeepLinkManager.isDeepLink(intent)) {
            return false;
        }
        Uri uri = intent.getData();
        if (uri.isOpaque()) {
            SALog.d((String)"ChannelDeepLink", (String)(uri + " isOpaque"));
            return false;
        }
        Set parameterNames = uri.getQueryParameterNames();
        if (parameterNames != null && parameterNames.size() > 0) {
            return ChannelUtils.hasLinkUtmProperties(parameterNames);
        }
        return false;
    }

    private static boolean isSensorsDataDeepLink(Intent intent, String serverHost, String customADChannelUrl) {
        if (!DeepLinkManager.isDeepLink(intent)) {
            return false;
        }
        Uri uri = intent.getData();
        List paths = uri.getPathSegments();
        if (paths != null && !paths.isEmpty()) {
            String host = uri.getHost();
            if (((String)paths.get(0)).equals("slink")) {
                return !TextUtils.isEmpty((CharSequence)host) && !TextUtils.isEmpty((CharSequence)customADChannelUrl) && (NetworkUtils.compareMainDomain((String)customADChannelUrl, (String)host) || host.equals("sensorsdata"));
            }
            if (((String)paths.get(0)).equals("sd") && !TextUtils.isEmpty((CharSequence)serverHost)) {
                return !TextUtils.isEmpty((CharSequence)host) && (host.equals(serverHost) || host.equals("sensorsdata"));
            }
        }
        return false;
    }

    private static DeepLinkProcessor createDeepLink(Intent intent, String serverUrl, String customADChannelUrl) {
        if (intent == null) {
            return null;
        }
        if (DeepLinkManager.isSensorsDataDeepLink(intent, new ServerUrl(serverUrl).getHost(), NetworkUtils.getHost((String)customADChannelUrl))) {
            return new SensorsDataDeepLink(intent, serverUrl, customADChannelUrl);
        }
        if (DeepLinkManager.isUtmDeepLink(intent)) {
            return new ChannelDeepLink(intent);
        }
        return null;
    }

    private static void trackDeepLinkLaunchEvent(final Context context, DeepLinkProcessor deepLink) {
        final JSONObject properties = new JSONObject();
        final boolean isDeepLinkInstallSource = deepLink instanceof SensorsDataDeepLink && mEnableDeepLinkInstallSource;
        try {
            properties.put("$deeplink_url", (Object)deepLink.getDeepLinkUrl());
            properties.put("$time", (Object)new Date(System.currentTimeMillis()));
            properties.put("$sat_has_installed_app", SAAdvertUtils.isInstallationTracked());
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        JSONUtils.mergeJSONObject((JSONObject)ChannelUtils.getLatestUtmProperties(), (JSONObject)properties);
        JSONUtils.mergeJSONObject((JSONObject)ChannelUtils.getUtmProperties(), (JSONObject)properties);
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                if (isDeepLinkInstallSource) {
                    try {
                        properties.put("$ios_install_source", (Object)ChannelUtils.getDeviceInfo(context, SensorsDataUtils.getIdentifier((Context)context), SAOaidHelper.getOpenAdIdentifier(context), SAOaidHelper.getOpenAdIdentifierByReflection(context)));
                    }
                    catch (JSONException e) {
                        SALog.printStackTrace((Exception)((Object)e));
                    }
                }
                SACoreHelper.getInstance().trackEvent(new InputData().setEventType(EventType.TRACK).setEventName("$AppDeeplinkLaunch").setProperties(properties));
            }
        });
    }

    private static boolean isParsedDeepLink(Activity activity) {
        try {
            Intent intent;
            if (!(SensorsDataUtils.isUniApp() && ChannelUtils.isDeepLinkBlackList(activity) || (intent = activity.getIntent()) == null || intent.getData() == null)) {
                return intent.getBooleanExtra(IS_ANALYTICS_DEEPLINK, false);
            }
        }
        catch (Throwable ex) {
            SALog.i((String)"SA.Advert", (String)ex.getMessage());
        }
        return false;
    }

    public static void parseDeepLink(Activity activity, final boolean isSaveDeepLinkInfo) {
        try {
            if (!DeepLinkManager.isDeepLink(activity.getIntent()) || DeepLinkManager.isParsedDeepLink(activity)) {
                return;
            }
            Intent intent = activity.getIntent();
            mDeepLinkProcessor = DeepLinkManager.createDeepLink(intent, SensorsDataAPI.sharedInstance().getServerUrl(), SensorsDataAPI.getConfigOptions().getCustomADChannelUrl());
            if (mDeepLinkProcessor == null) {
                return;
            }
            ChannelUtils.clearUtm();
            mIsDeepLink = true;
            mDeepLinkProcessor.setDeepLinkParseFinishCallback(new OnDeepLinkParseFinishCallback(){

                @Override
                public void onFinish(DeepLinkType deepLinkStatus, String params, JSONObject customParams, boolean success, long duration) {
                    if (isSaveDeepLinkInfo) {
                        ChannelUtils.saveDeepLinkInfo();
                    }
                    SAEventBus.getInstance().post("eventbus_deeplink_launch", (Object)ChannelUtils.getLatestUtmProperties());
                    if (deepLinkStatus == DeepLinkType.SENSORSDATA) {
                        try {
                            if (null != mDeferredDeepLinkCallback) {
                                mDeferredDeepLinkCallback.onReceive(new SADeepLinkObject(params, customParams, "", success, duration));
                            } else if (null != mDeepLinkCallback) {
                                mDeepLinkCallback.onReceive(params, success, duration);
                            }
                        }
                        catch (Exception e) {
                            SALog.printStackTrace((Exception)e);
                        }
                    }
                }
            });
            mDeepLinkProcessor.parseDeepLink(intent);
            DeepLinkManager.cacheProperties();
            DeepLinkManager.trackDeepLinkLaunchEvent(activity.getApplicationContext(), mDeepLinkProcessor);
            activity.getIntent().putExtra(IS_ANALYTICS_DEEPLINK, true);
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    public static void mergeDeepLinkProperty(JSONObject properties) {
        try {
            if (mDeepLinkProcessor != null) {
                mDeepLinkProcessor.mergeDeepLinkProperty(properties);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
        }
    }

    public static void resetDeepLinkProcessor() {
        mDeepLinkProcessor = null;
    }

    public static void setDeepLinkCallback(SensorsDataDeepLinkCallback callback) {
        mDeepLinkCallback = callback;
    }

    public static void setDeferredDeepLinkCallback(SensorsDataDeferredDeepLinkCallback callback) {
        mDeferredDeepLinkCallback = callback;
    }

    public static void enableDeepLinkInstallSource(boolean enable) {
        mEnableDeepLinkInstallSource = enable;
    }

    private static void cacheProperties() {
        if (mCacheProperties == null) {
            mCacheProperties = new JSONObject();
        }
        DeepLinkManager.mergeDeepLinkProperty(mCacheProperties);
    }

    public static void mergeCacheProperties(JSONObject properties) {
        if (properties == null || mCacheProperties == null || mCacheProperties.length() == 0) {
            return;
        }
        JSONUtils.mergeJSONObject((JSONObject)mCacheProperties, (JSONObject)properties);
        mCacheProperties = null;
    }

    public static void requestDeferredDeepLink(Context context, JSONObject params, String androidId, String oaid, JSONObject presetProperties, String url, boolean isSaveDeepLinkInfo) {
        if (mIsDeepLink) {
            return;
        }
        try {
            String ids;
            JSONObject jsonObject = new JSONObject();
            String reflectionOAID = SAOaidHelper.getOpenAdIdentifierByReflection(context);
            if (params != null) {
                if (params.has("$oaid")) {
                    oaid = params.optString("$oaid");
                    reflectionOAID = "";
                    params.remove("$oaid");
                }
                ids = ChannelUtils.getDeviceInfo(context, androidId, oaid, reflectionOAID);
                if (params.has("$gaid")) {
                    String gaid = params.optString("$gaid");
                    ids = String.format("%s##gaid=%s", ids, gaid);
                    params.remove("$gaid");
                }
                if (params.has("$user_agent")) {
                    jsonObject.put("ua", (Object)params.optString("$user_agent"));
                    params.remove("$user_agent");
                }
                jsonObject.put("app_parameter", (Object)params.toString());
            } else {
                ids = ChannelUtils.getDeviceInfo(context, androidId, oaid, reflectionOAID);
            }
            jsonObject.put("ids", (Object)Base64Coder.encodeString((String)ids));
            jsonObject.put("model", (Object)presetProperties.optString("$model"));
            jsonObject.put("os", (Object)presetProperties.optString("$os"));
            jsonObject.put("os_version", (Object)presetProperties.optString("$os_version"));
            jsonObject.put("network", (Object)presetProperties.optString("$network_type"));
            jsonObject.put("app_id", (Object)presetProperties.optString("$app_id"));
            jsonObject.put("app_version", (Object)presetProperties.optString("$app_version"));
            jsonObject.put("timestamp", (Object)String.valueOf(System.currentTimeMillis()));
            jsonObject.put("project", (Object)new ServerUrl(SensorsDataAPI.sharedInstance().getServerUrl()).getProject());
            DeferredDeepLinkHelper.request(jsonObject, mDeferredDeepLinkCallback, url, isSaveDeepLinkInfo);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    static {
        mEnableDeepLinkInstallSource = false;
        mIsDeepLink = false;
    }

    public static interface OnDeepLinkParseFinishCallback {
        public void onFinish(DeepLinkType var1, String var2, JSONObject var3, boolean var4, long var5);
    }

    public static enum DeepLinkType {
        CHANNEL,
        SENSORSDATA;

    }
}

