/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.advert.oaid.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.advert.oaid.IRomOAID;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class XiaomiImpl
implements IRomOAID {
    private final Context mContext;
    private Class<?> mIdProviderClass;
    private Object mIdProviderImpl;
    private static final String TAG = "SA.OAIDFactory";

    @SuppressLint(value={"PrivateApi"})
    public XiaomiImpl(Context context) {
        this.mContext = context;
        try {
            this.mIdProviderClass = Class.forName("com.android.id.impl.IdProviderImpl");
            this.mIdProviderImpl = this.mIdProviderClass.newInstance();
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
        }
    }

    @Override
    public boolean isSupported() {
        return this.mIdProviderImpl != null;
    }

    @Override
    public String getRomOAID() {
        if (this.mIdProviderClass == null || this.mIdProviderImpl == null) {
            return null;
        }
        String oaid = null;
        try {
            oaid = this.getOAID();
        }
        catch (Throwable th) {
            SALog.i((String)TAG, (Throwable)th);
        }
        return oaid;
    }

    private String getOAID() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.mIdProviderClass.getMethod("getOAID", Context.class);
        return (String)method.invoke(this.mIdProviderImpl, this.mContext);
    }
}

