/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.thirdparty.impl;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.listener.SAFunctionListener;
import com.sensorsdata.analytics.android.thirdparty.listener.ISAThirdPartyShare;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.json.JSONObject;

public class SAAdjustImpl
implements ISAThirdPartyShare {
    private boolean isSupport = true;
    private String[] ADJUST_PARAMS = new String[]{"addGlobalCallbackParameter", "addSessionCallbackParameter"};

    public SAAdjustImpl() {
        this.registerListener();
    }

    private void registerListener() {
        SensorsDataAPI.sharedInstance().addFunctionListener(new SAFunctionListener(){

            public void call(String function, JSONObject args) {
                switch (function) {
                    case "login": 
                    case "logout": 
                    case "resetAnonymousId": 
                    case "identify": {
                        SAAdjustImpl.this.share(null);
                    }
                }
            }
        });
    }

    @Override
    public void share(Map<String, Object> data) {
        if (!this.isSupport) {
            return;
        }
        SALog.d((String)"SA.ThirdParty", (String)"Adjust start addSessionCallbackParameter");
        try {
            Class<?> mAdjustClazz = Class.forName("com.adjust.sdk.Adjust");
            Method addSessionCallbackParameterMethod = this.getParameterMethod(mAdjustClazz);
            if (addSessionCallbackParameterMethod == null) {
                SALog.d((String)"SA.ThirdParty", (String)"Adjust addCallbackParameter is null");
                return;
            }
            if (data != null && !data.isEmpty()) {
                for (String key : data.keySet()) {
                    Object value = data.get(key);
                    if (!(value instanceof String)) continue;
                    addSessionCallbackParameterMethod.invoke(mAdjustClazz, key, value);
                }
            }
            addSessionCallbackParameterMethod.invoke(mAdjustClazz, "sensors_distinct_id", SensorsDataAPI.sharedInstance().getDistinctId());
            addSessionCallbackParameterMethod.invoke(mAdjustClazz, "sensors_is_login", Boolean.toString(!TextUtils.isEmpty((CharSequence)SensorsDataAPI.sharedInstance().getLoginId())));
            SALog.d((String)"SA.ThirdParty", (String)"Adjust start addSessionCallbackParameter succeed");
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            SALog.d((String)"SA.ThirdParty", (String)("Adjust reflection exception:" + e.getMessage()));
            this.isSupport = false;
        }
        catch (Exception e) {
            SALog.d((String)"SA.ThirdParty", (String)("Adjust start addSessionCallbackParameter exception:" + e.getMessage()));
        }
    }

    private Method getParameterMethod(Class<?> adjustClazz) {
        for (String method : this.ADJUST_PARAMS) {
            Method methodParam = null;
            try {
                methodParam = adjustClazz.getMethod(method, String.class, String.class);
            }
            catch (Exception e) {
                SALog.d((String)"SA.ThirdParty", (String)("Adjust addSessionCallbackParameter exception:" + e.getMessage()));
            }
            if (methodParam == null) continue;
            return methodParam;
        }
        return null;
    }
}

