/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.sdk.scanner.ScanEventType;
import com.sensorberg.utils.Objects;

public class ScanEvent
implements Parcelable {
    public static final Parcelable.Creator<ScanEvent> CREATOR = new Parcelable.Creator<ScanEvent>(){

        public ScanEvent createFromParcel(Parcel in) {
            return new ScanEvent(in);
        }

        public ScanEvent[] newArray(int size) {
            return new ScanEvent[size];
        }
    };
    private String hardwareAdress;
    private int initialRssi;
    private int calRssi;
    private final BeaconId beaconId;
    private final long eventTime;
    private final String pairingId;
    private final boolean entry;
    private final String geohash;

    protected ScanEvent(BeaconId beaconId, long eventTime, boolean entry, String geohash, String pairingId) {
        this.beaconId = beaconId;
        this.eventTime = eventTime;
        this.entry = entry;
        this.geohash = geohash;
        this.pairingId = pairingId;
    }

    private ScanEvent(Parcel source) {
        this.beaconId = (BeaconId)source.readParcelable(BeaconId.class.getClassLoader());
        this.eventTime = source.readLong();
        this.entry = source.readInt() == 1;
        this.hardwareAdress = source.readString();
        this.initialRssi = source.readInt();
        this.calRssi = source.readInt();
        this.geohash = source.readString();
        this.pairingId = source.readString();
    }

    public ScanEvent(BeaconId beaconId, long now, boolean entry, String address, int rssi, int calRssi, String geohash, String pairingId) {
        this(beaconId, now, entry, geohash, pairingId);
        this.hardwareAdress = address;
        this.initialRssi = rssi;
        this.calRssi = calRssi;
    }

    public int getTrigger() {
        return this.isEntry() ? ScanEventType.ENTRY.getMask() : ScanEventType.EXIT.getMask();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel destination, int flags) {
        destination.writeParcelable((Parcelable)this.beaconId, flags);
        destination.writeLong(this.eventTime);
        destination.writeInt(this.entry ? 1 : 0);
        destination.writeString(this.hardwareAdress);
        destination.writeInt(this.initialRssi);
        destination.writeInt(this.calRssi);
        destination.writeString(this.geohash);
        destination.writeString(this.pairingId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScanEvent other = (ScanEvent)object;
        return Objects.equals(this.beaconId, other.beaconId) && this.entry == other.entry && Objects.equals(this.geohash, other.geohash) && Objects.equals(this.pairingId, other.pairingId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beaconId == null ? 0 : this.beaconId.hashCode());
        result = 31 * result + (this.entry ? 1 : 0);
        result = 31 * result + (this.geohash == null ? 0 : this.geohash.hashCode());
        result = 31 * result + (this.pairingId == null ? 0 : this.pairingId.hashCode());
        return result;
    }

    public boolean isEntry() {
        return this.entry;
    }

    public String toString() {
        return "ScanEvent(hardwareAdress=" + this.getHardwareAdress() + ", initialRssi=" + this.getInitialRssi() + ", calRssi=" + this.getCalRssi() + ", beaconId=" + this.getBeaconId() + ", eventTime=" + this.getEventTime() + ", pairingId=" + this.getPairingId() + ", entry=" + this.isEntry() + ", geohash=" + this.getGeohash() + ")";
    }

    public String getHardwareAdress() {
        return this.hardwareAdress;
    }

    public int getInitialRssi() {
        return this.initialRssi;
    }

    public int getCalRssi() {
        return this.calRssi;
    }

    public BeaconId getBeaconId() {
        return this.beaconId;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public String getPairingId() {
        return this.pairingId;
    }

    public String getGeohash() {
        return this.geohash;
    }

    public static class Builder {
        private BeaconId beaconId;
        private long eventTime;
        private boolean entry;
        private String geohash;
        private String pairingId;

        public Builder withBeaconId(BeaconId beaconId) {
            this.beaconId = beaconId;
            return this;
        }

        public Builder withEventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public Builder withEntry(boolean entry) {
            this.entry = entry;
            return this;
        }

        public Builder withGeohash(String geohash) {
            this.geohash = geohash;
            return this;
        }

        public Builder withPairingId(String pairingId) {
            this.pairingId = pairingId;
            return this;
        }

        public ScanEvent build() {
            return new ScanEvent(this.beaconId, this.eventTime, this.entry, this.geohash, this.pairingId);
        }
    }
}

