/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.location;

import android.os.Parcel;
import android.os.Parcelable;
import ch.hsr.geohash.GeoHash;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.sensorberg.sdk.Logger;
import com.sensorberg.utils.Objects;
import java.util.ArrayList;
import java.util.List;

public class GeofenceData
implements Parcelable {
    private final String fence;
    private final String geohash;
    private final double latitude;
    private final double longitude;
    private final int radius;
    public static final Parcelable.Creator<GeofenceData> CREATOR = new Parcelable.Creator<GeofenceData>(){

        public GeofenceData createFromParcel(Parcel in) {
            return new GeofenceData(in);
        }

        public GeofenceData[] newArray(int size) {
            return new GeofenceData[size];
        }
    };

    protected GeofenceData(String fence) {
        this.fence = fence;
        String problem = GeofenceData.check(fence);
        if (problem != null) {
            throw new IllegalArgumentException(problem);
        }
        this.radius = Integer.valueOf(fence.substring(8, 14));
        if (this.radius == 0) {
            throw new IllegalArgumentException("Geofence radius can't be 0");
        }
        String start = fence.substring(0, 8);
        try {
            GeoHash hash = GeoHash.fromGeohashString((String)start);
            this.geohash = hash.toBase32();
            this.latitude = hash.getPoint().getLatitude();
            this.longitude = hash.getPoint().getLongitude();
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("Invalid geofence geohash: " + start);
        }
    }

    protected GeofenceData(Parcel in) {
        this.fence = in.readString();
        this.geohash = in.readString();
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.radius = in.readInt();
    }

    private static String check(String geofenceId) {
        if (geofenceId == null) {
            return "Geofence string can't be null";
        }
        if (geofenceId.length() != 14) {
            return "Geofence string has to be exactly 14 chars";
        }
        if (!geofenceId.substring(8, 14).matches("^[0-9]{6}$")) {
            return "Geofence last 6 chars have to be digits";
        }
        return null;
    }

    protected static List<GeofenceData> from(GeofencingEvent event) {
        String problem = GeofenceData.check(event);
        if (problem != null) {
            throw new IllegalArgumentException(problem);
        }
        ArrayList<GeofenceData> result = new ArrayList<GeofenceData>();
        for (Geofence geofence : event.getTriggeringGeofences()) {
            try {
                result.add(new GeofenceData(geofence.getRequestId()));
            }
            catch (IllegalArgumentException ex) {
                Logger.log.logError(ex.getMessage());
            }
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("GeofencingEvent has no triggering geofences");
        }
        return result;
    }

    private static String check(GeofencingEvent event) {
        if (event == null) {
            return "GeofencingEvent is null";
        }
        if (event.hasError()) {
            return "GeofencingEvent has error: " + event.getErrorCode();
        }
        if (event.getTriggeringGeofences() == null) {
            return "GeofencingEvent has no triggering geofences";
        }
        if (event.getTriggeringGeofences().isEmpty()) {
            return "GeofencingEvent has empty list of triggering geofences";
        }
        int transition = event.getGeofenceTransition();
        if (transition != 1 && transition != 2) {
            return "GeofencingEvent has invalid transition: " + transition;
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.fence);
        parcel.writeString(this.geohash);
        parcel.writeDouble(this.latitude);
        parcel.writeDouble(this.longitude);
        parcel.writeInt(this.radius);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GeofenceData otherData = (GeofenceData)other;
        return Objects.equals(otherData.getFence(), this.fence);
    }

    public int hashCode() {
        return this.fence.hashCode();
    }

    public String toString() {
        return this.fence;
    }

    public String getFence() {
        return this.fence;
    }

    public String getGeohash() {
        return this.geohash;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getRadius() {
        return this.radius;
    }
}

