/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.os.Bundle;
import android.os.Parcelable;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.FileManager;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import com.sensorberg.sdk.scanner.AbstractScanner;
import com.sensorberg.sdk.settings.SettingsManager;

public class Scanner
extends AbstractScanner {
    public static final String SCANNER_EVENT = "com.sensorberg.sdk.scanner.SDKScanner.SCANNER_EVENT";

    public Scanner(SettingsManager stgMgr, boolean shouldRestoreBeaconStates, Clock clock, FileManager fileManager, ServiceScheduler scheduler, HandlerManager handlerManager, BluetoothPlatform bluetoothPlatform) {
        super(stgMgr, shouldRestoreBeaconStates, clock, fileManager, scheduler, handlerManager, bluetoothPlatform);
        SensorbergSdk.getComponent().inject(this);
    }

    @Override
    protected void clearScheduledExecutions() {
        this.getServiceScheduler().cancelServiceMessage(this.indexFor(4));
        this.getServiceScheduler().cancelServiceMessage(this.indexFor(5));
    }

    @Override
    protected void scheduleExecution(int type, long delay) {
        Bundle bundle = new Bundle();
        bundle.putInt(SCANNER_EVENT, type);
        this.getServiceScheduler().postToServiceDelayed(delay, 9, (Parcelable)bundle, false, this.indexFor(type));
    }

    private int indexFor(int type) {
        return -1000 - type;
    }

    public void handlePlatformMessage(Bundle what) {
        int messageId = what.getInt(SCANNER_EVENT, -1);
        if (messageId == 5) {
            this.getRunLoop().sendMessage(5);
        } else if (messageId == 4) {
            this.getRunLoop().sendMessage(4);
        } else {
            Logger.log.logError("unknown scheduled execution:" + messageId);
        }
    }
}

