/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.util.Pair;
import com.sensorberg.sdk.model.BeaconId;

public final class ScanHelper {
    private static final byte[] ADVERTISEMENT_HEADER = new byte[]{-1, 76, 0, 2};
    private static final int ADVERTISEMENT_HEADER_LENGTH = ADVERTISEMENT_HEADER.length;
    private static final int MINIMUM_BEACON_PACKET_LENGTH = 26;

    private ScanHelper() {
    }

    public static Pair<BeaconId, Integer> getBeaconID(byte[] advertisement) {
        try {
            byte packetLength;
            int offset = 0;
            do {
                if ((packetLength = advertisement[offset]) < 26 || !ScanHelper.matchesBeaconHeader(advertisement, ++offset)) continue;
                return ScanHelper.toBeaconData(advertisement, offset + ADVERTISEMENT_HEADER_LENGTH + 1);
            } while (packetLength > 0 && (offset += packetLength) < advertisement.length);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private static Pair<BeaconId, Integer> toBeaconData(byte[] advertisement, int offset) {
        byte[] beaconIdBytes = new byte[20];
        System.arraycopy(advertisement, offset, beaconIdBytes, 0, 20);
        BeaconId beaconId = new BeaconId(beaconIdBytes);
        byte calibratedTXpower = advertisement[offset + 20];
        return Pair.create((Object)beaconId, (Object)calibratedTXpower);
    }

    private static boolean matchesBeaconHeader(byte[] advertisement, int offset) {
        for (int i = 0; i < ADVERTISEMENT_HEADER.length; ++i) {
            if (advertisement[i + offset] == ADVERTISEMENT_HEADER[i]) continue;
            return false;
        }
        return true;
    }
}

