/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.resolver;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.utils.Objects;
import java.util.Date;

public class BeaconEvent
implements Parcelable {
    public static final Parcelable.Creator<BeaconEvent> CREATOR = new Parcelable.Creator<BeaconEvent>(){

        public BeaconEvent createFromParcel(Parcel in) {
            return new BeaconEvent(in);
        }

        public BeaconEvent[] newArray(int size) {
            return new BeaconEvent[size];
        }
    };
    private final Action action;
    private final long suppressionTimeMillis;
    private final boolean sendOnlyOnce;
    private final boolean reportImmediately;
    private final Date deliverAt;
    private long resolvedTime;
    private int trigger;
    private BeaconId beaconId;
    private long presentationTime;

    private BeaconEvent(Action action, long resolvedTime, long presentationTime, long suppressionTime, boolean sendOnlyOnce, Date deliverAt, int trigger, BeaconId beaconId, boolean reportImmediately) {
        this.action = action;
        this.resolvedTime = resolvedTime;
        this.presentationTime = presentationTime;
        this.suppressionTimeMillis = suppressionTime;
        this.sendOnlyOnce = sendOnlyOnce;
        this.deliverAt = deliverAt;
        this.trigger = trigger;
        this.beaconId = beaconId;
        this.reportImmediately = reportImmediately;
    }

    private BeaconEvent(Parcel source) {
        this.action = (Action)source.readParcelable(Action.class.getClassLoader());
        this.resolvedTime = source.readLong();
        this.suppressionTimeMillis = source.readLong();
        this.sendOnlyOnce = source.readInt() == 1;
        boolean hasDeliverAt = source.readInt() == 1;
        this.deliverAt = hasDeliverAt ? new Date(source.readLong()) : null;
        this.trigger = source.readInt();
        this.beaconId = (BeaconId)source.readParcelable(BeaconId.class.getClassLoader());
        this.reportImmediately = source.readInt() == 1;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel destination, int flags) {
        destination.writeParcelable((Parcelable)this.action, flags);
        destination.writeLong(this.resolvedTime);
        destination.writeLong(this.suppressionTimeMillis);
        destination.writeInt(this.sendOnlyOnce ? 1 : 0);
        if (this.deliverAt != null) {
            destination.writeInt(1);
            destination.writeLong(this.deliverAt.getTime());
        } else {
            destination.writeInt(0);
        }
        destination.writeInt(this.trigger);
        destination.writeParcelable((Parcelable)this.beaconId, flags);
        destination.writeInt(this.reportImmediately ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconEvent that = (BeaconEvent)o;
        return Objects.equals(this.action, that.action);
    }

    public int hashCode() {
        return this.action != null ? this.action.hashCode() : 0;
    }

    public String toString() {
        return "BeaconEvent(action=" + this.getAction() + ", suppressionTimeMillis=" + this.getSuppressionTimeMillis() + ", sendOnlyOnce=" + this.isSendOnlyOnce() + ", reportImmediately=" + this.isReportImmediately() + ", deliverAt=" + this.getDeliverAt() + ", resolvedTime=" + this.getResolvedTime() + ", trigger=" + this.getTrigger() + ", beaconId=" + this.getBeaconId() + ", presentationTime=" + this.getPresentationTime() + ")";
    }

    public Action getAction() {
        return this.action;
    }

    public long getSuppressionTimeMillis() {
        return this.suppressionTimeMillis;
    }

    public boolean isSendOnlyOnce() {
        return this.sendOnlyOnce;
    }

    public boolean isReportImmediately() {
        return this.reportImmediately;
    }

    public Date getDeliverAt() {
        return this.deliverAt;
    }

    public long getResolvedTime() {
        return this.resolvedTime;
    }

    public void setResolvedTime(long resolvedTime) {
        this.resolvedTime = resolvedTime;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public BeaconId getBeaconId() {
        return this.beaconId;
    }

    public void setBeaconId(BeaconId beaconId) {
        this.beaconId = beaconId;
    }

    public long getPresentationTime() {
        return this.presentationTime;
    }

    public void setPresentationTime(long presentationTime) {
        this.presentationTime = presentationTime;
    }

    public static class Builder {
        private Action action;
        private long resolvedTime;
        private long presentationTime;
        private long suppressionTime;
        private boolean sendOnlyOnce;
        private Date deliverAt;
        private int trigger;
        private BeaconId beaconId;
        private boolean reportImmediately;

        public Builder withAction(Action action) {
            this.action = action;
            return this;
        }

        public Builder withResolvedTime(long resolvedTime) {
            this.resolvedTime = resolvedTime;
            return this;
        }

        public Builder withSuppressionTime(long suppressionTime) {
            this.suppressionTime = suppressionTime;
            return this;
        }

        public Builder withPresentationTime(long presentationTime) {
            this.presentationTime = presentationTime;
            return this;
        }

        public Builder withBeaconId(BeaconId beaconId) {
            this.beaconId = beaconId;
            return this;
        }

        public Builder withSendOnlyOnce(boolean sentOnlyOnce) {
            this.sendOnlyOnce = sentOnlyOnce;
            return this;
        }

        public Builder withDeliverAtDate(Date deliverAt) {
            if (deliverAt != null) {
                this.sendOnlyOnce = true;
                this.deliverAt = deliverAt;
                this.suppressionTime = 0L;
            }
            return this;
        }

        public Builder withTrigger(int trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder withReportImmediately(boolean reportImmediately) {
            this.reportImmediately = reportImmediately;
            return this;
        }

        public BeaconEvent build() {
            return new BeaconEvent(this.action, this.resolvedTime, this.presentationTime, this.suppressionTime, this.sendOnlyOnce, this.deliverAt, this.trigger, this.beaconId, this.reportImmediately);
        }

        public String toString() {
            return "BeaconEvent.Builder(action=" + this.action + ", resolvedTime=" + this.resolvedTime + ", presentationTime=" + this.presentationTime + ", suppressionTime=" + this.suppressionTime + ", sendOnlyOnce=" + this.sendOnlyOnce + ", deliverAt=" + this.deliverAt + ", trigger=" + this.trigger + ", beaconId=" + this.beaconId + ", reportImmediately=" + this.reportImmediately + ")";
        }
    }
}

