/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import com.sensorberg.sdk.internal.interfaces.Platform;

@TargetApi(value=14)
public class BackgroundDetector
implements Application.ActivityLifecycleCallbacks {
    private final Runnable FOREGROUND = new Runnable(){

        @Override
        public void run() {
            if (!BackgroundDetector.this.appForeGroundState && BackgroundDetector.this.isInForeground) {
                BackgroundDetector.this.appForeGroundState = true;
                BackgroundDetector.this.foregroundStateListener.hostApplicationInForeground();
            }
        }
    };
    private final Runnable BACKGROUND = new Runnable(){

        @Override
        public void run() {
            if (!BackgroundDetector.this.isInForeground) {
                BackgroundDetector.this.appForeGroundState = false;
                BackgroundDetector.this.foregroundStateListener.hostApplicationInBackground();
            }
        }
    };
    private final Handler handler;
    private boolean isInForeground;
    private boolean appForeGroundState = this.isInForeground = false;
    private Platform.ForegroundStateListener foregroundStateListener = Platform.ForegroundStateListener.NONE;

    public BackgroundDetector(Platform.ForegroundStateListener foregroundStateListener) {
        this.handler = new Handler();
        this.foregroundStateListener = foregroundStateListener;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.handler.removeCallbacksAndMessages(null);
        this.isInForeground = true;
        this.handler.postDelayed(this.FOREGROUND, 500L);
    }

    public void onActivityPaused(Activity activity) {
        this.handler.removeCallbacksAndMessages(null);
        this.isInForeground = false;
        this.handler.postDelayed(this.BACKGROUND, 500L);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

