/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Only one of the two filter options (contactFilter or customContactFilter) can be passed in the request. Set the filter for the contacts to be exported.")
public class RequestContactExportCustomContactFilter {
    @SerializedName(value="actionForContacts")
    private ActionForContactsEnum actionForContacts = null;
    @SerializedName(value="actionForEmailCampaigns")
    private ActionForEmailCampaignsEnum actionForEmailCampaigns = null;
    @SerializedName(value="actionForSmsCampaigns")
    private ActionForSmsCampaignsEnum actionForSmsCampaigns = null;
    @SerializedName(value="listId")
    private Long listId = null;
    @SerializedName(value="emailCampaignId")
    private Long emailCampaignId = null;
    @SerializedName(value="smsCampaignId")
    private Long smsCampaignId = null;

    public RequestContactExportCustomContactFilter actionForContacts(ActionForContactsEnum actionForContacts) {
        this.actionForContacts = actionForContacts;
        return this;
    }

    @ApiModelProperty(value="Mandatory if neither actionForEmailCampaigns nor actionForSmsCampaigns is passed. This will export the contacts on the basis of provided action applied on contacts as per the list id. * allContacts - Fetch the list of all contacts for a particular list. * subscribed & unsubscribed - Fetch the list of subscribed / unsubscribed (blacklisted via any means) contacts for a particular list. * unsubscribedPerList - Fetch the list of contacts that are unsubscribed from a particular list only. ")
    public ActionForContactsEnum getActionForContacts() {
        return this.actionForContacts;
    }

    public void setActionForContacts(ActionForContactsEnum actionForContacts) {
        this.actionForContacts = actionForContacts;
    }

    public RequestContactExportCustomContactFilter actionForEmailCampaigns(ActionForEmailCampaignsEnum actionForEmailCampaigns) {
        this.actionForEmailCampaigns = actionForEmailCampaigns;
        return this;
    }

    @ApiModelProperty(value="Mandatory if neither actionForContacts nor actionForSmsCampaigns is passed. This will export the contacts on the basis of provided action applied on email campaigns. * openers & nonOpeners - emailCampaignId is mandatory. Fetch the list of readers / non-readers for a particular email campaign. * clickers & nonClickers - emailCampaignId is mandatory. Fetch the list of clickers / non-clickers for a particular email campaign. * unsubscribed - emailCampaignId is mandatory. Fetch the list of all unsubscribed (blacklisted via any means) contacts for a particular email campaign. * hardBounces & softBounces - emailCampaignId is optional. Fetch the list of hard bounces / soft bounces for a particular / all email campaign(s). ")
    public ActionForEmailCampaignsEnum getActionForEmailCampaigns() {
        return this.actionForEmailCampaigns;
    }

    public void setActionForEmailCampaigns(ActionForEmailCampaignsEnum actionForEmailCampaigns) {
        this.actionForEmailCampaigns = actionForEmailCampaigns;
    }

    public RequestContactExportCustomContactFilter actionForSmsCampaigns(ActionForSmsCampaignsEnum actionForSmsCampaigns) {
        this.actionForSmsCampaigns = actionForSmsCampaigns;
        return this;
    }

    @ApiModelProperty(value="Mandatory if neither actionForContacts nor actionForEmailCampaigns is passed. This will export the contacts on the basis of provided action applied on sms campaigns. * unsubscribed - Fetch the list of all unsubscribed (blacklisted via any means) contacts for all / particular sms campaigns. * hardBounces & softBounces - Fetch the list of hard bounces / soft bounces for all / particular sms campaigns. ")
    public ActionForSmsCampaignsEnum getActionForSmsCampaigns() {
        return this.actionForSmsCampaigns;
    }

    public void setActionForSmsCampaigns(ActionForSmsCampaignsEnum actionForSmsCampaigns) {
        this.actionForSmsCampaigns = actionForSmsCampaigns;
    }

    public RequestContactExportCustomContactFilter listId(Long listId) {
        this.listId = listId;
        return this;
    }

    @ApiModelProperty(example="2", value="Mandatory if actionForContacts is passed, ignored otherwise. Id of the list for which the corresponding action shall be applied in the filter.")
    public Long getListId() {
        return this.listId;
    }

    public void setListId(Long listId) {
        this.listId = listId;
    }

    public RequestContactExportCustomContactFilter emailCampaignId(Long emailCampaignId) {
        this.emailCampaignId = emailCampaignId;
        return this;
    }

    @ApiModelProperty(example="12", value="Considered only if actionForEmailCampaigns is passed, ignored otherwise. Mandatory if action is one of the following - openers, nonOpeners, clickers, nonClickers, unsubscribed. The id of the email campaign for which the corresponding action shall be applied in the filter.")
    public Long getEmailCampaignId() {
        return this.emailCampaignId;
    }

    public void setEmailCampaignId(Long emailCampaignId) {
        this.emailCampaignId = emailCampaignId;
    }

    public RequestContactExportCustomContactFilter smsCampaignId(Long smsCampaignId) {
        this.smsCampaignId = smsCampaignId;
        return this;
    }

    @ApiModelProperty(example="12", value="Considered only if actionForSmsCampaigns is passed, ignored otherwise. The id of sms campaign for which the corresponding action shall be applied in the filter.")
    public Long getSmsCampaignId() {
        return this.smsCampaignId;
    }

    public void setSmsCampaignId(Long smsCampaignId) {
        this.smsCampaignId = smsCampaignId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestContactExportCustomContactFilter requestContactExportCustomContactFilter = (RequestContactExportCustomContactFilter)o;
        return ObjectUtils.equals((Object)((Object)this.actionForContacts), (Object)((Object)requestContactExportCustomContactFilter.actionForContacts)) && ObjectUtils.equals((Object)((Object)this.actionForEmailCampaigns), (Object)((Object)requestContactExportCustomContactFilter.actionForEmailCampaigns)) && ObjectUtils.equals((Object)((Object)this.actionForSmsCampaigns), (Object)((Object)requestContactExportCustomContactFilter.actionForSmsCampaigns)) && ObjectUtils.equals((Object)this.listId, (Object)requestContactExportCustomContactFilter.listId) && ObjectUtils.equals((Object)this.emailCampaignId, (Object)requestContactExportCustomContactFilter.emailCampaignId) && ObjectUtils.equals((Object)this.smsCampaignId, (Object)requestContactExportCustomContactFilter.smsCampaignId);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.actionForContacts, this.actionForEmailCampaigns, this.actionForSmsCampaigns, this.listId, this.emailCampaignId, this.smsCampaignId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestContactExportCustomContactFilter {\n");
        sb.append("    actionForContacts: ").append(this.toIndentedString((Object)this.actionForContacts)).append("\n");
        sb.append("    actionForEmailCampaigns: ").append(this.toIndentedString((Object)this.actionForEmailCampaigns)).append("\n");
        sb.append("    actionForSmsCampaigns: ").append(this.toIndentedString((Object)this.actionForSmsCampaigns)).append("\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    emailCampaignId: ").append(this.toIndentedString(this.emailCampaignId)).append("\n");
        sb.append("    smsCampaignId: ").append(this.toIndentedString(this.smsCampaignId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionForSmsCampaignsEnum {
        HARDBOUNCES("hardBounces"),
        SOFTBOUNCES("softBounces"),
        UNSUBSCRIBED("unsubscribed");

        private String value;

        private ActionForSmsCampaignsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionForSmsCampaignsEnum fromValue(String text) {
            for (ActionForSmsCampaignsEnum b : ActionForSmsCampaignsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionForSmsCampaignsEnum> {
            public void write(JsonWriter jsonWriter, ActionForSmsCampaignsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionForSmsCampaignsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionForSmsCampaignsEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionForEmailCampaignsEnum {
        OPENERS("openers"),
        NONOPENERS("nonOpeners"),
        CLICKERS("clickers"),
        NONCLICKERS("nonClickers"),
        UNSUBSCRIBED("unsubscribed"),
        HARDBOUNCES("hardBounces"),
        SOFTBOUNCES("softBounces");

        private String value;

        private ActionForEmailCampaignsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionForEmailCampaignsEnum fromValue(String text) {
            for (ActionForEmailCampaignsEnum b : ActionForEmailCampaignsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionForEmailCampaignsEnum> {
            public void write(JsonWriter jsonWriter, ActionForEmailCampaignsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionForEmailCampaignsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionForEmailCampaignsEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionForContactsEnum {
        ALLCONTACTS("allContacts"),
        SUBSCRIBED("subscribed"),
        UNSUBSCRIBED("unsubscribed"),
        UNSUBSCRIBEDPERLIST("unsubscribedPerList");

        private String value;

        private ActionForContactsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionForContactsEnum fromValue(String text) {
            for (ActionForContactsEnum b : ActionForContactsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionForContactsEnum> {
            public void write(JsonWriter jsonWriter, ActionForContactsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionForContactsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionForContactsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

