/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.uikit.R;
import com.sendbird.uikit.consts.MessageGroupType;
import com.sendbird.uikit.databinding.SbViewOtherUserMessageComponentBinding;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.ViewUtils;
import com.sendbird.uikit.widgets.GroupChannelMessageView;

public class OtherUserMessageView
extends GroupChannelMessageView {
    private SbViewOtherUserMessageComponentBinding binding;
    private int editedAppearance;

    @Override
    public SbViewOtherUserMessageComponentBinding getBinding() {
        return this.binding;
    }

    public OtherUserMessageView(Context context) {
        this(context, null);
    }

    public OtherUserMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_user_style);
    }

    public OtherUserMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView_User, defStyle, 0);
        try {
            this.binding = (SbViewOtherUserMessageComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_other_user_message_component, (ViewGroup)this, (boolean)true);
            int timeAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_time_text_appearance, R.style.SendbirdCaption4OnLight03);
            int nicknameAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_sender_name_text_appearance, R.style.SendbirdCaption1OnLight02);
            int messageAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_other_text_appearance, R.style.SendbirdBody3OnLight01);
            int messageBackground = a.getResourceId(R.styleable.MessageView_User_sb_message_other_background, R.drawable.sb_shape_chat_bubble);
            int messageBackgroundTint = a.getResourceId(R.styleable.MessageView_User_sb_message_other_background_tint, R.color.sb_message_other_tint_light);
            int emojiReactionListBackground = a.getResourceId(R.styleable.MessageView_User_sb_message_emoji_reaction_list_background, R.drawable.sb_shape_chat_bubble_reactions_light);
            int ogtagBackground = a.getResourceId(R.styleable.MessageView_User_sb_message_other_ogtag_background, R.drawable.sb_message_og_background);
            int ogtagBackgroundTint = a.getResourceId(R.styleable.MessageView_User_sb_message_other_ogtag_background_tint, R.color.sb_message_other_tint_light);
            int linkTextColor = a.getResourceId(R.styleable.MessageView_User_sb_message_other_link_text_color, R.color.onlight_01);
            int clickedLinkBackgroundColor = a.getResourceId(R.styleable.MessageView_User_sb_message_other_clicked_link_background_color, R.color.primary_100);
            this.editedAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_other_edited_mark_text_appearance, R.style.SendbirdBody3OnLight02);
            this.highlightBackgroundColor = a.getResourceId(R.styleable.MessageView_User_sb_message_highlight_background_color, R.color.highlight);
            this.highlightForegroundColor = a.getResourceId(R.styleable.MessageView_User_sb_message_highlight_foreground_color, R.color.background_600);
            this.binding.tvMessage.setTextAppearance(context, messageAppearance);
            this.binding.tvMessage.setLinkTextColor(context.getResources().getColor(linkTextColor));
            this.binding.contentPanel.setBackground(DrawableUtils.setTintList(this.getContext(), messageBackground, messageBackgroundTint));
            this.binding.tvSentAt.setTextAppearance(context, timeAppearance);
            this.binding.tvNickname.setTextAppearance(context, nicknameAppearance);
            this.binding.emojiReactionListBackground.setBackgroundResource(emojiReactionListBackground);
            this.binding.ogtagBackground.setBackground(DrawableUtils.setTintList(this.getContext(), ogtagBackground, ogtagBackgroundTint));
            this.binding.ovOgtag.setBackground(DrawableUtils.setTintList(this.getContext(), ogtagBackground, ogtagBackgroundTint));
            this.binding.tvMessage.setOnClickListener(v -> this.binding.contentPanel.performClick());
            this.binding.tvMessage.setOnLongClickListener(v -> this.binding.contentPanel.performLongClick());
            this.binding.tvMessage.setOnLinkLongClickListener((v, link) -> this.binding.contentPanel.performLongClick());
            this.binding.tvMessage.setClickedLinkBackgroundColor(context.getResources().getColor(clickedLinkBackgroundColor));
            this.binding.ovOgtag.setOnLongClickListener(v -> this.binding.contentPanel.performLongClick());
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public View getLayout() {
        return this.binding.getRoot();
    }

    @Override
    public void drawMessage(GroupChannel channel, BaseMessage message, MessageGroupType messageGroupType) {
        boolean sendingState = message.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED;
        boolean hasOgTag = message.getOgMetaData() != null;
        boolean hasReaction = message.getReactions() != null && message.getReactions().size() > 0;
        boolean showProfile = messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE || messageGroupType == MessageGroupType.GROUPING_TYPE_TAIL;
        boolean showNickname = messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE || messageGroupType == MessageGroupType.GROUPING_TYPE_HEAD;
        this.binding.ivProfileView.setVisibility(showProfile ? 0 : 4);
        this.binding.tvNickname.setVisibility(showNickname ? 0 : 8);
        this.binding.emojiReactionListBackground.setVisibility(hasReaction ? 0 : 8);
        this.binding.rvEmojiReactionList.setVisibility(hasReaction ? 0 : 8);
        this.binding.ogtagBackground.setVisibility(hasOgTag ? 0 : 8);
        this.binding.ovOgtag.setVisibility(hasOgTag ? 0 : 8);
        this.binding.tvSentAt.setVisibility(sendingState && (messageGroupType == MessageGroupType.GROUPING_TYPE_TAIL || messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE) ? 0 : 8);
        this.binding.tvSentAt.setText((CharSequence)DateUtils.formatTime(this.getContext(), message.getCreatedAt()));
        ViewUtils.drawNickname((TextView)this.binding.tvNickname, message);
        ViewUtils.drawTextMessage((TextView)this.binding.tvMessage, message, this.editedAppearance, this.highlightMessageInfo, this.highlightBackgroundColor, this.highlightForegroundColor);
        ViewUtils.drawOgtag((ViewGroup)this.binding.ovOgtag, message.getOgMetaData());
        ViewUtils.drawReactionEnabled(this.binding.rvEmojiReactionList, (BaseChannel)channel);
        ViewUtils.drawProfile((ImageView)this.binding.ivProfileView, message);
        int paddingTop = this.getResources().getDimensionPixelSize(messageGroupType == MessageGroupType.GROUPING_TYPE_TAIL || messageGroupType == MessageGroupType.GROUPING_TYPE_BODY ? R.dimen.sb_size_1 : R.dimen.sb_size_8);
        int paddingBottom = this.getResources().getDimensionPixelSize(messageGroupType == MessageGroupType.GROUPING_TYPE_HEAD || messageGroupType == MessageGroupType.GROUPING_TYPE_BODY ? R.dimen.sb_size_1 : R.dimen.sb_size_8);
        this.binding.root.setPadding(this.binding.root.getPaddingLeft(), paddingTop, this.binding.root.getPaddingRight(), paddingBottom);
    }
}

