/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.consts.MessageGroupType;
import com.sendbird.uikit.databinding.SbViewOtherFileImageMessageComponentBinding;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.ViewUtils;
import com.sendbird.uikit.widgets.GroupChannelMessageView;

public class OtherImageFileMessageView
extends GroupChannelMessageView {
    private SbViewOtherFileImageMessageComponentBinding binding;

    @Override
    public SbViewOtherFileImageMessageComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public View getLayout() {
        return this.binding.getRoot();
    }

    public OtherImageFileMessageView(Context context) {
        this(context, null);
    }

    public OtherImageFileMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_file_style);
    }

    public OtherImageFileMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView_File, defStyle, 0);
        try {
            this.binding = (SbViewOtherFileImageMessageComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_other_file_image_message_component, (ViewGroup)this, (boolean)true);
            int timeAppearance = a.getResourceId(R.styleable.MessageView_File_sb_message_time_text_appearance, R.style.SendbirdCaption4OnLight03);
            int nicknameAppearance = a.getResourceId(R.styleable.MessageView_File_sb_message_sender_name_text_appearance, R.style.SendbirdCaption1OnLight02);
            int messageBackground = a.getResourceId(R.styleable.MessageView_File_sb_message_other_background, R.drawable.sb_shape_chat_bubble);
            int messageBackgroundTint = a.getResourceId(R.styleable.MessageView_File_sb_message_other_background_tint, R.color.sb_message_other_tint_light);
            int emojiReactionListBackground = a.getResourceId(R.styleable.MessageView_File_sb_message_emoji_reaction_list_background, R.drawable.sb_shape_chat_bubble_reactions_light);
            this.binding.tvSentAt.setTextAppearance(context, timeAppearance);
            this.binding.tvNickname.setTextAppearance(context, nicknameAppearance);
            this.binding.contentPanel.setBackground(DrawableUtils.setTintList(this.getContext(), messageBackground, messageBackgroundTint));
            this.binding.emojiReactionListBackground.setBackgroundResource(emojiReactionListBackground);
            int bg = SendBirdUIKit.isDarkMode() ? R.drawable.sb_shape_image_message_background_dark : R.drawable.sb_shape_image_message_background;
            this.binding.ivThumbnail.setBackgroundResource(bg);
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public void drawMessage(GroupChannel channel, BaseMessage message, MessageGroupType messageGroupType) {
        boolean sendingState = message.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED;
        boolean hasReaction = message.getReactions() != null && message.getReactions().size() > 0;
        boolean showProfile = messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE || messageGroupType == MessageGroupType.GROUPING_TYPE_TAIL;
        boolean showNickname = messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE || messageGroupType == MessageGroupType.GROUPING_TYPE_HEAD;
        this.binding.ivProfileView.setVisibility(showProfile ? 0 : 4);
        this.binding.tvNickname.setVisibility(showNickname ? 0 : 8);
        this.binding.emojiReactionListBackground.setVisibility(hasReaction ? 0 : 8);
        this.binding.rvEmojiReactionList.setVisibility(hasReaction ? 0 : 8);
        this.binding.tvSentAt.setVisibility(sendingState && (messageGroupType == MessageGroupType.GROUPING_TYPE_TAIL || messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE) ? 0 : 8);
        this.binding.tvSentAt.setText((CharSequence)DateUtils.formatTime(this.getContext(), message.getCreatedAt()));
        ViewUtils.drawNickname((TextView)this.binding.tvNickname, message);
        ViewUtils.drawReactionEnabled(this.binding.rvEmojiReactionList, (BaseChannel)channel);
        ViewUtils.drawProfile((ImageView)this.binding.ivProfileView, message);
        ViewUtils.drawThumbnail(this.binding.ivThumbnail, (FileMessage)message);
        ViewUtils.drawThumbnailIcon((ImageView)this.binding.ivThumbnailIcon, (FileMessage)message);
        int paddingTop = this.getResources().getDimensionPixelSize(messageGroupType == MessageGroupType.GROUPING_TYPE_TAIL || messageGroupType == MessageGroupType.GROUPING_TYPE_BODY ? R.dimen.sb_size_1 : R.dimen.sb_size_8);
        int paddingBottom = this.getResources().getDimensionPixelSize(messageGroupType == MessageGroupType.GROUPING_TYPE_HEAD || messageGroupType == MessageGroupType.GROUPING_TYPE_BODY ? R.dimen.sb_size_1 : R.dimen.sb_size_8);
        this.binding.root.setPadding(this.binding.root.getPaddingLeft(), paddingTop, this.binding.root.getPaddingRight(), paddingBottom);
    }
}

