/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.MessageSearchQuery;
import com.sendbird.uikit.interfaces.OnListResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class SearchViewModel
extends BaseViewModel
implements LifecycleObserver,
PagerRecyclerView.Pageable<List<BaseMessage>> {
    private final MutableLiveData<List<BaseMessage>> searchResultList = new MutableLiveData();
    private final GroupChannel channel;
    private final long searchFrom;
    private MessageSearchQuery query;

    SearchViewModel(GroupChannel channel, @NonNull MessageSearchQuery query) {
        this.channel = channel;
        this.searchFrom = channel.getInvitedAt();
        this.query = query;
    }

    private MessageSearchQuery createMessageSearchQuery(@NonNull String keyword) {
        if (this.query != null) {
            return new MessageSearchQuery.Builder(this.query).setChannelUrl(this.channel.getUrl()).setKeyword(keyword).setOrder(MessageSearchQuery.Order.TIMESTAMP).build();
        }
        return new MessageSearchQuery.Builder().setChannelUrl(this.channel.getUrl()).setKeyword(keyword).setLimit(40).setMessageTimestampFrom(this.searchFrom).setOrder(MessageSearchQuery.Order.TIMESTAMP).setReverse(false).build();
    }

    public LiveData<List<BaseMessage>> getSearchResultList() {
        return this.searchResultList;
    }

    public void search(@NonNull String keyword, OnListResultHandler<BaseMessage> handler) {
        if (TextUtils.isEmpty(keyword)) {
            return;
        }
        this.query = this.createMessageSearchQuery(keyword.trim());
        List value = (List)this.searchResultList.getValue();
        if (value != null) {
            value.clear();
        }
        this.query.next((queryResult, e) -> {
            if (handler != null) {
                handler.onResult(queryResult, e);
            }
            this.onResult(queryResult, (Exception)((Object)e));
        });
    }

    public String getKeyword() {
        return this.query.getKeyword();
    }

    private void onResult(List<BaseMessage> results, Exception e) {
        if (e != null) {
            Logger.w(e);
            return;
        }
        ArrayList<BaseMessage> newDataList = new ArrayList<BaseMessage>();
        if (results != null && results.size() > 0) {
            newDataList.addAll(results);
            List origin = (List)this.searchResultList.getValue();
            if (origin != null) {
                newDataList.addAll(0, origin);
                Logger.d("____________ onResult origin=%s", origin.size());
            }
        }
        Logger.d("____________ onResult newDataList=%s", newDataList.size());
        this.searchResultList.postValue(newDataList);
    }

    @Override
    public List<BaseMessage> loadPrevious() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BaseMessage> loadNext() {
        Logger.d("____________ loadNext hasNext=%s", this.query.hasNext());
        if (this.query.hasNext()) {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference result = new AtomicReference();
            AtomicReference<Exception> error = new AtomicReference<Exception>();
            try {
                this.query.next((queryResult, e) -> {
                    try {
                        if (e != null) {
                            error.set((Exception)((Object)e));
                            return;
                        }
                        result.set(queryResult);
                    }
                    finally {
                        latch.countDown();
                    }
                });
                latch.await();
            }
            catch (Exception e2) {
                error.set(e2);
            }
            finally {
                this.onResult((List)result.get(), (Exception)error.get());
            }
            return (List)result.get();
        }
        return Collections.emptyList();
    }
}

