/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import java.lang.ref.WeakReference;

public final class SpannableStringBuilder {
    private final Context context;
    private CharSequence origin;

    public SpannableStringBuilder(@NonNull Context context) {
        this(context, "");
    }

    public SpannableStringBuilder(@NonNull Context context, @NonNull CharSequence origin) {
        this.context = context;
        this.origin = origin;
    }

    public SpannableStringBuilder(@NonNull Context context, @StringRes int textResId) {
        this.context = context;
        this.origin = context.getString(textResId);
    }

    public SpannableStringBuilder addTextColorSpan(@StringRes int text, @ColorRes int color2) {
        return this.addTextColorSpan(this.context.getString(text), color2);
    }

    public SpannableStringBuilder addTextColorSpan(@NonNull CharSequence text, @ColorRes int color2) {
        SpannableString newValue = new SpannableString(text);
        newValue.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)this.context, (int)color2)), 0, newValue.length(), 33);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{this.origin, newValue});
        return this;
    }

    public SpannableStringBuilder addUnderlineSpan(@StringRes int text) {
        return this.addUnderlineSpan(text);
    }

    public SpannableStringBuilder addUnderlineSpan(@NonNull CharSequence text) {
        SpannableString newValue = new SpannableString(text);
        newValue.setSpan((Object)new UnderlineSpan(), 0, newValue.length(), 33);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{this.origin, newValue});
        return this;
    }

    public SpannableStringBuilder addStrikeSpan(@StringRes int text) {
        return this.addStrikeSpan(this.context.getString(text));
    }

    public SpannableStringBuilder addStrikeSpan(@NonNull CharSequence text) {
        SpannableString newValue = new SpannableString(text);
        newValue.setSpan((Object)new StrikethroughSpan(), 0, newValue.length(), 33);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{this.origin, newValue});
        return this;
    }

    public SpannableStringBuilder setStrikeSpan(int start, int end) {
        SpannableString newValue = new SpannableString(this.origin);
        newValue.setSpan((Object)new StrikethroughSpan(), start, end, 33);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{"", newValue});
        return this;
    }

    public SpannableStringBuilder addSizeSpan(@NonNull CharSequence text, float proportion) {
        SpannableString newValue = new SpannableString(text);
        newValue.setSpan((Object)new RelativeSizeSpan(proportion), 0, newValue.length(), 33);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{this.origin, newValue});
        return this;
    }

    public SpannableStringBuilder setSizeSpan(float proportion, int start, int end) {
        SpannableString newValue = new SpannableString(this.origin);
        newValue.setSpan((Object)new RelativeSizeSpan(proportion), start, end, 33);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{"", newValue});
        return this;
    }

    public SpannableStringBuilder addImageSpan(@NonNull CharSequence text, @DrawableRes int imgResId) {
        SpannableString newValue = new SpannableString(this.origin);
        newValue.setSpan((Object)new CenteredImageSpan(this.context, imgResId), 0, text.length(), 17);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{"", newValue});
        return this;
    }

    public SpannableStringBuilder addImageSpan(@NonNull CharSequence text, @NonNull Drawable drawable2) {
        SpannableString newValue = new SpannableString(this.origin);
        newValue.setSpan((Object)new CenteredImageSpan(this.context, drawable2), 0, text.length(), 17);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{"", newValue});
        return this;
    }

    public SpannableStringBuilder addStyleSpan(@StringRes int text, int typeFace) {
        return this.addStyleSpan(this.context.getString(text), typeFace);
    }

    public SpannableStringBuilder addStyleSpan(@NonNull CharSequence text, int typeFace) {
        SpannableString newValue = new SpannableString(text);
        newValue.setSpan((Object)new StyleSpan(typeFace), 0, newValue.length(), 17);
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{this.origin, newValue});
        return this;
    }

    public SpannableStringBuilder addHighlightTextSpan(@NonNull String text, @NonNull String highlightText, @ColorRes int highlightBackgroundColor, @ColorRes int highlightForegroundColor) {
        int start = text.toLowerCase().indexOf(highlightText.toLowerCase());
        if (start >= 0) {
            SpannableString newValue = new SpannableString((CharSequence)text);
            newValue.setSpan((Object)new BackgroundColorSpan(ContextCompat.getColor((Context)this.context, (int)highlightBackgroundColor)), start, start + highlightText.length(), 17);
            newValue.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)this.context, (int)highlightForegroundColor)), start, start + highlightText.length(), 33);
            this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{"", newValue});
        }
        return this;
    }

    public SpannableStringBuilder addText(@StringRes int text) {
        return this.addText(this.context.getString(text));
    }

    public SpannableStringBuilder addText(@NonNull CharSequence text) {
        this.origin = TextUtils.concat((CharSequence[])new CharSequence[]{this.origin, text});
        return this;
    }

    public int length() {
        return this.origin.length();
    }

    public CharSequence build() {
        return this.origin;
    }

    private static class CenteredImageSpan
    extends ImageSpan {
        private WeakReference<Drawable> drawableRef;

        public CenteredImageSpan(Context context, int drawableRes) {
            super(context, drawableRes);
        }

        public CenteredImageSpan(Context context, Drawable drawable2) {
            super(drawable2);
        }

        public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            if (fm != null) {
                Paint.FontMetricsInt pfm = paint.getFontMetricsInt();
                fm.ascent = pfm.ascent;
                fm.descent = pfm.descent;
                fm.top = pfm.top;
                fm.bottom = pfm.bottom;
            }
            return rect.right;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable b = this.getCachedDrawable();
            canvas.save();
            int drawableHeight = b.getIntrinsicHeight();
            int fontAscent = paint.getFontMetricsInt().ascent;
            int fontDescent = paint.getFontMetricsInt().descent;
            int transY = bottom - b.getBounds().bottom + (drawableHeight - fontDescent + fontAscent) / 2;
            canvas.translate(x, (float)transY);
            b.draw(canvas);
            canvas.restore();
        }

        private Drawable getCachedDrawable() {
            WeakReference<Drawable> wr = this.drawableRef;
            Drawable d = null;
            if (wr != null) {
                d = (Drawable)wr.get();
            }
            if (d == null) {
                d = this.getDrawable();
                this.drawableRef = new WeakReference<Drawable>(d);
            }
            return d;
        }
    }
}

