/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.os.Build;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.exifinterface.media.ExifInterface;
import com.sendbird.uikit.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ImageUtils {
    public static final int DEFAULT_THUMBNAIL_WIDTH = 600;
    public static final int DEFAULT_THUMBNAIL_HEIGHT = 600;

    public static int exifOrientationToDegrees(int exifOrientation) {
        if (exifOrientation == 6) {
            return 90;
        }
        if (exifOrientation == 3) {
            return 180;
        }
        if (exifOrientation == 8) {
            return 270;
        }
        return 0;
    }

    public static Bitmap rotate(Bitmap bitmap, float degree) {
        Matrix matrix = new Matrix();
        matrix.postRotate(degree);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static int calculateInSampleSize(InputStream input, int width, int height) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPurgeable = true;
        options.inDither = true;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
        return ImageUtils.calculateInSampleSize(options.outWidth, options.outHeight, width, height);
    }

    public static int calculateInSampleSize(@NonNull String filePath, int width, int height) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPurgeable = true;
        options.inDither = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        return ImageUtils.calculateInSampleSize(options.outWidth, options.outHeight, width, height);
    }

    private static int calculateInSampleSize(int width, int height, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        Logger.d("++ width=%s, height=%s, reqWidth=%s, reqHeight=%s", width, height, reqWidth, reqHeight);
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        Logger.d("++ inSampleSize=%s", inSampleSize);
        return inSampleSize;
    }

    public static Bitmap getBitmap(@NonNull String path, int width, int height) throws IOException {
        ExifInterface exif = new ExifInterface(path);
        int exifOrientation = exif.getAttributeInt("Orientation", 1);
        int exifDegree = ImageUtils.exifOrientationToDegrees(exifOrientation);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        options.inSampleSize = ImageUtils.calculateInSampleSize(path, width, height);
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        if ((float)exifDegree != 0.0f) {
            Bitmap originBitmap = bitmap;
            bitmap = ImageUtils.rotate(bitmap, exifDegree);
            originBitmap.recycle();
        }
        return bitmap;
    }

    public static Bitmap getThumbnailBitmap(@NonNull String path, @NonNull String mimeType) throws IOException {
        if (mimeType.startsWith("image")) {
            return ImageUtils.getBitmap(path, 600, 600);
        }
        if (mimeType.startsWith("video")) {
            if (Build.VERSION.SDK_INT >= 29) {
                return ThumbnailUtils.createVideoThumbnail((File)new File(path), (Size)new Size(600, 600), null);
            }
            return ThumbnailUtils.createVideoThumbnail((String)path, (int)1);
        }
        return null;
    }

    public static Pair<Integer, Integer> getDimensions(@NonNull String path, @NonNull String mimeType) {
        int width = 0;
        int height = 0;
        if (mimeType.startsWith("image")) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inSampleSize = ImageUtils.calculateInSampleSize(path, 600, 600);
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            width = options.outWidth;
            height = options.outHeight;
        } else if (mimeType.startsWith("video")) {
            Bitmap bitmap = null;
            if (Build.VERSION.SDK_INT >= 29) {
                try {
                    bitmap = ThumbnailUtils.createVideoThumbnail((File)new File(path), (Size)new Size(600, 600), null);
                }
                catch (IOException e) {
                    Logger.w(e);
                }
            } else {
                bitmap = ThumbnailUtils.createVideoThumbnail((String)path, (int)1);
            }
            if (bitmap != null) {
                width = bitmap.getWidth();
                height = bitmap.getHeight();
            }
        }
        return new Pair((Object)width, (Object)height);
    }

    public static Drawable resize(Resources resources, Drawable drawable2, @DimenRes int width, @DimenRes int height) {
        if (drawable2 == null) {
            return null;
        }
        Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
        Bitmap bitmapResized = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)resources.getDimension(width)), (int)((int)resources.getDimension(height)), (boolean)false);
        drawable2 = new BitmapDrawable(resources, bitmapResized);
        return drawable2;
    }
}

