/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import com.sendbird.android.FileMessage;
import com.sendbird.uikit.log.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FileUtils {
    public static File getDocumentCacheDir(@NonNull Context context) {
        File dir = new File(context.getCacheDir(), "documents");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File createDownloadFile(@NonNull String fileName) {
        String imageFileName = "Downloaded_file_" + System.currentTimeMillis() + "_" + fileName;
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return new File(dir, imageFileName);
    }

    public static File getDownloadFileFromMessage(@NonNull FileMessage message) {
        String newFileName = "Downloaded_file_" + message.getMessageId() + "_" + message.getName();
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return new File(dir, newFileName);
    }

    public static boolean hasDownloadFileFromMessage(@NonNull FileMessage message) {
        File file = FileUtils.getDownloadFileFromMessage(message);
        return file.exists() && file.length() > 0L;
    }

    public static Uri fileToUri(@NonNull Context context, @NonNull File file) {
        return FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".provider"), (File)file);
    }

    public static String extractExtension(@NonNull Context context, @NonNull Uri uri) {
        String extension = uri.getScheme().equals("content") ? FileUtils.extractExtension(context.getContentResolver().getType(uri)) : MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
        return extension;
    }

    public static String extractExtension(@NonNull String mimeType) {
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        return mime.getExtensionFromMimeType(mimeType);
    }

    public static Bitmap.CompressFormat extractBitmapFormat(@NonNull String mimeType) {
        Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
        if (mimeType.endsWith("jpeg") || mimeType.endsWith("jpg")) {
            format = Bitmap.CompressFormat.JPEG;
        } else if (mimeType.endsWith("png")) {
            format = Bitmap.CompressFormat.PNG;
        } else if (mimeType.endsWith("webp")) {
            format = Bitmap.CompressFormat.WEBP;
        }
        return format;
    }

    private static String copyFromUri(@NonNull Context context, @NonNull Uri uri, @NonNull File dstFile) {
        if (!dstFile.exists() || dstFile.length() <= 0L) {
            try {
                InputStream inputStream = context.getContentResolver().openInputStream(uri);
                FileOutputStream outputStream = new FileOutputStream(dstFile);
                FileUtils.copy(inputStream, outputStream);
            }
            catch (Exception e) {
                Logger.e(e);
            }
        }
        return dstFile.getAbsolutePath();
    }

    public static String uriToPath(@NonNull Context context, @NonNull Uri uri) {
        String tempFileName = "Temp_" + uri.hashCode() + "." + FileUtils.extractExtension(context, uri);
        File dstFile = FileUtils.createCachedDirFile(context, tempFileName);
        return FileUtils.copyFromUri(context, uri, dstFile);
    }

    public static File uriToFile(@NonNull Context context, @NonNull Uri uri) {
        return new File(FileUtils.uriToPath(context, uri));
    }

    public static File saveFile(@NonNull Context context, @NonNull File src, @NonNull String fileName) throws Exception {
        File newFile = FileUtils.createDownloadFile(fileName);
        return FileUtils.saveFile(context, src, newFile);
    }

    public static File saveFile(@NonNull Context context, @NonNull File src, @NonNull File dest) throws Exception {
        FileInputStream input = new FileInputStream(src);
        FileOutputStream output = new FileOutputStream(dest);
        FileUtils.copy(input, output);
        FileUtils.galleryAddPic(context, dest.getAbsolutePath());
        return dest;
    }

    public static File bitmapToFile(@NonNull Bitmap image, @NonNull File dest, @NonNull Bitmap.CompressFormat format) throws IOException {
        return FileUtils.bitmapToFile(image, dest, 100, format);
    }

    public static File bitmapToFile(@NonNull Bitmap image, @NonNull File dest, int quality, @NonNull Bitmap.CompressFormat format) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(dest, false);){
            Logger.d("++ Create bitmap to file, quality=%s, format=%s", quality, format);
            image.compress(format, quality, (OutputStream)outputStream);
        }
        return dest;
    }

    private static void galleryAddPic(Context context, String imagePath) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File f = new File(imagePath);
        Uri contentUri = Uri.fromFile((File)f);
        mediaScanIntent.setData(contentUri);
        context.sendBroadcast(mediaScanIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copy(InputStream input, OutputStream output) throws Exception {
        int BUFFER_SIZE = 2048;
        byte[] buffer = new byte[BUFFER_SIZE];
        BufferedInputStream in = new BufferedInputStream(input, BUFFER_SIZE);
        BufferedOutputStream out = new BufferedOutputStream(output, BUFFER_SIZE);
        int count = 0;
        try {
            int n;
            while ((n = in.read(buffer, 0, BUFFER_SIZE)) != -1) {
                out.write(buffer, 0, n);
                count += n;
            }
            out.flush();
        }
        finally {
            out.close();
            in.close();
        }
        return count;
    }

    public static Uri createPictureImageUri(@NonNull Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        ContentValues cv = new ContentValues();
        String fileName = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        cv.put("title", fileName);
        return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cv);
    }

    private static void deleteRecursive(File fileOrDirectory) {
        File[] list;
        if (fileOrDirectory.isDirectory() && (list = fileOrDirectory.listFiles()) != null) {
            for (File child : list) {
                FileUtils.deleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    public static void removeDeletableDir(@NonNull Context context) {
        File dir = FileUtils.getDeletableDir(context);
        FileUtils.deleteRecursive(dir);
    }

    public static File getDeletableDir(@NonNull Context context) {
        File dir = context.getCacheDir();
        File file = new File(dir, "deletable");
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    public static File createDeletableFile(@NonNull Context context, @NonNull String fileName) {
        return new File(FileUtils.getDeletableDir(context), fileName);
    }

    public static File createCachedDirFile(@NonNull Context context, @NonNull String fileName) {
        File dir = context.getCacheDir();
        return new File(dir, fileName);
    }
}

