/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.viewholder;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.uikit.consts.MessageGroupType;
import com.sendbird.uikit.model.HighlightMessageInfo;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.MessageUtils;

public abstract class MessageViewHolder
extends RecyclerView.ViewHolder {
    protected ViewDataBinding binding;
    protected HighlightMessageInfo highlight;
    private boolean isNewDate = false;
    private boolean isMine = false;
    private boolean isShowProfile = false;
    private boolean useMessageGroupUI = true;

    public MessageViewHolder(View view) {
        super(view);
    }

    MessageViewHolder(@NonNull ViewDataBinding binding, boolean useMessageGroupUI) {
        super(binding.getRoot());
        this.binding = binding;
        this.useMessageGroupUI = useMessageGroupUI;
    }

    public void onBindViewHolder(BaseChannel channel, @Nullable BaseMessage prevMessage, @NonNull BaseMessage message, @Nullable BaseMessage nextMessage) {
        this.isNewDate = prevMessage != null ? !DateUtils.hasSameDate(message.getCreatedAt(), prevMessage.getCreatedAt()) : true;
        this.isMine = MessageUtils.isMine(message);
        this.isShowProfile = !this.isMine;
        this.bind(channel, message, this.useMessageGroupUI ? MessageUtils.getMessageGroupType(prevMessage, message, nextMessage) : MessageGroupType.GROUPING_TYPE_SINGLE);
        if (this.binding != null) {
            this.binding.executePendingBindings();
        }
        if (this.getClickableView() != null) {
            this.getClickableView().requestLayout();
        }
    }

    public void setHighlightInfo(@Nullable HighlightMessageInfo highlightInfo) {
        this.highlight = highlightInfo;
    }

    protected boolean isNewDate() {
        return this.isNewDate;
    }

    protected boolean isShowProfile() {
        return this.isShowProfile;
    }

    protected boolean isMine() {
        return this.isMine;
    }

    public abstract void bind(BaseChannel var1, @NonNull BaseMessage var2, MessageGroupType var3);

    public abstract View getClickableView();
}

