/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.uikit.activities.adapter.BaseMessageAdapter;
import com.sendbird.uikit.activities.adapter.MessageDiffCallback;
import com.sendbird.uikit.activities.viewholder.GroupChannelMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MessageType;
import com.sendbird.uikit.activities.viewholder.MessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MessageViewHolderFactory;
import com.sendbird.uikit.activities.viewholder.OtherMessageViewHolder;
import com.sendbird.uikit.interfaces.OnEmojiReactionClickListener;
import com.sendbird.uikit.interfaces.OnEmojiReactionLongClickListener;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.model.HighlightMessageInfo;
import com.sendbird.uikit.utils.ReactionUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageListAdapter
extends BaseMessageAdapter<BaseMessage, MessageViewHolder> {
    private final List<BaseMessage> messageList = new ArrayList<BaseMessage>();
    private GroupChannel channel;
    private OnItemClickListener<BaseMessage> profileClickListener;
    private OnItemClickListener<BaseMessage> listener;
    private OnItemLongClickListener<BaseMessage> longClickListener;
    private OnEmojiReactionClickListener emojiReactionClickListener;
    private OnEmojiReactionLongClickListener emojiReactionLongClickListener;
    private OnItemClickListener<BaseMessage> emojiReactionMoreButtonClickListener;
    private final boolean useMessageGroupUI;
    private HighlightMessageInfo highlight;

    public MessageListAdapter() {
        this(null);
    }

    public MessageListAdapter(GroupChannel channel) {
        this(channel, null);
    }

    public MessageListAdapter(GroupChannel channel, OnItemClickListener<BaseMessage> listener) {
        this(channel, listener, null);
    }

    public MessageListAdapter(GroupChannel channel, OnItemClickListener<BaseMessage> listener, OnItemLongClickListener<BaseMessage> longClickListener) {
        this(channel, listener, longClickListener, true);
    }

    public MessageListAdapter(GroupChannel channel, OnItemClickListener<BaseMessage> listener, OnItemLongClickListener<BaseMessage> longClickListener, boolean useMessageGroupUI) {
        this.channel = channel != null ? GroupChannel.clone((GroupChannel)channel) : null;
        this.listener = listener;
        this.longClickListener = longClickListener;
        this.useMessageGroupUI = useMessageGroupUI;
        this.setHasStableIds(true);
    }

    @NonNull
    public MessageViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        MessageViewHolder viewHolder = MessageViewHolderFactory.createViewHolder(inflater, parent, MessageType.from(viewType), this.useMessageGroupUI);
        viewHolder.setHighlightInfo(this.highlight);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull MessageViewHolder holder, int position) {
        View profileView;
        BaseMessage prev = null;
        BaseMessage next = null;
        BaseMessage current = this.getItem(position);
        int itemCount = this.getItemCount();
        if (position < itemCount - 1) {
            prev = this.getItem(position + 1);
        }
        if (position > 0) {
            next = this.getItem(position - 1);
        }
        if (holder.getClickableView() != null) {
            holder.getClickableView().setOnClickListener(v -> {
                int messagePosition = holder.getAdapterPosition();
                if (messagePosition != -1 && this.listener != null) {
                    this.listener.onItemClick(v, messagePosition, this.getItem(messagePosition));
                }
            });
            holder.getClickableView().setOnLongClickListener(v -> {
                int messagePosition = holder.getAdapterPosition();
                if (messagePosition != -1 && this.longClickListener != null) {
                    this.longClickListener.onItemLongClick(v, messagePosition, this.getItem(messagePosition));
                    return true;
                }
                return false;
            });
            if (ReactionUtils.useReaction((BaseChannel)this.channel) && holder instanceof GroupChannelMessageViewHolder) {
                GroupChannelMessageViewHolder groupChannelHolder = (GroupChannelMessageViewHolder)holder;
                groupChannelHolder.setEmojiReaction(current.getReactions(), (view, reactionPosition, reactionKey) -> {
                    int messagePosition = holder.getAdapterPosition();
                    if (messagePosition != -1 && this.emojiReactionClickListener != null) {
                        this.emojiReactionClickListener.onEmojiReactionClick(view, reactionPosition, this.getItem(messagePosition), (String)reactionKey);
                    }
                }, (view, reactionPosition, reactionKey) -> {
                    int messagePosition = groupChannelHolder.getAdapterPosition();
                    if (messagePosition != -1 && this.emojiReactionLongClickListener != null) {
                        this.emojiReactionLongClickListener.onEmojiReactionLongClick(view, reactionPosition, this.getItem(messagePosition), (String)reactionKey);
                    }
                }, v -> {
                    int messagePosition = groupChannelHolder.getAdapterPosition();
                    if (messagePosition != -1 && this.emojiReactionMoreButtonClickListener != null) {
                        this.emojiReactionMoreButtonClickListener.onItemClick(v, messagePosition, this.getItem(messagePosition));
                    }
                });
            }
        }
        if (holder instanceof OtherMessageViewHolder && (profileView = ((OtherMessageViewHolder)holder).getProfileView()) != null) {
            profileView.setOnClickListener(v -> {
                int messagePosition = holder.getAdapterPosition();
                if (messagePosition != -1 && this.profileClickListener != null) {
                    this.profileClickListener.onItemClick(v, messagePosition, this.getItem(messagePosition));
                }
            });
        }
        holder.onBindViewHolder((BaseChannel)this.channel, prev, current, next);
    }

    public void setHighlightInfo(@Nullable HighlightMessageInfo highlightInfo) {
        this.highlight = highlightInfo;
    }

    public int getItemViewType(int position) {
        BaseMessage message = this.getItem(position);
        return MessageViewHolderFactory.getViewType(message);
    }

    @Override
    public long getItemId(int position) {
        BaseMessage item = this.getItem(position);
        if (TextUtils.isEmpty(item.getRequestId())) {
            return item.getMessageId();
        }
        try {
            return Long.parseLong(item.getRequestId());
        }
        catch (Exception e) {
            return item.getMessageId();
        }
    }

    public void setChannel(@NonNull GroupChannel channel) {
        this.channel = GroupChannel.clone((GroupChannel)channel);
    }

    public void setItems(GroupChannel channel, List<BaseMessage> messageList) {
        MessageDiffCallback diffCallback = new MessageDiffCallback(this.channel, channel, this.messageList, messageList, this.useMessageGroupUI);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.messageList.clear();
        this.messageList.addAll(messageList);
        this.channel = GroupChannel.clone((GroupChannel)channel);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<BaseMessage> listener) {
        this.listener = listener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<BaseMessage> listener) {
        this.longClickListener = listener;
    }

    public void setEmojiReactionClickListener(@Nullable OnEmojiReactionClickListener listener) {
        this.emojiReactionClickListener = listener;
    }

    public void setEmojiReactionLongClickListener(@Nullable OnEmojiReactionLongClickListener listener) {
        this.emojiReactionLongClickListener = listener;
    }

    public void setEmojiReactionMoreButtonClickListener(@Nullable OnItemClickListener<BaseMessage> listener) {
        this.emojiReactionMoreButtonClickListener = listener;
    }

    public void setOnProfileClickListener(OnItemClickListener<BaseMessage> profileClickListener) {
        this.profileClickListener = profileClickListener;
    }

    public int getItemCount() {
        return this.messageList == null ? 0 : this.messageList.size();
    }

    @Override
    public BaseMessage getItem(int position) {
        return this.messageList.get(position);
    }

    @Override
    public List<BaseMessage> getItems() {
        return this.messageList != null ? Collections.unmodifiableList(this.messageList) : null;
    }
}

