/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import com.sendbird.android.GroupChannel;
import com.sendbird.uikit.activities.adapter.ChannelListAdapter;
import java.util.List;

class ChannelDiffCallback
extends DiffUtil.Callback {
    private final List<ChannelListAdapter.ChannelInfo> oldChannelList;
    private final List<GroupChannel> newChannelList;

    ChannelDiffCallback(@NonNull List<ChannelListAdapter.ChannelInfo> oldChannelList, @NonNull List<GroupChannel> newChannelList) {
        this.oldChannelList = oldChannelList;
        this.newChannelList = newChannelList;
    }

    public int getOldListSize() {
        return this.oldChannelList.size();
    }

    public int getNewListSize() {
        return this.newChannelList.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        ChannelListAdapter.ChannelInfo oldChannel = this.oldChannelList.get(oldItemPosition);
        GroupChannel newChannel = this.newChannelList.get(newItemPosition);
        if (!newChannel.getUrl().equals(oldChannel.getChannelUrl())) {
            return false;
        }
        return newChannel.getCreatedAt() == oldChannel.getCreatedAt();
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        String channelName;
        String newLastMessage;
        ChannelListAdapter.ChannelInfo oldChannel = this.oldChannelList.get(oldItemPosition);
        GroupChannel newChannel = this.newChannelList.get(newItemPosition);
        if (!this.areItemsTheSame(oldItemPosition, newItemPosition)) {
            return false;
        }
        String lastMessage = oldChannel.getLastMessage();
        String string2 = newLastMessage = newChannel.getLastMessage() != null ? newChannel.getLastMessage().getMessage() : "";
        if (!newLastMessage.equals(lastMessage)) {
            return false;
        }
        if (oldChannel.getPushTriggerOption() != newChannel.getMyPushTriggerOption()) {
            return false;
        }
        if (oldChannel.getUnreadMessageCount() != newChannel.getUnreadMessageCount()) {
            return false;
        }
        if (oldChannel.getMemberCount() != newChannel.getMemberCount()) {
            return false;
        }
        if (oldChannel.isFrozen() != newChannel.isFrozen()) {
            return false;
        }
        if (oldChannel.getCoverImageHash() != ChannelListAdapter.ChannelInfo.toUrlsHash(newChannel)) {
            return false;
        }
        String string3 = channelName = oldChannel.getChannelName() != null ? oldChannel.getChannelName() : "";
        if (!channelName.equals(newChannel.getName())) {
            return false;
        }
        String coverUrl = oldChannel.getCoverImageUrl() != null ? oldChannel.getCoverImageUrl() : "";
        return coverUrl.equals(newChannel.getCoverUrl());
    }
}

