/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.fragments.ChannelFragment;
import com.sendbird.uikit.model.HighlightMessageInfo;
import com.sendbird.uikit.utils.ContextUtils;
import com.sendbird.uikit.utils.TextUtils;

public class ChannelActivity
extends AppCompatActivity {
    public static Intent newIntent(@NonNull Context context, @NonNull String channelUrl) {
        return ChannelActivity.newIntentFromCustomActivity(context, ChannelActivity.class, channelUrl);
    }

    public static Intent newIntentFromCustomActivity(@NonNull Context context, @NonNull Class<? extends ChannelActivity> cls, @NonNull String channelUrl) {
        return new IntentBuilder(context, cls, channelUrl).build();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SendBirdUIKit.isDarkMode() ? R.style.SendBird_Dark : R.style.SendBird);
        this.setContentView(R.layout.sb_activity);
        String url = this.getIntent().getStringExtra("KEY_CHANNEL_URL");
        if (TextUtils.isEmpty(url)) {
            ContextUtils.toastError((Context)this, R.string.sb_text_error_get_channel);
        } else {
            ChannelFragment fragment = this.createChannelFragment(url);
            FragmentManager manager = this.getSupportFragmentManager();
            manager.popBackStack();
            manager.beginTransaction().replace(R.id.sb_fragment_container, (Fragment)fragment).commit();
        }
    }

    protected ChannelFragment createChannelFragment(@NonNull String channelUrl) {
        Intent intent = this.getIntent();
        ChannelFragment.Builder builder = new ChannelFragment.Builder(channelUrl).setUseHeader(true).setStartingPoint(intent.getLongExtra("KEY_STARTING_POINT", Long.MAX_VALUE));
        if (intent.hasExtra("KEY_HIGHLIGHT_MESSAGE_INFO")) {
            builder.setHighlightMessageInfo((HighlightMessageInfo)intent.getParcelableExtra("KEY_HIGHLIGHT_MESSAGE_INFO"));
        }
        if (intent.hasExtra("KEY_FROM_SEARCH_RESULT")) {
            builder.setUseHeaderRightButton(intent.getBooleanExtra("KEY_FROM_SEARCH_RESULT", false));
        }
        return builder.build();
    }

    public static class IntentBuilder {
        private final Context context;
        private final String channelUrl;
        private long startingPoint = Long.MAX_VALUE;
        private HighlightMessageInfo highlightMessageInfo;
        private Class<? extends ChannelActivity> customClass = ChannelActivity.class;

        public IntentBuilder(@NonNull Context context, @NonNull String channelUrl) {
            this.context = context;
            this.channelUrl = channelUrl;
        }

        public IntentBuilder(@NonNull Context context, @NonNull Class<? extends ChannelActivity> customClass, @NonNull String channelUrl) {
            this.context = context;
            this.channelUrl = channelUrl;
            this.customClass = customClass;
        }

        public IntentBuilder setStartingPoint(long startingPoint) {
            this.startingPoint = startingPoint;
            return this;
        }

        public IntentBuilder setHighlightMessageInfo(HighlightMessageInfo highlightMessageInfo) {
            this.highlightMessageInfo = highlightMessageInfo;
            return this;
        }

        public Intent build() {
            Intent intent = new Intent(this.context, this.customClass);
            intent.putExtra("KEY_CHANNEL_URL", this.channelUrl);
            intent.putExtra("KEY_STARTING_POINT", this.startingPoint);
            if (this.highlightMessageInfo != null) {
                intent.putExtra("KEY_HIGHLIGHT_MESSAGE_INFO", (Parcelable)this.highlightMessageInfo);
            }
            return intent;
        }
    }
}

